/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.service.blackout;

import akka.actor.Actor;
import akka.actor.ActorRef;
import com.codahale.metrics.annotation.Timed;
import com.xebialabs.xlrelease.actors.ReleaseActorService;
import com.xebialabs.xlrelease.actors.ReleaseExecutionActor;
import com.xebialabs.xlrelease.actors.ReleaseExecutionActorMessages;
import com.xebialabs.xlrelease.actors.extension.ActorExtensionHandlerFactory;
import com.xebialabs.xlrelease.domain.Release;
import com.xebialabs.xlrelease.domain.Task;
import com.xebialabs.xlrelease.domain.blackout.BlackoutMetadata;
import com.xebialabs.xlrelease.domain.blackout.BlackoutMetadata$;
import com.xebialabs.xlrelease.domain.blackout.BlackoutPeriod;
import com.xebialabs.xlrelease.domain.events.BlackoutDeletedEvent;
import com.xebialabs.xlrelease.domain.events.BlackoutUpdatedEvent;
import com.xebialabs.xlrelease.domain.events.TaskUpdatedEvent;
import com.xebialabs.xlrelease.domain.events.XLReleaseEvent;
import com.xebialabs.xlrelease.events.EventBus;
import com.xebialabs.xlrelease.events.Subscribe;
import com.xebialabs.xlrelease.repository.CiCloneHelper;
import com.xebialabs.xlrelease.repository.TaskRepository;
import com.xebialabs.xlrelease.service.blackout.BlackoutReleaseExecutionActorMessages;
import com.xebialabs.xlrelease.service.blackout.BlackoutTaskEventHandler$;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.util.Date;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import org.slf4j.Marker;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import scala.Function0;
import scala.Function1;
import scala.PartialFunction;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.Buffer;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.LambdaDeserialize;

@Service
@ScalaSignature(bytes="\u0006\u0005\teb\u0001B\n\u0015\u0001}A\u0001B\u000e\u0001\u0003\u0006\u0004%\ta\u000e\u0005\t}\u0001\u0011\t\u0011)A\u0005q!Aq\b\u0001BC\u0002\u0013\u0005\u0001\t\u0003\u0005F\u0001\t\u0005\t\u0015!\u0003B\u0011!1\u0005A!b\u0001\n\u00039\u0005\u0002\u0003(\u0001\u0005\u0003\u0005\u000b\u0011\u0002%\t\u000b=\u0003A\u0011\u0001)\t\u000b\u0015\u0004A\u0011\u00014\t\u000bI\u0004A\u0011\u00014\t\u000b]\u0004A\u0011\u0001=\t\u000f\u0005\u0005\u0002\u0001\"\u0001\u0002$!9\u0011\u0011\u0007\u0001\u0005\n\u0005M\u0002bBA)\u0001\u0011%\u00111\u000b\u0005\b\u0003#\u0003A\u0011IAJ\u0011\u001d\tY\u000e\u0001C\u0005\u0003;Dq!a=\u0001\t\u0013\t)\u0010C\u0004\u0002\u0000\u0002!IA!\u0001\t\u000f\t\u0015\u0001\u0001\"\u0011\u0003\b\tA\"\t\\1dW>,H\u000fV1tW\u00163XM\u001c;IC:$G.\u001a:\u000b\u0005U1\u0012\u0001\u00032mC\u000e\\w.\u001e;\u000b\u0005]A\u0012aB:feZL7-\u001a\u0006\u00033i\t\u0011\u0002\u001f7sK2,\u0017m]3\u000b\u0005ma\u0012!\u0003=fE&\fG.\u00192t\u0015\u0005i\u0012aA2p[\u000e\u00011\u0003\u0002\u0001!M9\u0002\"!\t\u0013\u000e\u0003\tR\u0011aI\u0001\u0006g\u000e\fG.Y\u0005\u0003K\t\u0012a!\u00118z%\u00164\u0007CA\u0014-\u001b\u0005A#BA\u0015+\u0003%)\u0007\u0010^3og&|gN\u0003\u0002,1\u00051\u0011m\u0019;peNL!!\f\u0015\u00039\u0005\u001bGo\u001c:FqR,gn]5p]\"\u000bg\u000e\u001a7fe\u001a\u000b7\r^8ssB\u0011q\u0006N\u0007\u0002a)\u0011\u0011GM\u0001\u0006g24GG\u001b\u0006\u0002g\u0005AqM]5{u2,G-\u0003\u00026a\t9Aj\\4hS:<\u0017\u0001C3wK:$()^:\u0016\u0003a\u0002\"!\u000f\u001f\u000e\u0003iR!a\u000f\r\u0002\r\u00154XM\u001c;t\u0013\ti$H\u0001\u0005Fm\u0016tGOQ;t\u0003%)g/\u001a8u\u0005V\u001c\b%A\nsK2,\u0017m]3BGR|'oU3sm&\u001cW-F\u0001B!\t\u00115)D\u0001+\u0013\t!%FA\nSK2,\u0017m]3BGR|'oU3sm&\u001cW-\u0001\u000bsK2,\u0017m]3BGR|'oU3sm&\u001cW\rI\u0001\u000fi\u0006\u001c8NU3q_NLGo\u001c:z+\u0005A\u0005CA%M\u001b\u0005Q%BA&\u0019\u0003)\u0011X\r]8tSR|'/_\u0005\u0003\u001b*\u0013a\u0002V1tWJ+\u0007o\\:ji>\u0014\u00180A\buCN\\'+\u001a9pg&$xN]=!\u0003\u0019a\u0014N\\5u}Q!\u0011k\u0015+V!\t\u0011\u0006!D\u0001\u0015\u0011\u00151t\u00011\u00019\u0011\u0015yt\u00011\u0001B\u0011\u00151u\u00011\u0001IQ\t9q\u000b\u0005\u0002YG6\t\u0011L\u0003\u0002[7\u0006Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\u000b\u0005qk\u0016a\u00024bGR|'/\u001f\u0006\u0003=~\u000bQAY3b]NT!\u0001Y1\u0002\u001fM\u0004(/\u001b8hMJ\fW.Z<pe.T\u0011AY\u0001\u0004_J<\u0017B\u00013Z\u0005%\tU\u000f^8xSJ,G-\u0001\u0005sK\u001eL7\u000f^3s)\u00059\u0007CA\u0011i\u0013\tI'E\u0001\u0003V]&$\bF\u0001\u0005l!\ta\u0007/D\u0001n\u0015\tQfNC\u0001p\u0003\u0015Q\u0017M^1y\u0013\t\tXNA\u0007Q_N$8i\u001c8tiJ,8\r^\u0001\u000bk:\u0014XmZ5ti\u0016\u0014\bFA\u0005u!\taW/\u0003\u0002w[\nQ\u0001K]3EKN$(o\\=\u0002#=t'\t\\1dW>,H/\u00169eCR,G\r\u0006\u0002hs\")!P\u0003a\u0001w\u0006)QM^3oiB\u0019A0!\u0001\u000e\u0003uT!a\u000f@\u000b\u0005}D\u0012A\u00023p[\u0006Lg.C\u0002\u0002\u0004u\u0014AC\u00117bG.|W\u000f^+qI\u0006$X\rZ#wK:$\bf\u0001\u0006\u0002\bA!\u0011\u0011BA\u000b\u001b\t\tYAC\u0002[\u0003\u001bQA!a\u0004\u0002\u0012\u00059Q.\u001a;sS\u000e\u001c(bAA\n9\u0005A1m\u001c3bQ\u0006dW-\u0003\u0003\u0002\u0018\u0005-!!\u0002+j[\u0016$\u0007f\u0001\u0006\u0002\u001cA\u0019\u0011(!\b\n\u0007\u0005}!HA\u0005Tk\n\u001c8M]5cK\u0006\trN\u001c\"mC\u000e\\w.\u001e;EK2,G/\u001a3\u0015\u0007\u001d\f)\u0003\u0003\u0004{\u0017\u0001\u0007\u0011q\u0005\t\u0004y\u0006%\u0012bAA\u0016{\n!\"\t\\1dW>,H\u000fR3mKR,G-\u0012<f]RD3aCA\u0004Q\rY\u00111D\u0001\u0011SN\feMZ3di&tw\rV1tWN$b!!\u000e\u0002<\u0005u\u0002cA\u0011\u00028%\u0019\u0011\u0011\b\u0012\u0003\u000f\t{w\u000e\\3b]\")!\u0010\u0004a\u0001w\"9\u0011q\b\u0007A\u0002\u0005\u0005\u0013a\u00018poB!\u00111IA'\u001b\t\t)E\u0003\u0003\u0002H\u0005%\u0013\u0001B;uS2T!!a\u0013\u0002\t)\fg/Y\u0005\u0005\u0003\u001f\n)E\u0001\u0003ECR,\u0017AE:dQ\u0016$W\u000f\\3UCN\\W\u000b\u001d3bi\u0016$RaZA+\u0003_Bq!a\u0016\u000e\u0001\u0004\tI&\u0001\u0004uCN\\\u0017\n\u001a\t\u0005\u00037\nIG\u0004\u0003\u0002^\u0005\u0015\u0004cAA0E5\u0011\u0011\u0011\r\u0006\u0004\u0003Gr\u0012A\u0002\u001fs_>$h(C\u0002\u0002h\t\na\u0001\u0015:fI\u00164\u0017\u0002BA6\u0003[\u0012aa\u0015;sS:<'bAA4E!9\u0011\u0011O\u0007A\u0002\u0005M\u0014aB2p[6\fg\u000e\u001a\t\u0005\u0003k\nYI\u0004\u0003\u0002x\u0005\u001de\u0002BA=\u0003\u000bsA!a\u001f\u0002\u0004:!\u0011QPAA\u001d\u0011\ty&a \n\u0003uI!a\u0007\u000f\n\u0005eQ\u0012BA\u0016\u0019\u0013\r\tIIK\u0001\u001e%\u0016dW-Y:f\u000bb,7-\u001e;j_:\f5\r^8s\u001b\u0016\u001c8/Y4fg&!\u0011QRAH\u0005A)\u0005\u0010^3og&|gnQ8n[\u0006tGMC\u0002\u0002\n*\n!bZ3u\u0011\u0006tG\r\\3s)!\t)*a-\u0002@\u0006%\u0007\u0003BAL\u0003[sA!!'\u0002(:!\u00111TAQ\u001d\u0011\ty&!(\n\u0005\u0005}\u0015\u0001B1lW\u0006LA!a)\u0002&\u0006)\u0011m\u0019;pe*\u0011\u0011qT\u0005\u0005\u0003S\u000bY+A\u0003BGR|'O\u0003\u0003\u0002$\u0006\u0015\u0016\u0002BAX\u0003c\u0013qAU3dK&4XM\u0003\u0003\u0002*\u0006-\u0006bBA[\u001d\u0001\u0007\u0011qW\u0001\u0005g\u0016dg\r\u0005\u0003\u0002:\u0006mVBAAV\u0013\u0011\ti,a+\u0003\u0011\u0005\u001bGo\u001c:SK\u001aDq!!1\u000f\u0001\u0004\t\u0019-\u0001\u0004tK:$WM\u001d\t\u0006C\u0005\u0015\u0017qW\u0005\u0004\u0003\u000f\u0014#!\u0003$v]\u000e$\u0018n\u001c81\u0011!\tYM\u0004CA\u0002\u00055\u0017a\u0002:fY\u0016\f7/\u001a\t\u0006C\u0005=\u00171[\u0005\u0004\u0003#\u0014#\u0001\u0003\u001fcs:\fW.\u001a \u0011\t\u0005U\u0017q[\u0007\u0002}&\u0019\u0011\u0011\u001c@\u0003\u000fI+G.Z1tK\u0006qQ\u000f\u001d3bi\u0016$\u0016m]6XSRDG\u0003BAp\u0003c$2aZAq\u0011\u001d\t\u0019o\u0004a\u0001\u0003K\fq!\u001e9eCR,'\u000f\u0005\u0004\"\u0003O\fYoZ\u0005\u0004\u0003S\u0014#!\u0003$v]\u000e$\u0018n\u001c82!\u0011\t).!<\n\u0007\u0005=hP\u0001\u0003UCN\\\u0007bBA,\u001f\u0001\u0007\u0011\u0011L\u0001\u0019kB$\u0017\r^3TG\",G-\u001e7fIN#\u0018M\u001d;ECR,G#B4\u0002x\u0006m\bbBA}!\u0001\u0007\u00111^\u0001\u0005i\u0006\u001c8\u000eC\u0004\u0002~B\u0001\r!!\u0011\u0002+9,woU2iK\u0012,H.\u001a3Ti\u0006\u0014H\u000fR1uK\u00069\"/Z:fiN\u001b\u0007.\u001a3vY\u0016$7\u000b^1si\u0012\u000bG/\u001a\u000b\u0004O\n\r\u0001bBA}#\u0001\u0007\u00111^\u0001\tgV\u0004\bo\u001c:ugR!\u0011Q\u0007B\u0005\u0011\u001d\u0011YA\u0005a\u0001\u0005\u001b\tQa\u00197buj\u0004DAa\u0004\u0003\u001aA1\u00111\fB\t\u0005+IAAa\u0005\u0002n\t)1\t\\1tgB!!q\u0003B\r\u0019\u0001!ABa\u0007\u0003\n\u0005\u0005\t\u0011!B\u0001\u0005;\u00111a\u0018\u00132#\u0011\u0011yB!\n\u0011\u0007\u0005\u0012\t#C\u0002\u0003$\t\u0012qAT8uQ&tw\r\u0005\u0003\u0002:\n\u001d\u0012\u0002\u0002B\u0015\u0003W\u0013Q!Q2u_JD3\u0001\u0001B\u0017!\u0011\u0011yC!\u000e\u000e\u0005\tE\"b\u0001B\u001a?\u0006Q1\u000f^3sK>$\u0018\u0010]3\n\t\t]\"\u0011\u0007\u0002\b'\u0016\u0014h/[2f\u0001")
public class BlackoutTaskEventHandler
implements ActorExtensionHandlerFactory,
Logging {
    private final EventBus eventBus;
    private final ReleaseActorService releaseActorService;
    private final TaskRepository taskRepository;
    private transient Logger grizzled$slf4j$Logging$$_logger;
    private volatile transient boolean bitmap$trans$0;

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    @Override
    public <T> void replyOrFail(Function0<ActorRef> sender, Function0<T> call) {
        ActorExtensionHandlerFactory.replyOrFail$(this, sender, call);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        BlackoutTaskEventHandler blackoutTaskEventHandler = this;
        synchronized (blackoutTaskEventHandler) {
            if (!this.bitmap$trans$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        if (!this.bitmap$trans$0) {
            return this.grizzled$slf4j$Logging$$_logger$lzycompute();
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public EventBus eventBus() {
        return this.eventBus;
    }

    public ReleaseActorService releaseActorService() {
        return this.releaseActorService;
    }

    public TaskRepository taskRepository() {
        return this.taskRepository;
    }

    @PostConstruct
    public void register() {
        this.eventBus().register((Object)this);
        this.logger().debug((Function0 & Serializable)() -> "Blackout task event handler registered in event bus.");
    }

    @PreDestroy
    public void unregister() {
        this.eventBus().deregister((Object)this);
        this.logger().debug((Function0 & Serializable)() -> "Blackout task event handler de-registered from event bus.");
    }

    @Subscribe
    @Timed
    public void onBlackoutUpdated(BlackoutUpdatedEvent event) {
        Date now = new Date();
        if (this.isAffectingTasks(event, now)) {
            Buffer taskIds = CollectionConverters$.MODULE$.ListHasAsScala(this.taskRepository().findAffectedByBlackout(event.original())).asScala();
            this.logger().debug((Function0 & Serializable)() -> taskIds.length() + " taskIds to be updated after blackout " + event.original().getLabel() + " update.");
            BlackoutMetadata metadata = BlackoutMetadata$.MODULE$.apply((Seq)new .colon.colon((Object)new BlackoutPeriod(event.updated().getStartDate(), event.updated().getEndDate()), (List)Nil$.MODULE$));
            boolean isInBlackout = metadata.isInBlackout(now);
            Date newScheduledStartDate = metadata.getEndOfBlackout(now);
            taskIds.foreach((Function1 & Serializable)taskId -> {
                this.scheduleTaskUpdate(taskId, isInBlackout ? new BlackoutReleaseExecutionActorMessages.UpdateScheduledStartDate(taskId, newScheduledStartDate) : new BlackoutReleaseExecutionActorMessages.ResetScheduledStartDate(taskId));
                return BoxedUnit.UNIT;
            });
            return;
        }
    }

    @Subscribe
    @Timed
    public void onBlackoutDeleted(BlackoutDeletedEvent event) {
        Buffer taskIds = CollectionConverters$.MODULE$.ListHasAsScala(this.taskRepository().findAffectedByBlackout(event.blackout())).asScala();
        this.logger().debug((Function0 & Serializable)() -> taskIds.length() + " taskIds to be started after blackout " + event.blackout().getLabel() + " removal.");
        taskIds.foreach((Function1 & Serializable)taskId -> {
            this.scheduleTaskUpdate(taskId, new BlackoutReleaseExecutionActorMessages.ResetScheduledStartDate(taskId));
            return BoxedUnit.UNIT;
        });
    }

    private boolean isAffectingTasks(BlackoutUpdatedEvent event, Date now) {
        Date date = event.original().getEndDate();
        Date date2 = event.updated().getEndDate();
        boolean endDateChanged = date == null ? date2 != null : !((Object)date).equals(date2);
        boolean startDateMovedIntoFuture = now.after(event.original().getStartDate()) && now.before(event.updated().getStartDate());
        return endDateChanged || startDateMovedIntoFuture;
    }

    private void scheduleTaskUpdate(String taskId, ReleaseExecutionActorMessages.ExtensionCommand command) {
        this.releaseActorService().executeCommandAsync(taskId, command);
    }

    @Override
    public PartialFunction<Object, BoxedUnit> getHandler(ActorRef self, Function0<ActorRef> sender, Function0<Release> release) {
        return new Serializable(this){
            private static final long serialVersionUID = 0L;
            private final /* synthetic */ BlackoutTaskEventHandler $outer;

            public final <A1, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                if (A1 instanceof BlackoutReleaseExecutionActorMessages.UpdateScheduledStartDate) {
                    BlackoutReleaseExecutionActorMessages.UpdateScheduledStartDate updateScheduledStartDate = (BlackoutReleaseExecutionActorMessages.UpdateScheduledStartDate)A1;
                    String taskId = updateScheduledStartDate.taskId();
                    Date newScheduledStartDate = updateScheduledStartDate.newScheduledStartDate();
                    this.$outer.com$xebialabs$xlrelease$service$blackout$BlackoutTaskEventHandler$$updateTaskWith(taskId, (Function1<Task, BoxedUnit>)(Function1 & Serializable)x$1 -> {
                        $anonfun$getHandler$1.$anonfun$applyOrElse$1(this, newScheduledStartDate, x$1);
                        return BoxedUnit.UNIT;
                    });
                    return (B1)BoxedUnit.UNIT;
                }
                if (A1 instanceof BlackoutReleaseExecutionActorMessages.ResetScheduledStartDate) {
                    BlackoutReleaseExecutionActorMessages.ResetScheduledStartDate resetScheduledStartDate = (BlackoutReleaseExecutionActorMessages.ResetScheduledStartDate)A1;
                    String taskId = resetScheduledStartDate.taskId();
                    this.$outer.com$xebialabs$xlrelease$service$blackout$BlackoutTaskEventHandler$$updateTaskWith(taskId, (Function1<Task, BoxedUnit>)(Function1 & Serializable)task -> {
                        $anonfun$getHandler$1.$anonfun$applyOrElse$2(this, task);
                        return BoxedUnit.UNIT;
                    });
                    return (B1)BoxedUnit.UNIT;
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(Object x1) {
                Object object = x1;
                if (object instanceof BlackoutReleaseExecutionActorMessages.UpdateScheduledStartDate) {
                    return true;
                }
                return object instanceof BlackoutReleaseExecutionActorMessages.ResetScheduledStartDate;
            }

            public static final /* synthetic */ void $anonfun$applyOrElse$1($anonfun$getHandler$1 $this, Date newScheduledStartDate$2, Task x$1) {
                $this.$outer.com$xebialabs$xlrelease$service$blackout$BlackoutTaskEventHandler$$updateScheduledStartDate(x$1, newScheduledStartDate$2);
            }

            public static final /* synthetic */ void $anonfun$applyOrElse$2($anonfun$getHandler$1 $this, Task task) {
                $this.$outer.com$xebialabs$xlrelease$service$blackout$BlackoutTaskEventHandler$$resetScheduledStartDate(task);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$1$adapted(com.xebialabs.xlrelease.service.blackout.BlackoutTaskEventHandler$$anonfun$getHandler$1 java.util.Date com.xebialabs.xlrelease.domain.Task ), $anonfun$applyOrElse$2$adapted(com.xebialabs.xlrelease.service.blackout.BlackoutTaskEventHandler$$anonfun$getHandler$1 com.xebialabs.xlrelease.domain.Task )}, serializedLambda);
            }
        };
    }

    public void com$xebialabs$xlrelease$service$blackout$BlackoutTaskEventHandler$$updateTaskWith(String taskId, Function1<Task, BoxedUnit> updater) {
        Object task = this.taskRepository().findById(taskId);
        Task original = (Task)CiCloneHelper.cloneCi(task);
        updater.apply(task);
        this.taskRepository().update((Task)task);
        this.eventBus().publish((XLReleaseEvent)new TaskUpdatedEvent(original, task));
    }

    public void com$xebialabs$xlrelease$service$blackout$BlackoutTaskEventHandler$$updateScheduledStartDate(Task task, Date newScheduledStartDate) {
        this.logger().debug((Function0 & Serializable)() -> "Updating task '" + task.getId() + "' scheduled start date due to new blackout end date '" + newScheduledStartDate + "'");
        Date originalScheduledStartDate = task.getOriginalScheduledStartDate();
        task.setScheduledStartDate(newScheduledStartDate);
        task.setPostponedDueToBlackout(true);
        task.setOriginalScheduledStartDate(originalScheduledStartDate);
    }

    public void com$xebialabs$xlrelease$service$blackout$BlackoutTaskEventHandler$$resetScheduledStartDate(Task task) {
        this.logger().debug((Function0 & Serializable)() -> "Resetting task '" + task.getId() + "' scheduled start date due to blackout not being applicable anymore.");
        task.setScheduledStartDate(task.getOriginalScheduledStartDate());
        task.setPostponedDueToBlackout(false);
    }

    @Override
    public boolean supports(Class<? extends Actor> clazz) {
        return ReleaseExecutionActor.class.isAssignableFrom(clazz);
    }

    @Autowired
    public BlackoutTaskEventHandler(EventBus eventBus, ReleaseActorService releaseActorService, TaskRepository taskRepository) {
        this.eventBus = eventBus;
        this.releaseActorService = releaseActorService;
        this.taskRepository = taskRepository;
        ActorExtensionHandlerFactory.$init$(this);
        Logging.$init$((Logging)this);
    }
}

