/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.api.internal;

import com.xebialabs.deployit.security.permission.PlatformPermissions;
import com.xebialabs.xlrelease.delivery.repository.DeliveryRepository;
import com.xebialabs.xlrelease.delivery.service.DeliveryPatternService;
import com.xebialabs.xlrelease.delivery.service.DeliveryService;
import com.xebialabs.xlrelease.domain.delivery.Delivery;
import com.xebialabs.xlrelease.security.PermissionChecker;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import org.jboss.resteasy.annotations.cache.NoCache;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;

@Path(value="/fixtures/deliveries")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
@Controller
@NoCache
public class FixturesDeliveryResource {
    private static final Logger logger = LoggerFactory.getLogger(FixturesDeliveryResource.class);
    private DeliveryService deliveryService;
    private DeliveryPatternService deliveryPatternService;
    private PermissionChecker permissions;
    private DeliveryRepository deliveryRepository;

    @Autowired
    public FixturesDeliveryResource(DeliveryService deliveryService, DeliveryPatternService deliveryPatternService, PermissionChecker permissions, DeliveryRepository deliveryRepository) {
        this.deliveryService = deliveryService;
        this.deliveryPatternService = deliveryPatternService;
        this.permissions = permissions;
        this.deliveryRepository = deliveryRepository;
    }

    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @POST
    public Delivery createDelivery(Delivery delivery) {
        this.permissions.check(PlatformPermissions.ADMIN);
        logger.debug("creating release delivery", (Object)delivery.getId());
        return this.deliveryService.createDelivery(delivery, false);
    }

    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @POST
    @Path(value="/patterns/{shouldResetPattern: true|false}")
    public Delivery createDeliveryPattern(Delivery delivery, @PathParam(value="shouldResetPattern") boolean shouldResetPattern) {
        this.permissions.check(PlatformPermissions.ADMIN);
        logger.debug("creating release delivery pattern", (Object)delivery.getId());
        return this.deliveryPatternService.createDeliveryPattern(delivery, shouldResetPattern);
    }

    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @DELETE
    @Path(value="/{deliveryId:.*Delivery[^/]*}")
    public void deleteDelivery(@PathParam(value="deliveryId") String deliveryId) {
        this.permissions.check(PlatformPermissions.ADMIN);
        logger.debug("removing release delivery %s", (Object)deliveryId);
        if (this.deliveryRepository.exists(deliveryId)) {
            this.deliveryRepository.delete(deliveryId);
        }
    }
}

