/*
 * Decompiled with CFR 0.152.
 */
package org.commonmark.ext.gfm.strikethrough.internal;

import org.commonmark.ext.gfm.strikethrough.Strikethrough;
import org.commonmark.node.Node;
import org.commonmark.node.Nodes;
import org.commonmark.node.SourceSpans;
import org.commonmark.node.Text;
import org.commonmark.parser.delimiter.DelimiterProcessor;
import org.commonmark.parser.delimiter.DelimiterRun;

public class StrikethroughDelimiterProcessor
implements DelimiterProcessor {
    public char getOpeningCharacter() {
        return '~';
    }

    public char getClosingCharacter() {
        return '~';
    }

    public int getMinLength() {
        return 2;
    }

    public int process(DelimiterRun openingRun, DelimiterRun closingRun) {
        if (openingRun.length() >= 2 && closingRun.length() >= 2) {
            Text opener = openingRun.getOpener();
            Strikethrough strikethrough = new Strikethrough();
            SourceSpans sourceSpans = new SourceSpans();
            sourceSpans.addAllFrom(openingRun.getOpeners(2));
            for (Node node : Nodes.between((Node)opener, (Node)closingRun.getCloser())) {
                strikethrough.appendChild(node);
                sourceSpans.addAll(node.getSourceSpans());
            }
            sourceSpans.addAllFrom(closingRun.getClosers(2));
            strikethrough.setSourceSpans(sourceSpans.getSourceSpans());
            opener.insertAfter((Node)strikethrough);
            return 2;
        }
        return 0;
    }
}

