/*
 * Decompiled with CFR 0.152.
 */
package com.ziclix.python.sql.pipe;

import com.ziclix.python.sql.pipe.Sink;
import com.ziclix.python.sql.pipe.SinkRunner;
import com.ziclix.python.sql.pipe.Source;
import com.ziclix.python.sql.pipe.SourceRunner;
import com.ziclix.python.sql.util.Queue;
import com.ziclix.python.sql.zxJDBC;
import org.python.core.Py;
import org.python.core.PyObject;

public class Pipe {
    public PyObject pipe(Source source, Sink sink) {
        Queue queue = new Queue();
        SourceRunner sourceRunner = new SourceRunner(queue, source);
        SinkRunner sinkRunner = new SinkRunner(queue, sink);
        sourceRunner.start();
        sinkRunner.start();
        try {
            sourceRunner.join();
        }
        catch (InterruptedException e) {
            queue.close();
            throw zxJDBC.makeException(e);
        }
        try {
            sinkRunner.join();
        }
        catch (InterruptedException e) {
            queue.close();
            throw zxJDBC.makeException(e);
        }
        if (sourceRunner.threwException()) {
            throw zxJDBC.makeException(sourceRunner.getException().toString());
        }
        if (sinkRunner.threwException()) {
            throw zxJDBC.makeException(sinkRunner.getException().toString());
        }
        if (sinkRunner.getCount() == 0) {
            return Py.newInteger(0);
        }
        if (sourceRunner.getCount() - sinkRunner.getCount() != 0) {
            Object[] counts = new Integer[]{sourceRunner.getCount(), sinkRunner.getCount()};
            String msg2 = zxJDBC.getString("inconsistentRowCount", counts);
            Py.assert_(Py.Zero, Py.newString(msg2));
        }
        return Py.newInteger(sinkRunner.getCount());
    }
}

