/*
 * Decompiled with CFR 0.152.
 */
package org.python.modules;

import org.python.core.ArgParser;
import org.python.core.BufferProtocol;
import org.python.core.Py;
import org.python.core.PyBuffer;
import org.python.core.PyException;
import org.python.core.PyObject;
import org.python.core.PyString;
import org.python.core.PyStringMap;
import org.python.core.PyTuple;
import org.python.core.PyUnicode;
import org.python.core.buffer.SimpleStringBuffer;

public class binascii {
    public static String __doc__ = "Conversion between binary data and ASCII";
    public static final PyObject Error = Py.makeClass("Error", Py.Exception, binascii.exceptionNamespace());
    public static final PyObject Incomplete = Py.makeClass("Incomplete", Py.Exception, binascii.exceptionNamespace());
    private static char RUNCHAR = (char)144;
    private static byte DONE = (byte)127;
    private static byte SKIP = (byte)126;
    private static byte FAIL = (byte)125;
    private static byte[] table_a2b_hqx = new byte[]{FAIL, FAIL, FAIL, FAIL, FAIL, FAIL, FAIL, FAIL, FAIL, FAIL, SKIP, FAIL, FAIL, SKIP, FAIL, FAIL, FAIL, FAIL, FAIL, FAIL, FAIL, FAIL, FAIL, FAIL, FAIL, FAIL, FAIL, FAIL, FAIL, FAIL, FAIL, FAIL, FAIL, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, FAIL, FAIL, 13, 14, 15, 16, 17, 18, 19, FAIL, 20, 21, DONE, FAIL, FAIL, FAIL, FAIL, FAIL, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, FAIL, 37, 38, 39, 40, 41, 42, 43, FAIL, 44, 45, 46, 47, FAIL, FAIL, FAIL, FAIL, 48, 49, 50, 51, 52, 53, 54, FAIL, 55, 56, 57, 58, 59, 60, FAIL, FAIL, 61, 62, 63, FAIL, FAIL, FAIL, FAIL, FAIL, FAIL, FAIL, FAIL, FAIL, FAIL, FAIL, FAIL, FAIL, FAIL, FAIL, FAIL, FAIL, FAIL, FAIL, FAIL, FAIL, FAIL, FAIL, FAIL, FAIL, FAIL, FAIL, FAIL, FAIL, FAIL, FAIL, FAIL, FAIL, FAIL, FAIL, FAIL, FAIL, FAIL, FAIL, FAIL, FAIL, FAIL, FAIL, FAIL, FAIL, FAIL, FAIL, FAIL, FAIL, FAIL, FAIL, FAIL, FAIL, FAIL, FAIL, FAIL, FAIL, FAIL, FAIL, FAIL, FAIL, FAIL, FAIL, FAIL, FAIL, FAIL, FAIL, FAIL, FAIL, FAIL, FAIL, FAIL, FAIL, FAIL, FAIL, FAIL, FAIL, FAIL, FAIL, FAIL, FAIL, FAIL, FAIL, FAIL, FAIL, FAIL, FAIL, FAIL, FAIL, FAIL, FAIL, FAIL, FAIL, FAIL, FAIL, FAIL, FAIL, FAIL, FAIL, FAIL, FAIL, FAIL, FAIL, FAIL, FAIL, FAIL, FAIL, FAIL, FAIL, FAIL, FAIL, FAIL, FAIL, FAIL, FAIL, FAIL, FAIL, FAIL, FAIL, FAIL, FAIL, FAIL, FAIL, FAIL, FAIL, FAIL, FAIL, FAIL, FAIL, FAIL, FAIL, FAIL, FAIL, FAIL, FAIL, FAIL, FAIL, FAIL, FAIL, FAIL, FAIL};
    private static char[] table_b2a_hqx = "!\"#$%&'()*+,-012345689@ABCDEFGHIJKLMNPQRSTUVXYZ[`abcdefhijklmpqr".toCharArray();
    private static byte[] table_a2b_base64 = new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 62, -1, -1, -1, 63, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, -1, -1, -1, 0, -1, -1, -1, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, -1, -1, -1, -1, -1, -1, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, -1, -1, -1, -1, -1};
    private static char BASE64_PAD = (char)61;
    private static int BASE64_MAXBIN = 0x3FFFFFFC;
    private static char[] table_b2a_base64 = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/".toCharArray();
    private static int[] crctab_hqx = new int[]{0, 4129, 8258, 12387, 16516, 20645, 24774, 28903, 33032, 37161, 41290, 45419, 49548, 53677, 57806, 61935, 4657, 528, 12915, 8786, 21173, 17044, 29431, 25302, 37689, 33560, 45947, 41818, 54205, 50076, 62463, 58334, 9314, 13379, 1056, 5121, 25830, 29895, 17572, 21637, 42346, 46411, 34088, 38153, 58862, 62927, 50604, 54669, 13907, 9842, 5649, 1584, 30423, 26358, 22165, 18100, 46939, 42874, 38681, 34616, 63455, 59390, 55197, 51132, 18628, 22757, 26758, 30887, 2112, 6241, 10242, 14371, 51660, 55789, 59790, 63919, 35144, 39273, 43274, 47403, 23285, 19156, 31415, 27286, 6769, 2640, 14899, 10770, 56317, 52188, 64447, 60318, 39801, 35672, 47931, 43802, 27814, 31879, 19684, 23749, 11298, 15363, 3168, 7233, 60846, 64911, 52716, 56781, 44330, 48395, 36200, 40265, 32407, 28342, 24277, 20212, 15891, 11826, 7761, 3696, 65439, 61374, 57309, 53244, 48923, 44858, 40793, 36728, 37256, 33193, 45514, 41451, 53516, 49453, 61774, 57711, 4224, 161, 12482, 8419, 20484, 16421, 28742, 24679, 33721, 37784, 41979, 46042, 49981, 54044, 58239, 62302, 689, 4752, 8947, 13010, 16949, 21012, 25207, 29270, 46570, 42443, 38312, 34185, 62830, 58703, 54572, 50445, 13538, 9411, 5280, 1153, 29798, 25671, 21540, 17413, 42971, 47098, 34713, 38840, 59231, 63358, 50973, 55100, 9939, 14066, 1681, 5808, 26199, 30326, 17941, 22068, 55628, 51565, 63758, 59695, 39368, 35305, 47498, 43435, 22596, 18533, 30726, 26663, 6336, 2273, 14466, 10403, 52093, 56156, 60223, 64286, 35833, 39896, 43963, 48026, 19061, 23124, 27191, 31254, 2801, 6864, 10931, 14994, 64814, 60687, 56684, 52557, 48554, 44427, 40424, 36297, 31782, 27655, 23652, 19525, 15522, 11395, 7392, 3265, 61215, 65342, 53085, 57212, 44955, 49082, 36825, 40952, 28183, 32310, 20053, 24180, 11923, 16050, 3793, 7920};
    public static PyString __doc__a2b_uu = new PyString("(ascii) -> bin. Decode a line of uuencoded data");
    public static PyString __doc__b2a_uu = new PyString("(bin) -> ascii. Uuencode line of data");
    public static PyString __doc__a2b_base64 = new PyString("(ascii) -> bin. Decode a line of base64 data");
    public static PyString __doc__b2a_base64 = new PyString("(bin) -> ascii. Base64-code line of data");
    public static PyString __doc__a2b_hqx = new PyString("ascii -> bin, done. Decode .hqx coding");
    public static PyString __doc__rlecode_hqx = new PyString("Binhex RLE-code binary data");
    public static PyString __doc__b2a_hqx = new PyString("Encode .hqx data");
    public static PyString __doc__rledecode_hqx = new PyString("Decode hexbin RLE-coded string");
    public static PyString __doc__crc_hqx = new PyString("(data, oldcrc) -> newcrc. Compute hqx CRC incrementally");
    static int[] crc_32_tab = new int[]{0, 1996959894, -301047508, -1727442502, 124634137, 1886057615, -379345611, -1637575261, 249268274, 2044508324, -522852066, -1747789432, 162941995, 2125561021, -407360249, -1866523247, 498536548, 1789927666, -205950648, -2067906082, 450548861, 1843258603, -187386543, -2083289657, 325883990, 1684777152, -43845254, -1973040660, 335633487, 1661365465, -99664541, -1928851979, 997073096, 1281953886, -715111964, -1570279054, 1006888145, 1258607687, -770865667, -1526024853, 901097722, 1119000684, -608450090, -1396901568, 853044451, 1172266101, -589951537, -1412350631, 651767980, 1373503546, -925412992, -1076862698, 565507253, 1454621731, -809855591, -1195530993, 671266974, 1594198024, -972236366, -1324619484, 795835527, 1483230225, -1050600021, -1234817731, 1994146192, 31158534, -1731059524, -271249366, 1907459465, 112637215, -1614814043, -390540237, 2013776290, 251722036, -1777751922, -519137256, 2137656763, 141376813, -1855689577, -429695999, 1802195444, 476864866, -2056965928, -228458418, 1812370925, 453092731, -2113342271, -183516073, 1706088902, 314042704, -1950435094, -54949764, 1658658271, 366619977, -1932296973, -69972891, 1303535960, 984961486, -1547960204, -725929758, 1256170817, 1037604311, -1529756563, -740887301, 1131014506, 879679996, -1385723834, -631195440, 1141124467, 855842277, -1442165665, -586318647, 1342533948, 654459306, -1106571248, -921952122, 1466479909, 544179635, -1184443383, -832445281, 1591671054, 702138776, -1328506846, -942167884, 1504918807, 783551873, -1212326853, -1061524307, -306674912, -1698712650, 62317068, 1957810842, -355121351, -1647151185, 81470997, 1943803523, -480048366, -1805370492, 225274430, 2053790376, -468791541, -1828061283, 167816743, 2097651377, -267414716, -2029476910, 503444072, 1762050814, -144550051, -2140837941, 426522225, 1852507879, -19653770, -1982649376, 282753626, 1742555852, -105259153, -1900089351, 397917763, 1622183637, -690576408, -1580100738, 953729732, 1340076626, -776247311, -1497606297, 1068828381, 1219638859, -670225446, -1358292148, 906185462, 1090812512, -547295293, -1469587627, 829329135, 1181335161, -882789492, -1134132454, 628085408, 1382605366, -871598187, -1156888829, 570562233, 1426400815, -977650754, -1296233688, 733239954, 1555261956, -1026031705, -1244606671, 752459403, 1541320221, -1687895376, -328994266, 1969922972, 40735498, -1677130071, -351390145, 1913087877, 83908371, -1782625662, -491226604, 2075208622, 213261112, -1831694693, -438977011, 2094854071, 198958881, -2032938284, -237706686, 1759359992, 534414190, -2118248755, -155638181, 1873836001, 414664567, -2012718362, -15766928, 1711684554, 285281116, -1889165569, -127750551, 1634467795, 376229701, -1609899400, -686959890, 1308918612, 956543938, -1486412191, -799009033, 1231636301, 1047427035, -1362007478, -640263460, 1088359270, 936918000, -1447252397, -558129467, 1202900863, 817233897, -1111625188, -893730166, 1404277552, 615818150, -1160759803, -841546093, 1423857449, 601450431, -1285129682, -1000256840, 1567103746, 711928724, -1274298825, -1022587231, 1510334235, 755167117};
    private static char[] hexdigit = "0123456789abcdef".toCharArray();
    public static PyString __doc__b2a_hex = new PyString("b2a_hex(data) -> s; Hexadecimal representation of binary data.\n\nThis function is also available as \"hexlify()\".");
    public static PyString a2b_hex$doc = new PyString("a2b_hex(hexstr) -> s; Binary data of hexadecimal representation.\n\nhexstr must contain an even number of hex digits (upper or lower case).\nThis function is also available as \"unhexlify()\"");
    private static final char[] upper_hexdigit = "0123456789ABCDEF".toCharArray();
    public static final PyString __doc__a2b_qp = new PyString("Decode a string of qp-encoded data");
    public static final PyString __doc__b2a_qp = new PyString("b2a_qp(data, quotetabs=0, istext=1, header=0) -> s;\nEncode a string using quoted-printable encoding.\n\nOn encoding, when istext is set, newlines are not encoded, and white\nspace at end of lines is.  When istext is not set, \r and \n (CR/LF) are\nboth encoded.  When quotetabs is set, space and tabs are encoded.");

    public static PyObject exceptionNamespace() {
        PyStringMap dict = new PyStringMap();
        ((PyObject)dict).__setitem__("__module__", (PyObject)new PyString("binascii"));
        return dict;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static PyString a2b_uu(PyObject text2) {
        try (PyBuffer textBuf = binascii.getByteBuffer(text2);){
            int ch;
            int textLen = textBuf.getLen();
            if (textLen == 0) {
                PyString pyString = new PyString("");
                return pyString;
            }
            StringBuilder dataBuf = new StringBuilder();
            int bits = 0;
            int bitCount = 0;
            int index = 0;
            int dataExpected = textBuf.intAt(0) - 32 & 0x3F;
            --textLen;
            while (dataExpected > 0 && textLen > 0) {
                int sixBits;
                ch = textBuf.intAt(index + 1);
                if (ch == 10 || ch == 13 || textLen <= 0) {
                    sixBits = 0;
                } else {
                    if (ch < 32) throw new PyException(Error, "Illegal char");
                    if (ch > 96) {
                        throw new PyException(Error, "Illegal char");
                    }
                    sixBits = ch - 32 & 0x3F;
                }
                bits = bits << 6 | sixBits;
                if ((bitCount += 6) >= 8) {
                    int b = bits >> (bitCount -= 8) & 0xFF;
                    dataBuf.append((char)b);
                    bits &= (1 << bitCount) - 1;
                    --dataExpected;
                }
                ++index;
                --textLen;
            }
            while (textLen-- > 0) {
                if ((ch = textBuf.intAt(++index)) == 32 || ch == 64 || ch == 10 || ch == 13) continue;
                throw new PyException(Error, "Trailing garbage");
            }
            while (index < dataExpected) {
                dataBuf.append('\u0000');
                ++index;
            }
            PyString pyString = new PyString(dataBuf.toString());
            return pyString;
        }
        catch (ClassCastException e) {
            throw binascii.argMustBeBytes("a2b_uu", text2);
        }
    }

    public static PyString b2a_uu(PyObject data) {
        PyBuffer dataBuf = binascii.getByteBuffer(data);
        try {
            int dataLen;
            if (dataLen > 45) {
                throw new PyException(Error, "At most 45 bytes at once");
            }
            StringBuilder textBuf = new StringBuilder(4 * ((dataLen + 2) / 3) + 2);
            int bitCount = 0;
            int bits = 0;
            textBuf.append((char)(32 + (dataLen & 0x3F)));
            int i = 0;
            for (dataLen = dataBuf.getLen(); dataLen > 0 || bitCount != 0; --dataLen) {
                bits = dataLen > 0 ? bits << 8 | dataBuf.intAt(i) : (bits <<= 8);
                bitCount += 8;
                while (bitCount >= 6) {
                    int sixBits = bits >> (bitCount -= 6) & 0x3F;
                    textBuf.append((char)(sixBits + 32));
                }
                ++i;
            }
            textBuf.append('\n');
            PyString pyString = new PyString(textBuf.toString());
            if (dataBuf != null) {
                dataBuf.close();
            }
            return pyString;
        }
        catch (Throwable throwable) {
            try {
                if (dataBuf != null) {
                    try {
                        dataBuf.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (ClassCastException e) {
                throw binascii.argMustBeBytes("b2a_uu", data);
            }
        }
    }

    private static int binascii_find_valid(PyBuffer b, int offset, int num) {
        int ret = -1;
        for (int blen = b.getLen() - offset; blen > 0 && ret == -1; --blen) {
            int c = b.intAt(offset);
            byte b64val = table_a2b_base64[c & 0x7F];
            if (c <= 127 && b64val != -1) {
                if (num == 0) {
                    ret = c;
                }
                --num;
            }
            ++offset;
        }
        return ret;
    }

    public static PyString a2b_base64(PyObject text2) {
        PyBuffer textBuf = binascii.getByteBuffer(text2);
        try {
            int textLen = textBuf.getLen();
            int dataLen = 3 * ((textLen + 3) / 4);
            StringBuilder dataBuf = new StringBuilder(dataLen);
            int bits = 0;
            int bitCount = 0;
            int quad_pos = 0;
            int i = 0;
            while (textLen > 0) {
                int ch = textBuf.intAt(i);
                if (ch <= 127 && ch != 13 && ch != 10 && ch != 32) {
                    if (ch == BASE64_PAD) {
                        if (quad_pos >= 2 && (quad_pos != 2 || binascii.binascii_find_valid(textBuf, i, 1) == BASE64_PAD)) {
                            bitCount = 0;
                            break;
                        }
                    } else {
                        byte sixBits = table_a2b_base64[ch];
                        if (sixBits != -1) {
                            quad_pos = quad_pos + 1 & 3;
                            bits = bits << 6 | sixBits;
                            if ((bitCount += 6) >= 8) {
                                dataBuf.append((char)(bits >> (bitCount -= 8) & 0xFF));
                                bits &= (1 << bitCount) - 1;
                            }
                        }
                    }
                }
                --textLen;
                ++i;
            }
            if (bitCount != 0) {
                throw new PyException(Error, "Incorrect padding");
            }
            PyString pyString = new PyString(dataBuf.toString());
            if (textBuf != null) {
                textBuf.close();
            }
            return pyString;
        }
        catch (Throwable throwable) {
            try {
                if (textBuf != null) {
                    try {
                        textBuf.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (ClassCastException e) {
                throw binascii.argMustBeBytes("a2b_base64", text2);
            }
        }
    }

    public static PyString b2a_base64(PyObject data) {
        PyBuffer dataBuf = binascii.getByteBuffer(data);
        try {
            int dataLen = dataBuf.getLen();
            if (dataLen > BASE64_MAXBIN) {
                throw new PyException(Error, "Too much data for base64 line");
            }
            StringBuilder ascii_data = new StringBuilder(4 * ((dataLen + 2) / 3) + 1);
            int bits = 0;
            int bitCount = 0;
            for (int i = 0; i < dataLen; ++i) {
                bits = bits << 8 | dataBuf.intAt(i);
                bitCount += 8;
                while (bitCount >= 6) {
                    ascii_data.append(table_b2a_base64[bits >> (bitCount -= 6) & 0x3F]);
                }
            }
            if (bitCount == 2) {
                ascii_data.append(table_b2a_base64[(bits & 3) << 4]);
                ascii_data.append(BASE64_PAD);
                ascii_data.append(BASE64_PAD);
            } else if (bitCount == 4) {
                ascii_data.append(table_b2a_base64[(bits & 0xF) << 2]);
                ascii_data.append(BASE64_PAD);
            }
            ascii_data.append('\n');
            PyString pyString = new PyString(ascii_data.toString());
            if (dataBuf != null) {
                dataBuf.close();
            }
            return pyString;
        }
        catch (Throwable throwable) {
            try {
                if (dataBuf != null) {
                    try {
                        dataBuf.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (ClassCastException e) {
                throw binascii.argMustBeBytes("b2a_base64", data);
            }
        }
    }

    public static PyTuple a2b_hqx(PyObject text2) {
        PyBuffer textBuf = binascii.getByteBuffer(text2);
        try {
            int textLen = textBuf.getLen();
            StringBuilder dataBuf = new StringBuilder();
            int bitCount = 0;
            int bits = 0;
            boolean done = false;
            for (int i = 0; i < textLen; ++i) {
                byte b = table_a2b_hqx[textBuf.intAt(i)];
                if (b == SKIP) continue;
                if (b == FAIL) {
                    throw new PyException(Error, "Illegal char");
                }
                if (b == DONE) {
                    done = true;
                    break;
                }
                bits = bits << 6 | b;
                if ((bitCount += 6) < 8) continue;
                dataBuf.append((char)(bits >> (bitCount -= 8) & 0xFF));
                bits &= (1 << bitCount) - 1;
            }
            if (bitCount != 0 && !done) {
                throw new PyException(Incomplete, "String has incomplete number of bytes");
            }
            PyTuple pyTuple = new PyTuple(new PyString(dataBuf.toString()), Py.newInteger(done ? 1 : 0));
            if (textBuf != null) {
                textBuf.close();
            }
            return pyTuple;
        }
        catch (Throwable throwable) {
            try {
                if (textBuf != null) {
                    try {
                        textBuf.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (ClassCastException e) {
                throw binascii.argMustBeBytes("a2b_hqx", text2);
            }
        }
    }

    public static PyString rlecode_hqx(PyObject data) {
        PyBuffer inBuf = binascii.getByteBuffer(data);
        try {
            int len = inBuf.getLen();
            StringBuilder outBuf = new StringBuilder();
            for (int in = 0; in < len; ++in) {
                int inend;
                char ch = (char)inBuf.intAt(in);
                if (ch == RUNCHAR) {
                    outBuf.append(RUNCHAR);
                    outBuf.append('\u0000');
                    continue;
                }
                for (inend = in + 1; inend < len && (char)inBuf.intAt(inend) == ch && inend < in + 255; ++inend) {
                }
                if (inend - in > 3) {
                    outBuf.append(ch);
                    outBuf.append(RUNCHAR);
                    outBuf.append((char)(inend - in));
                    in = inend - 1;
                    continue;
                }
                outBuf.append(ch);
            }
            PyString pyString = new PyString(outBuf.toString());
            if (inBuf != null) {
                inBuf.close();
            }
            return pyString;
        }
        catch (Throwable throwable) {
            try {
                if (inBuf != null) {
                    try {
                        inBuf.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (ClassCastException e) {
                throw binascii.argMustBeBytes("rlecode_hqx", data);
            }
        }
    }

    public static PyString b2a_hqx(PyObject data) {
        PyBuffer dataBuf = binascii.getByteBuffer(data);
        try {
            int len = dataBuf.getLen();
            StringBuilder textBuf = new StringBuilder();
            int bits = 0;
            int bitCount = 0;
            int i = 0;
            while (len > 0) {
                bits = bits << 8 | (char)dataBuf.intAt(i);
                bitCount += 8;
                while (bitCount >= 6) {
                    textBuf.append(table_b2a_hqx[bits >> (bitCount -= 6) & 0x3F]);
                }
                --len;
                ++i;
            }
            if (bitCount != 0) {
                textBuf.append(table_b2a_hqx[(bits <<= 6 - bitCount) & 0x3F]);
            }
            PyString pyString = new PyString(textBuf.toString());
            if (dataBuf != null) {
                dataBuf.close();
            }
            return pyString;
        }
        catch (Throwable throwable) {
            try {
                if (dataBuf != null) {
                    try {
                        dataBuf.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (ClassCastException e) {
                throw binascii.argMustBeBytes("b2a_hqx", data);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static PyString rledecode_hqx(PyObject data) {
        try (PyBuffer inBuf = binascii.getByteBuffer(data);){
            int in_repeat;
            char outByte;
            int inLen = inBuf.getLen();
            int index = 0;
            if (inLen == 0) {
                PyString pyString = Py.EmptyString;
                return pyString;
            }
            StringBuilder outBuf = new StringBuilder();
            if (--inLen < 0) {
                throw new PyException(Incomplete);
            }
            if ((outByte = (char)inBuf.intAt(index++)) == RUNCHAR) {
                if (--inLen < 0) {
                    throw new PyException(Incomplete);
                }
                if ((in_repeat = inBuf.intAt(index++)) != 0) {
                    throw new PyException(Error, "Orphaned RLE code at start");
                }
                outBuf.append(RUNCHAR);
            } else {
                outBuf.append(outByte);
            }
            while (inLen > 0) {
                if (--inLen < 0) {
                    throw new PyException(Incomplete);
                }
                if ((outByte = (char)inBuf.intAt(index++)) == RUNCHAR) {
                    if (--inLen < 0) {
                        throw new PyException(Incomplete);
                    }
                    if ((in_repeat = inBuf.intAt(index++)) == 0) {
                        outBuf.append(RUNCHAR);
                        continue;
                    }
                    outByte = outBuf.charAt(outBuf.length() - 1);
                    while (--in_repeat > 0) {
                        outBuf.append(outByte);
                    }
                    continue;
                }
                outBuf.append(outByte);
            }
            PyString pyString = new PyString(outBuf.toString());
            return pyString;
        }
        catch (ClassCastException e) {
            throw binascii.argMustBeBytes("rledecode_hqx", data);
        }
    }

    public static int crc_hqx(PyObject data, int crc) {
        PyBuffer buf = binascii.getByteBuffer(data);
        try {
            int len = buf.getLen();
            for (int i = 0; i < len; ++i) {
                crc = crc << 8 & 0xFF00 ^ crctab_hqx[crc >> 8 & 0xFF ^ buf.intAt(i)];
            }
            int n = crc;
            if (buf != null) {
                buf.close();
            }
            return n;
        }
        catch (Throwable throwable) {
            try {
                if (buf != null) {
                    try {
                        buf.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (ClassCastException e) {
                throw binascii.argMustBeBytes("crc_hqx", data);
            }
        }
    }

    public static int crc32(PyObject bp) {
        return binascii.crc32(bp, 0L);
    }

    public static int crc32(PyObject data, long long_crc) {
        int crc = ~((int)long_crc);
        PyBuffer dataBuf = binascii.getByteBuffer(data);
        try {
            int len = dataBuf.getLen();
            for (int i = 0; i < len; ++i) {
                int b = dataBuf.intAt(i);
                crc = crc_32_tab[(crc ^ b) & 0xFF] ^ crc >>> 8;
            }
            int n = ~crc;
            if (dataBuf != null) {
                dataBuf.close();
            }
            return n;
        }
        catch (Throwable throwable) {
            try {
                if (dataBuf != null) {
                    try {
                        dataBuf.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (ClassCastException e) {
                throw binascii.argMustBeBytes("crc32", data);
            }
        }
    }

    public static PyString b2a_hex(PyObject data) {
        PyBuffer dataBuf = binascii.getByteBuffer(data);
        try {
            int dataLen = dataBuf.getLen();
            StringBuilder retbuf = new StringBuilder(dataLen * 2);
            for (int i = 0; i < dataLen; ++i) {
                int ch = dataBuf.intAt(i);
                retbuf.append(hexdigit[ch >>> 4 & 0xF]);
                retbuf.append(hexdigit[ch & 0xF]);
            }
            PyString pyString = new PyString(retbuf.toString());
            if (dataBuf != null) {
                dataBuf.close();
            }
            return pyString;
        }
        catch (Throwable throwable) {
            try {
                if (dataBuf != null) {
                    try {
                        dataBuf.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (ClassCastException e) {
                throw binascii.argMustBeBytes("b2a_hex", data);
            }
        }
    }

    public static PyString hexlify(PyObject argbuf) {
        return binascii.b2a_hex(argbuf);
    }

    public static PyString a2b_hex(PyObject hexstr) {
        PyBuffer buf = binascii.getByteBuffer(hexstr);
        try {
            int bufLen = buf.getLen();
            StringBuilder retbuf = new StringBuilder(bufLen / 2);
            if (bufLen % 2 != 0) {
                throw Py.TypeError("Odd-length string");
            }
            for (int i = 0; i < bufLen; i += 2) {
                int top = Character.digit(buf.intAt(i), 16);
                int bot = Character.digit(buf.intAt(i + 1), 16);
                if (top == -1 || bot == -1) {
                    throw Py.TypeError("Non-hexadecimal digit found");
                }
                retbuf.append((char)((top << 4) + bot));
            }
            PyString pyString = new PyString(retbuf.toString());
            if (buf != null) {
                buf.close();
            }
            return pyString;
        }
        catch (Throwable throwable) {
            try {
                if (buf != null) {
                    try {
                        buf.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (ClassCastException e) {
                throw binascii.argMustBeBytes("a2b_hex", hexstr);
            }
        }
    }

    public static PyString unhexlify(PyObject argbuf) {
        return binascii.a2b_hex(argbuf);
    }

    private static StringBuilder qpEscape(StringBuilder sb, char c) {
        sb.append('=');
        sb.append(upper_hexdigit[c >>> 4 & 0xF]);
        sb.append(upper_hexdigit[c & 0xF]);
        return sb;
    }

    private static boolean getIntFlagAsBool(ArgParser ap, int index, int dflt, String errMsg) {
        try {
            boolean val = ap.getInt(index, dflt) != 0;
            return val;
        }
        catch (PyException e) {
            if (e.match(Py.AttributeError) || e.match(Py.ValueError)) {
                throw Py.TypeError(errMsg);
            }
            throw e;
        }
    }

    public static PyString a2b_qp(PyObject[] arg, String[] kws) {
        ArgParser ap = new ArgParser("a2b_qp", arg, kws, new String[]{"s", "header"});
        PyObject bp = ap.getPyObject(0);
        StringBuilder sb = new StringBuilder();
        boolean header2 = binascii.getIntFlagAsBool(ap, 1, 0, "an integer is required");
        PyBuffer ascii_data = binascii.getByteBuffer(bp);
        try {
            int i = 0;
            int m = ascii_data.getLen();
            while (i < m) {
                char c = (char)ascii_data.intAt(i++);
                if (header2 && c == '_') {
                    sb.append(' ');
                    continue;
                }
                if (c == '=') {
                    if (i >= m) continue;
                    if ((c = (char)ascii_data.intAt(i++)) == '=') {
                        sb.append(c);
                        continue;
                    }
                    if (c == ' ') {
                        sb.append("= ");
                        continue;
                    }
                    if ((c >= '0' && c <= '9' || c >= 'A' && c <= 'F') && i < m) {
                        char nc;
                        if ((nc = (char)ascii_data.intAt(i++)) >= '0' && nc <= '9' || nc >= 'A' && nc <= 'F') {
                            sb.append((char)(Character.digit(c, 16) << 4 | Character.digit(nc, 16)));
                            continue;
                        }
                        sb.append('=').append(c).append(nc);
                        continue;
                    }
                    if (c == '\n') continue;
                    sb.append('=').append(c);
                    continue;
                }
                sb.append(c);
            }
            PyString pyString = new PyString(sb.toString());
            if (ascii_data != null) {
                ascii_data.close();
            }
            return pyString;
        }
        catch (Throwable throwable) {
            try {
                if (ascii_data != null) {
                    try {
                        ascii_data.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (ClassCastException e) {
                throw binascii.argMustBeBytes("a2b_qp", bp);
            }
        }
    }

    public static PyString b2a_qp(PyObject[] arg, String[] kws) {
        ArgParser ap = new ArgParser("b2a_qp", arg, kws, new String[]{"s", "quotetabs", "istext", "header"});
        boolean quotetabs = binascii.getIntFlagAsBool(ap, 1, 0, "an integer is required");
        boolean istext = binascii.getIntFlagAsBool(ap, 2, 1, "an integer is required");
        boolean header2 = binascii.getIntFlagAsBool(ap, 3, 0, "an integer is required");
        PyObject data = ap.getPyObject(0);
        PyBuffer dataBuf = binascii.getByteBuffer(data);
        try {
            int dataLen = dataBuf.getLen();
            StringBuilder sb = new StringBuilder(dataLen);
            String lineEnd = "\n";
            int m = dataBuf.getLen();
            for (int i = 0; i < m; ++i) {
                if (10 != dataBuf.intAt(i)) continue;
                if (i <= 0 || 13 != dataBuf.intAt(i - 1)) break;
                lineEnd = "\r\n";
                break;
            }
            int count2 = 0;
            int MAXLINESIZE = 76;
            int in = 0;
            while (in < dataLen) {
                char ch = (char)dataBuf.intAt(in);
                if (ch > '~' || ch == '=' || header2 && ch == '_' || ch == '.' && count2 == 0 && (in + 1 == dataLen || (char)dataBuf.intAt(in + 1) == '\n' || (char)dataBuf.intAt(in + 1) == '\r') || !istext && (ch == '\r' || ch == '\n') || (ch == '\t' || ch == ' ') && in + 1 == dataLen || ch < '!' && ch != '\r' && ch != '\n' && (quotetabs || !quotetabs && ch != '\t' && ch != ' ')) {
                    if (count2 + 3 >= MAXLINESIZE) {
                        sb.append('=');
                        sb.append(lineEnd);
                        count2 = 0;
                    }
                    binascii.qpEscape(sb, ch);
                    ++in;
                    count2 += 3;
                    continue;
                }
                if (istext && (ch == '\n' || in + 1 < dataLen && ch == '\r' && dataBuf.intAt(in + 1) == 10)) {
                    count2 = 0;
                    int out = sb.length();
                    if (out > 0 && (sb.charAt(out - 1) == ' ' || sb.charAt(out - 1) == '\t')) {
                        ch = sb.charAt(out - 1);
                        sb.setLength(out - 1);
                        binascii.qpEscape(sb, ch);
                    }
                    sb.append(lineEnd);
                    if (ch == '\r') {
                        in += 2;
                        continue;
                    }
                    ++in;
                    continue;
                }
                if (in + 1 != dataLen && (char)dataBuf.intAt(in + 1) != '\n' && count2 + 1 >= MAXLINESIZE) {
                    sb.append('=');
                    sb.append(lineEnd);
                    count2 = 0;
                }
                ++count2;
                if (header2 && ch == ' ') {
                    sb.append('_');
                    ++in;
                    continue;
                }
                sb.append(ch);
                ++in;
            }
            PyString pyString = new PyString(sb.toString());
            if (dataBuf != null) {
                dataBuf.close();
            }
            return pyString;
        }
        catch (Throwable throwable) {
            try {
                if (dataBuf != null) {
                    try {
                        dataBuf.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (ClassCastException e) {
                throw binascii.argMustBeBytes("b2a_qp", data);
            }
        }
    }

    private static PyBuffer getByteBuffer(PyObject text2) throws ClassCastException {
        if (text2 instanceof PyUnicode) {
            String s = ((PyUnicode)text2).encode();
            return new SimpleStringBuffer(0, null, s);
        }
        return ((BufferProtocol)((Object)text2)).getBuffer(0);
    }

    private static PyException argMustBeBytes(String f, PyObject arg) {
        String fmt = "%s() argument 1 must bytes or unicode, not %s";
        String type = "null";
        if (arg instanceof PyObject) {
            type = arg.getType().fastGetName();
        } else if (arg != null) {
            type = arg.getClass().getName();
        }
        return Py.TypeError(String.format(fmt, f, type));
    }
}

