/*
 * Decompiled with CFR 0.152.
 */
package org.joda.convert.factory;

import org.joda.convert.StringConverter;
import org.joda.convert.StringConverterFactory;
import org.joda.convert.TypedStringConverter;

public final class BooleanArrayStringConverterFactory
implements StringConverterFactory {
    public static final StringConverterFactory INSTANCE = new BooleanArrayStringConverterFactory();

    private BooleanArrayStringConverterFactory() {
    }

    @Override
    public StringConverter<?> findConverter(Class<?> cls) {
        if (cls == boolean[].class) {
            return BooleanArrayStringConverter.INSTANCE;
        }
        return null;
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }

    static enum BooleanArrayStringConverter implements TypedStringConverter<boolean[]>
    {
        INSTANCE{

            @Override
            public String convertToString(boolean[] array) {
                if (array.length == 0) {
                    return "";
                }
                StringBuilder buf = new StringBuilder(array.length);
                for (int i = 0; i < array.length; ++i) {
                    buf.append(array[i] ? (char)'T' : 'F');
                }
                return buf.toString();
            }

            @Override
            public boolean[] convertFromString(Class<? extends boolean[]> cls, String str) {
                if (str.length() == 0) {
                    return EMPTY;
                }
                boolean[] array = new boolean[str.length()];
                for (int i = 0; i < array.length; ++i) {
                    char ch = str.charAt(i);
                    if (ch == 'T') {
                        array[i] = true;
                        continue;
                    }
                    if (ch == 'F') {
                        array[i] = false;
                        continue;
                    }
                    throw new IllegalArgumentException("Invalid boolean[] string, must consist only of 'T' and 'F'");
                }
                return array;
            }

            @Override
            public Class<?> getEffectiveType() {
                return boolean[].class;
            }
        };

        private static final boolean[] EMPTY;

        static {
            EMPTY = new boolean[0];
        }
    }
}

