import React from 'react';
import noop from 'lodash/noop';
import { ReactWrapper } from 'enzyme';
import { Provider } from 'react-redux';
import { mountComponentWithStore } from '../../../../../../../../../../core/xlr-ui/tests/unit/testing-utils';
import { ManagedApplicationTableComponentPortal, ManagedApplicationTableComponentPortalProps } from './managed-application-table-component.portal';

describe('ManagedApplicationTablePortal component', () => {
    let wrapper: ReactWrapper;
    const defaultProps: ManagedApplicationTableComponentPortalProps = {
        folder: { id: 'folderId', title: 'Folder' },
        onViewChange: noop,
    };
    const mountComponent = () => {
        wrapper = mountComponentWithStore(<ManagedApplicationTableComponentPortal {...defaultProps} />);
    };
    beforeEach(() => {
        mountComponent();
    });

    afterEach(() => {
        wrapper.unmount();
    });

    it('should render properly', () => {
        expect(wrapper.find(Provider)).toExist();
        expect(wrapper.find(ManagedApplicationTableComponentPortal)).toExist();
    });
});
