import React from 'react';
import { DotRadioGroup, RadioButtonProps } from '@digital-ai/dot-components';
import { TaskInputCommonProps } from '../../../../../../../../../../../core/xlr-ui/app/features/tasks/components/rails/config/components/types';
import { TaskInputPropertiesVariableOrValue } from '../../../../../../../../../../../core/xlr-ui/app/types';
import { getPropertyFromInputProperties } from '../../../../../../../../../../../core/xlr-ui/app/features/tasks/helper/task.helper';
import './status.component.less';
import '../../../../../../../../../../../core/xlr-ui/app/styles/xlrelease/disabled-with-default-color.less';

const MARK_STATUS_OPTIONS: Array<RadioButtonProps> = [
    {
        value: 'READY',
        label: 'Completed',
    },
    {
        value: 'SKIPPED',
        label: 'Skipped',
    },
    {
        value: 'NOT_READY',
        label: 'In progress',
    },
];

const WAIT_STATUS_OPTIONS: Array<RadioButtonProps> = [
    {
        value: 'READY',
        label: 'Completed',
    },
    {
        value: 'NOT_READY',
        label: 'Available',
    },
];

export const MarkStatus = ({ disabled, onChange, property, task, expanded, propertiesEnum }: TaskInputCommonProps) => {
    return (
        <StatusRadioGroup
            disabled={disabled}
            expanded={expanded}
            onChange={onChange}
            options={MARK_STATUS_OPTIONS}
            propertiesEnum={propertiesEnum}
            property={property}
            task={task}
        />
    );
};

export const WaitStatus = ({ disabled, onChange, property, task, expanded, propertiesEnum }: TaskInputCommonProps) => {
    return (
        <StatusRadioGroup
            disabled={disabled}
            expanded={expanded}
            onChange={onChange}
            options={WAIT_STATUS_OPTIONS}
            propertiesEnum={propertiesEnum}
            property={property}
            task={task}
        />
    );
};

interface StatusProps extends TaskInputCommonProps {
    options: Array<RadioButtonProps>;
}

const StatusRadioGroup = ({ options, disabled, onChange, property, task }: StatusProps) => {
    const value = (getPropertyFromInputProperties(task, property.name) as TaskInputPropertiesVariableOrValue).value as string;

    const handleOnChange = (statusValue: string) => {
        onChange({ value: statusValue, variable: null });
    };

    return (
        <div className="task-input-property disabled-with-default-color">
            <DotRadioGroup
                className="radio-status"
                disableGroup={disabled}
                groupLabel={property.label}
                helperText={property.description}
                name={property.name}
                onChange={(_e, v) => handleOnChange(v)}
                options={options}
                required={property.required}
                row={false}
                value={value}
            />
        </div>
    );
};
