/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.risk.domain.riskassessors;

import com.xebialabs.deployit.plugin.api.udm.Metadata;
import com.xebialabs.deployit.plugin.api.udm.Property;
import com.xebialabs.xlplatform.documentation.PublicApiRef;
import com.xebialabs.xlrelease.domain.Release;
import com.xebialabs.xlrelease.domain.Task;
import com.xebialabs.xlrelease.risk.domain.RiskAssessment;
import com.xebialabs.xlrelease.risk.domain.RiskProfile;
import com.xebialabs.xlrelease.risk.domain.riskassessors.RiskAssessor;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

@PublicApiRef
@Metadata(label="TaskRetriesAssessor", versioned=false)
public class TaskRetriesRiskAssessor
extends RiskAssessor {
    public static final String TASK_RETRIES_HEADLINE = "Release contains failed tasks";
    private static final String TASK_RETRIES_MESSAGE = "%s has failed %d %s";
    @Property(description="Minimum amount of retries to have to score")
    public int minRetries;
    @Property(description="Maximum amount of retries to have to score")
    public int maxRetries;

    private String suffix(int failuresCount) {
        return failuresCount == 1 ? "time" : "times";
    }

    @Override
    public RiskAssessment execute(Release release, RiskProfile riskProfile) {
        List<Task> failedActiveTasks = release.getActiveTasks().stream().filter(task -> task.isFailed() || task.isFailing()).collect(Collectors.toList());
        int totalFailedCount = failedActiveTasks.stream().mapToInt(Task::getFailuresCount).sum();
        RiskAssessment assessment = new RiskAssessment();
        assessment.setRiskAssessorId(this.getId());
        if (!failedActiveTasks.isEmpty() && totalFailedCount >= this.minRetries && totalFailedCount <= this.maxRetries) {
            ArrayList<String> messages = new ArrayList<String>();
            failedActiveTasks.forEach(task -> messages.add(String.format(TASK_RETRIES_MESSAGE, task.getTitle(), task.getFailuresCount(), this.suffix(task.getFailuresCount()))));
            assessment.setScore(riskProfile.getValueFor(this.getType()));
            assessment.setMessages(messages);
            assessment.setHeadline(TASK_RETRIES_HEADLINE);
        } else {
            assessment.setScore(0);
            assessment.setHeadline("Release is on track");
        }
        return assessment;
    }

    public int getMinRetries() {
        return this.minRetries;
    }

    public void setMinRetries(int minRetries) {
        this.minRetries = minRetries;
    }

    public int getMaxRetries() {
        return this.maxRetries;
    }

    public void setMaxRetries(int maxRetries) {
        this.maxRetries = maxRetries;
    }
}

