/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.variable;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.xebialabs.deployit.checks.Checks;
import com.xebialabs.xlrelease.domain.Release;
import com.xebialabs.xlrelease.domain.variables.PasswordStringVariable;
import com.xebialabs.xlrelease.domain.variables.Variable;
import com.xebialabs.xlrelease.utils.DateVariableUtils;
import com.xebialabs.xlrelease.variable.ValueWithInterpolation;
import com.xebialabs.xlrelease.variable.VariableCollector;
import com.xebialabs.xlrelease.variable.VariableFactory$;
import com.xebialabs.xlrelease.variable.VariableReplacementHelper;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import scala.;
import scala.$less$colon$less$;
import scala.Function1;
import scala.Option$;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Map;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.LinkedHashMap;
import scala.collection.mutable.Set$;
import scala.jdk.CollectionConverters$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class VariableHelper$
implements VariableReplacementHelper,
VariableCollector {
    public static final VariableHelper$ MODULE$ = new VariableHelper$();
    private static ObjectMapper jsonWriter;
    private static final String VARIABLE_PATTERN;
    private static final Pattern VARIABLE_NAME_PATTERN;
    private static final Pattern ONLY_ONE_VARIABLE_NAME_PATTERN;
    private static final Pattern CI_PROPERTY_VARIABLE_NAME_PATTERN;
    private static final Pattern GLOBAL_VARIABLE_NAME_PATTERN;
    private static final Pattern FOLDER_VARIABLE_NAME_PATTERN;
    private static volatile boolean bitmap$0;

    static {
        VariableReplacementHelper.$init$(MODULE$);
        VariableCollector.$init$(MODULE$);
        VARIABLE_PATTERN = "\\$\\{\\s*([^}]*[^} ])\\s*\\}";
        VARIABLE_NAME_PATTERN = Pattern.compile(MODULE$.VARIABLE_PATTERN());
        ONLY_ONE_VARIABLE_NAME_PATTERN = Pattern.compile("^\\$\\{([^}]+)\\}$");
        CI_PROPERTY_VARIABLE_NAME_PATTERN = Pattern.compile("^release\\..*$", 2);
        GLOBAL_VARIABLE_NAME_PATTERN = Pattern.compile("^global\\..*$", 2);
        FOLDER_VARIABLE_NAME_PATTERN = Pattern.compile("^folder\\..*$", 2);
    }

    @Override
    public Set<String> collectVariables(Object input) {
        return VariableCollector.collectVariables$(this, input);
    }

    @Override
    public scala.collection.immutable.Set<String> collectVariablesFromValue(Object value) {
        return VariableCollector.collectVariablesFromValue$(this, value);
    }

    @Override
    public java.util.Map<String, PasswordStringVariable> getUsedExternalPasswordVariables(Release release) {
        return VariableCollector.getUsedExternalPasswordVariables$(this, release);
    }

    @Override
    public java.util.Map<String, String> getUsedStringVariables(Release release) {
        return VariableCollector.getUsedStringVariables$(this, release);
    }

    @Override
    public void collectVariablesInScope(java.util.Map<String, Variable> allUsedVariablesMap, java.util.Map<String, Variable> scope, String variableKeyToResolve) {
        VariableCollector.collectVariablesInScope$(this, allUsedVariablesMap, scope, variableKeyToResolve);
    }

    @Override
    public String replaceAll(String raw, java.util.Map<String, String> replacements) {
        return VariableReplacementHelper.replaceAll$(this, raw, replacements);
    }

    @Override
    public <T> T replaceAll(T raw, java.util.Map<String, String> replacements, Set<String> unresolvedVariables, boolean freezeEvenIfUnresolved) {
        return (T)VariableReplacementHelper.replaceAll$(this, raw, replacements, unresolvedVariables, freezeEvenIfUnresolved);
    }

    @Override
    public <T> T replaceAllWithInterpolation(T raw, java.util.Map<String, ValueWithInterpolation> replacements, Set<String> unresolvedVariables, boolean freezeEvenIfUnresolved) {
        return (T)VariableReplacementHelper.replaceAllWithInterpolation$(this, raw, replacements, unresolvedVariables, freezeEvenIfUnresolved);
    }

    @Override
    public java.util.Map<String, String> getVariableValuesAsStrings(List<Variable> vars) {
        return VariableReplacementHelper.getVariableValuesAsStrings$(this, vars);
    }

    @Override
    public java.util.Map<String, String> getPasswordVariableValuesAsStrings(List<Variable> vars) {
        return VariableReplacementHelper.getPasswordVariableValuesAsStrings$(this, vars);
    }

    @Override
    public String freezeUnresolvedVariable(String input, String variableName) {
        return VariableReplacementHelper.freezeUnresolvedVariable$(this, input, variableName);
    }

    private String VARIABLE_PATTERN() {
        return VARIABLE_PATTERN;
    }

    public Pattern VARIABLE_NAME_PATTERN() {
        return VARIABLE_NAME_PATTERN;
    }

    private Pattern ONLY_ONE_VARIABLE_NAME_PATTERN() {
        return ONLY_ONE_VARIABLE_NAME_PATTERN;
    }

    private Pattern CI_PROPERTY_VARIABLE_NAME_PATTERN() {
        return CI_PROPERTY_VARIABLE_NAME_PATTERN;
    }

    private Pattern GLOBAL_VARIABLE_NAME_PATTERN() {
        return GLOBAL_VARIABLE_NAME_PATTERN;
    }

    private Pattern FOLDER_VARIABLE_NAME_PATTERN() {
        return FOLDER_VARIABLE_NAME_PATTERN;
    }

    public String safeReplace(String input, String key, String replacement) {
        if (input != null) {
            return input.replace(key, replacement);
        }
        return input;
    }

    public boolean isCiPropertyVariable(String variableName) {
        return this.CI_PROPERTY_VARIABLE_NAME_PATTERN().matcher(this.withoutVariableSyntax(variableName)).find();
    }

    public boolean isGlobalVariable(String variableName) {
        return this.GLOBAL_VARIABLE_NAME_PATTERN().matcher(this.withoutVariableSyntax(variableName)).find();
    }

    public boolean isFolderVariable(String variableName) {
        return this.FOLDER_VARIABLE_NAME_PATTERN().matcher(this.withoutVariableSyntax(variableName)).find();
    }

    public boolean isGlobalOrFolderVariable(String variableName) {
        return this.isGlobalVariable(variableName) || this.isFolderVariable(variableName);
    }

    public boolean containsVariables(String input) {
        return input != null && this.VARIABLE_NAME_PATTERN().matcher(input).find();
    }

    public String formatVariableIfNeeded(String variableName) {
        if (!Strings.isNullOrEmpty((String)variableName) && !this.containsOnlyVariable(variableName)) {
            return this.withVariableSyntax(variableName);
        }
        return variableName;
    }

    public boolean containsOnlyVariable(String input) {
        return !Strings.isNullOrEmpty((String)input) && this.ONLY_ONE_VARIABLE_NAME_PATTERN().matcher(input).find();
    }

    public String withVariableSyntax(String variableName) {
        return "${" + variableName + "}";
    }

    public String withoutVariableSyntax(String variableKey) {
        if (this.containsOnlyVariable(variableKey)) {
            Matcher matcher = this.ONLY_ONE_VARIABLE_NAME_PATTERN().matcher(variableKey);
            matcher.find();
            return matcher.group(1);
        }
        return variableKey;
    }

    public void checkVariable(Variable variable) {
        Preconditions.checkNotNull((Object)variable);
        variable.checkValidity();
    }

    public void checkVariables(List<Variable> variables) {
        Preconditions.checkNotNull(variables);
        variables.forEach(variable -> MODULE$.checkVariable((Variable)variable));
        Buffer keys = (Buffer)CollectionConverters$.MODULE$.ListHasAsScala(variables).asScala().map((Function1 & Serializable)x$1 -> x$1.getKey());
        scala.collection.mutable.Set uniqueKeys = (scala.collection.mutable.Set)Set$.MODULE$.empty();
        keys.foreach((Function1 & Serializable)key -> {
            VariableHelper$.$anonfun$checkVariables$3(uniqueKeys, key);
            return BoxedUnit.UNIT;
        });
    }

    public java.util.Map<String, PasswordStringVariable> getExternalVariables(List<Variable> variables) {
        return CollectionConverters$.MODULE$.MapHasAsJava((Map)((IterableOnceOps)((IterableOps)((IterableOps)CollectionConverters$.MODULE$.ListHasAsScala(variables).asScala().filter((Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)VariableHelper$.$anonfun$getExternalVariables$1(x$2)))).map((Function1 & Serializable)v -> new Tuple2((Object)v.getKey(), (Object)((PasswordStringVariable)v)))).filter((Function1 & Serializable)e -> BoxesRunTime.boxToBoolean((boolean)VariableHelper$.$anonfun$getExternalVariables$3(e)))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl())).asJava();
    }

    /*
     * WARNING - void declaration
     */
    public java.util.Map<String, Variable> indexByKey(List<Variable> variables) {
        void var2_2;
        LinkedHashMap m = new LinkedHashMap();
        Option$.MODULE$.apply(variables).foreach((Function1 & Serializable)x$3 -> {
            x$3.forEach(v -> m.put((Object)v.getKey(), v));
            return BoxedUnit.UNIT;
        });
        return CollectionConverters$.MODULE$.MutableMapHasAsJava((scala.collection.mutable.Map)var2_2).asJava();
    }

    public void checkVariableIdsAreTheSame(String requestVariableId, String bodyVariableId) {
        String string = bodyVariableId;
        String string2 = requestVariableId;
        Checks.checkArgument((!(string != null ? !string.equals(string2) : string2 != null) ? 1 : 0) != 0, (String)"Request to update variable [%s] contains an object with different ID: [%s]", (Object[])new Object[]{requestVariableId, bodyVariableId});
    }

    public boolean isGlobalVariableId(String id) {
        return id.startsWith("Configuration/variables/global/") || id.startsWith("/Configuration/variables/global/");
    }

    public List<Variable> fillVariableValues(List<Variable> target, List<Variable> source) {
        java.util.Map<String, Variable> sourceVariables = this.indexByKey(source);
        target.forEach(targetVariable -> {
            String key = targetVariable.getKey();
            if (sourceVariables.containsKey(key)) {
                Variable sourceVariable = (Variable)sourceVariables.get(key);
                if (!sourceVariable.isInherited()) {
                    if (targetVariable.getType().equals((Object)sourceVariable.getType())) {
                        targetVariable.setUntypedValue(sourceVariable.getValue());
                        return;
                    }
                    throw new IllegalArgumentException("Cannot set value of type [" + sourceVariable.getType() + "] into variable " + MODULE$.withVariableSyntax(sourceVariable.getKey()) + " of type [" + targetVariable.getType() + "]");
                }
                return;
            }
        });
        return target;
    }

    public Variable cloneVariable(Variable variable, String newKey) {
        Variable newVar = VariableFactory$.MODULE$.createVariableByValueType(newKey, variable.getValue(), false, false);
        newVar.setId(null);
        newVar.setDescription(variable.getDescription());
        newVar.setLabel(variable.getLabel());
        newVar.setValueProvider(variable.getValueProvider());
        Option$.MODULE$.apply((Object)newVar.getValueProvider()).foreach((Function1 & Serializable)x$4 -> {
            x$4.setId(null);
            return BoxedUnit.UNIT;
        });
        return newVar;
    }

    public java.util.Map<String, String> filterOutBlankStringVariables(java.util.Map<String, String> variables) {
        return CollectionConverters$.MODULE$.MapHasAsJava((Map)((IterableOnceOps)CollectionConverters$.MODULE$.MapHasAsScala(variables).asScala().filter((Function1 & Serializable)entry -> BoxesRunTime.boxToBoolean((boolean)VariableHelper$.$anonfun$filterOutBlankStringVariables$1(entry)))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl())).asJava();
    }

    public java.util.Map<String, ValueWithInterpolation> filterOutBlankValues(java.util.Map<String, ValueWithInterpolation> variables) {
        return CollectionConverters$.MODULE$.MapHasAsJava((Map)((IterableOnceOps)CollectionConverters$.MODULE$.MapHasAsScala(variables).asScala().filter((Function1 & Serializable)entry -> BoxesRunTime.boxToBoolean((boolean)VariableHelper$.$anonfun$filterOutBlankValues$1(entry)))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl())).asJava();
    }

    public HashMap<String, Variable> getAllReleaseVariablesByKeys(Release release) {
        java.util.Map<String, Variable> releaseVariables = release.getVariablesByKeys();
        java.util.Map globalVariables = release.getGlobalVariables() != null ? release.getGlobalVariables().getVariablesByKeys() : Collections.emptyMap();
        java.util.Map folderVariables = release.getFolderVariables() != null ? release.getFolderVariables().getVariablesByKeys() : Collections.emptyMap();
        HashMap<String, Variable> scope = new HashMap<String, Variable>();
        scope.putAll(releaseVariables);
        scope.putAll(globalVariables);
        scope.putAll(folderVariables);
        return scope;
    }

    private ObjectMapper jsonWriter$lzycompute() {
        VariableHelper$ variableHelper$ = this;
        synchronized (variableHelper$) {
            if (!bitmap$0) {
                jsonWriter = new ObjectMapper();
                bitmap$0 = true;
            }
        }
        return jsonWriter;
    }

    private ObjectMapper jsonWriter() {
        if (!bitmap$0) {
            return this.jsonWriter$lzycompute();
        }
        return jsonWriter;
    }

    public String toString(Object untyped) {
        Object object = untyped;
        if (object instanceof String) {
            String string = (String)object;
            return string;
        }
        if (object instanceof Date) {
            Date date = (Date)object;
            return DateVariableUtils.printDate((Date)date);
        }
        if (object instanceof java.util.Map) {
            java.util.Map map = (java.util.Map)object;
            return this.jsonWriter().writeValueAsString((Object)map);
        }
        if (object instanceof Collection) {
            Collection collection = (Collection)object;
            return this.jsonWriter().writeValueAsString((Object)collection);
        }
        return String.valueOf(untyped);
    }

    public static final /* synthetic */ void $anonfun$checkVariables$3(scala.collection.mutable.Set uniqueKeys$1, String key) {
        Preconditions.checkNotNull((Object)key);
        Preconditions.checkArgument((boolean)uniqueKeys$1.add((Object)key), (String)"The variables list contains duplicate keys: '%s'", (Object)key);
    }

    public static final /* synthetic */ boolean $anonfun$getExternalVariables$1(Variable x$2) {
        return x$2 instanceof PasswordStringVariable;
    }

    public static final /* synthetic */ boolean $anonfun$getExternalVariables$3(Tuple2 e) {
        return ((PasswordStringVariable)e._2()).getExternalVariableValue() != null;
    }

    public static final /* synthetic */ boolean $anonfun$filterOutBlankStringVariables$1(Tuple2 entry) {
        return com.xebialabs.deployit.booter.local.utils.Strings.isNotBlank((String)((String)entry._2()));
    }

    public static final /* synthetic */ boolean $anonfun$filterOutBlankValues$1(Tuple2 entry) {
        return com.xebialabs.deployit.booter.local.utils.Strings.isNotBlank((String)((ValueWithInterpolation)entry._2()).value());
    }

    private VariableHelper$() {
    }
}

