/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.api.v1;

import com.xebialabs.xlplatform.documentation.PublicApi;
import com.xebialabs.xlplatform.documentation.PublicApiMember;
import com.xebialabs.xlplatform.documentation.ShowOnlyPublicApiMembers;
import com.xebialabs.xlrelease.api.ApiService;
import com.xebialabs.xlrelease.api.v1.filter.EnvironmentFilters;
import com.xebialabs.xlrelease.api.v1.form.EnvironmentForm;
import com.xebialabs.xlrelease.api.v1.views.BaseApplicationView;
import com.xebialabs.xlrelease.api.v1.views.EnvironmentReservationView;
import com.xebialabs.xlrelease.api.v1.views.EnvironmentView;
import com.xebialabs.xlrelease.domain.environments.Application;
import com.xebialabs.xlrelease.domain.environments.Environment;
import com.xebialabs.xlrelease.domain.environments.EnvironmentReservation;
import com.xebialabs.xlrelease.rest.AllCILevels;
import java.util.List;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;

@Path(value="/api/v1/environments")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
@AllCILevels
@PublicApi
@ShowOnlyPublicApiMembers
public interface EnvironmentApi
extends ApiService {
    @Override
    default public String serviceName() {
        return "environmentApi";
    }

    @POST
    public EnvironmentView createEnvironment(EnvironmentForm var1);

    @GET
    @Path(value="/{environmentId:.*/Environment[^/]*}")
    public EnvironmentView getEnvironment(@PathParam(value="environmentId") String var1);

    @PUT
    @Path(value="/{environmentId:.*/Environment[^/]*}")
    public EnvironmentView updateEnvironment(@PathParam(value="environmentId") String var1, EnvironmentForm var2);

    @POST
    @Path(value="/search")
    public List<EnvironmentView> searchEnvironments(EnvironmentFilters var1);

    @GET
    @Path(value="/{environmentId:.*/Environment[^/]*}/reservations")
    public List<EnvironmentReservationView> getReservationsForEnvironment(@PathParam(value="environmentId") String var1);

    @GET
    @Path(value="/{environmentId:.*/Environment[^/]*}/applications")
    public List<BaseApplicationView> getDeployableApplicationsForEnvironment(@PathParam(value="environmentId") String var1);

    @DELETE
    @PublicApiMember
    @Path(value="/{environmentId:.*/Environment[^/]*}")
    public void delete(@PathParam(value="environmentId") String var1);

    @PublicApiMember
    public Environment create(Environment var1);

    @PublicApiMember
    public Environment getById(String var1);

    @PublicApiMember
    public Environment update(Environment var1);

    @PublicApiMember
    public List<Environment> search(EnvironmentFilters var1);

    @PublicApiMember
    public List<EnvironmentReservation> getReservations(String var1);

    @PublicApiMember
    public List<Application> getDeployableApplications(String var1);
}

