/*
 * Decompiled with CFR 0.152.
 */
package org.commonmark.ext.gfm.tables.internal;

import org.commonmark.ext.gfm.tables.TableBlock;
import org.commonmark.ext.gfm.tables.TableBody;
import org.commonmark.ext.gfm.tables.TableCell;
import org.commonmark.ext.gfm.tables.TableHead;
import org.commonmark.ext.gfm.tables.TableRow;
import org.commonmark.ext.gfm.tables.internal.TableNodeRenderer;
import org.commonmark.node.Node;
import org.commonmark.renderer.text.TextContentNodeRendererContext;
import org.commonmark.renderer.text.TextContentWriter;

public class TableTextContentNodeRenderer
extends TableNodeRenderer {
    private final TextContentWriter textContentWriter;
    private final TextContentNodeRendererContext context;

    public TableTextContentNodeRenderer(TextContentNodeRendererContext context) {
        this.textContentWriter = context.getWriter();
        this.context = context;
    }

    @Override
    protected void renderBlock(TableBlock tableBlock) {
        this.renderChildren((Node)tableBlock);
        if (tableBlock.getNext() != null) {
            this.textContentWriter.write("\n");
        }
    }

    @Override
    protected void renderHead(TableHead tableHead) {
        this.renderChildren((Node)tableHead);
    }

    @Override
    protected void renderBody(TableBody tableBody) {
        this.renderChildren((Node)tableBody);
    }

    @Override
    protected void renderRow(TableRow tableRow) {
        this.textContentWriter.line();
        this.renderChildren((Node)tableRow);
        this.textContentWriter.line();
    }

    @Override
    protected void renderCell(TableCell tableCell) {
        this.renderChildren((Node)tableCell);
        this.textContentWriter.write('|');
        this.textContentWriter.whitespace();
    }

    private void renderLastCell(TableCell tableCell) {
        this.renderChildren((Node)tableCell);
    }

    private void renderChildren(Node parent) {
        Node node = parent.getFirstChild();
        while (node != null) {
            Node next = node.getNext();
            if (node instanceof TableCell && next == null) {
                this.renderLastCell((TableCell)node);
            } else {
                this.context.render(node);
            }
            node = next;
        }
    }
}

