/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2.operations;

import java.util.ArrayList;
import java.util.Collection;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.operations.FileOperation;
import org.apache.commons.vfs2.operations.FileOperationProvider;

public abstract class AbstractFileOperationProvider
implements FileOperationProvider {
    private final Collection<Class<? extends FileOperation>> operations = new ArrayList<Class<? extends FileOperation>>();

    @Override
    public final void collectOperations(Collection<Class<? extends FileOperation>> operationsList, FileObject file) throws FileSystemException {
        this.doCollectOperations(this.operations, operationsList, file);
    }

    protected abstract void doCollectOperations(Collection<Class<? extends FileOperation>> var1, Collection<Class<? extends FileOperation>> var2, FileObject var3) throws FileSystemException;

    @Override
    public final FileOperation getOperation(FileObject file, Class<? extends FileOperation> operationClass) throws FileSystemException {
        return this.instantiateOperation(file, this.lookupOperation(operationClass));
    }

    protected abstract FileOperation instantiateOperation(FileObject var1, Class<? extends FileOperation> var2) throws FileSystemException;

    protected final Class<? extends FileOperation> lookupOperation(Class<? extends FileOperation> operationClass) throws FileSystemException {
        if (!FileOperation.class.isAssignableFrom(operationClass)) {
            throw new FileSystemException("vfs.operation/wrong-type.error", (Object)operationClass);
        }
        Class<? extends FileOperation> foundClass = null;
        for (Class<? extends FileOperation> operation : this.operations) {
            if (!operationClass.isAssignableFrom(operation)) continue;
            foundClass = operation;
            break;
        }
        if (foundClass == null) {
            throw new FileSystemException("vfs.operation/not-found.error", (Object)operationClass);
        }
        return foundClass;
    }

    protected final void addOperation(Class<? extends FileOperation> operationClass) throws FileSystemException {
        if (!FileOperation.class.isAssignableFrom(operationClass)) {
            throw new FileSystemException("vfs.operation/cant-register.error", (Object)operationClass);
        }
        this.operations.add(operationClass);
    }
}

