/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.reports.api.internal;

import com.codahale.metrics.annotation.Timed;
import com.google.common.collect.Maps;
import com.xebialabs.deployit.booter.local.utils.Strings;
import com.xebialabs.deployit.checks.Checks;
import com.xebialabs.deployit.security.Permissions;
import com.xebialabs.xlrelease.api.utils.ResponseHelper;
import com.xebialabs.xlrelease.api.v1.forms.TimeFrame;
import com.xebialabs.xlrelease.domain.UserProfile;
import com.xebialabs.xlrelease.domain.validators.UserAccountValidator;
import com.xebialabs.xlrelease.reports.api.internal.ReportForm;
import com.xebialabs.xlrelease.reports.dto.AverageAndLongestReleaseDuration;
import com.xebialabs.xlrelease.reports.dto.AverageAndLongestTaskDuration;
import com.xebialabs.xlrelease.reports.dto.CompletedReleases;
import com.xebialabs.xlrelease.reports.dto.LongestTaskType;
import com.xebialabs.xlrelease.reports.dto.PhaseDuration;
import com.xebialabs.xlrelease.reports.dto.ReleaseAutomationData;
import com.xebialabs.xlrelease.reports.dto.ReleasesAutomation;
import com.xebialabs.xlrelease.reports.dto.ReleasesDuration;
import com.xebialabs.xlrelease.reports.dto.TaskDuration;
import com.xebialabs.xlrelease.reports.dto.UserParticipation;
import com.xebialabs.xlrelease.reports.job.api.ReportDefinition;
import com.xebialabs.xlrelease.reports.job.api.ReportingEngineService;
import com.xebialabs.xlrelease.reports.job.api.StreamingReportResult;
import com.xebialabs.xlrelease.reports.job.domain.ReportJob;
import com.xebialabs.xlrelease.reports.job.domain.ReportJobStatus;
import com.xebialabs.xlrelease.reports.job.repository.ReportJobFilters;
import com.xebialabs.xlrelease.reports.pdf.DashboardReportService;
import com.xebialabs.xlrelease.reports.service.ReportParams;
import com.xebialabs.xlrelease.reports.service.ReportServiceCache;
import com.xebialabs.xlrelease.reports.service.ReportsService;
import com.xebialabs.xlrelease.reports.utils.ReportUtils;
import com.xebialabs.xlrelease.security.PermissionChecker;
import com.xebialabs.xlrelease.security.XLReleasePermissions;
import com.xebialabs.xlrelease.service.UserProfileService;
import com.xebialabs.xlrelease.utils.SortSupport;
import com.xebialabs.xlrelease.views.Point;
import java.time.Instant;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.ws.rs.BeanParam;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.StreamingOutput;
import javax.ws.rs.core.UriInfo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.stereotype.Controller;
import scala.jdk.javaapi.CollectionConverters;

@Path(value="/reports")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
@Controller
public class ReportResource {
    private PermissionChecker permissions;
    private ReportServiceCache reportService;
    private ReportingEngineService reportingEngineService;
    private UserProfileService userProfileService;
    private ReportsService reportsService;
    private DashboardReportService dashboardReportService;

    @Autowired
    public ReportResource(PermissionChecker permissions, ReportServiceCache reportService, ReportingEngineService reportingEngineService, UserProfileService userProfileService, ReportsService reportsService, DashboardReportService dashboardReportService) {
        this.permissions = permissions;
        this.reportService = reportService;
        this.reportingEngineService = reportingEngineService;
        this.userProfileService = userProfileService;
        this.reportsService = reportsService;
        this.dashboardReportService = dashboardReportService;
    }

    @POST
    @Timed
    @Path(value="releases/duration")
    public ReleasesDuration getReleaseDuration(ReportForm reportForm) {
        this.checkPermission(reportForm);
        return this.reportService.getReleaseDuration(ReportParams.apply(reportForm));
    }

    @POST
    @Timed
    @Path(value="most-involved-people")
    public List<UserParticipation> getTopPeopleMostInvolved(ReportForm reportForm) {
        this.checkPermission(reportForm);
        return this.reportService.getTopPeopleMostInvolved(ReportParams.apply(reportForm));
    }

    @POST
    @Timed
    @Path(value="longest-tasks")
    public List<TaskDuration> getTopLongestTasks(ReportForm reportForm) {
        this.checkPermission(reportForm);
        return this.reportService.getTopLongestTasks(ReportParams.apply(reportForm));
    }

    @POST
    @Timed
    @Path(value="longest-task-types")
    public List<LongestTaskType> getTopLongestTaskTypes(ReportForm reportForm) {
        this.checkPermission(reportForm);
        return this.reportService.getTopLongestTaskTypes(ReportParams.apply(reportForm));
    }

    @POST
    @Timed
    @Path(value="average-and-longest-task-duration")
    public AverageAndLongestTaskDuration getAverageAndLongestTaskDuration(ReportForm reportForm) {
        this.checkPermission(reportForm);
        return this.reportService.getAverageAndLongestTaskDuration(ReportParams.apply(reportForm));
    }

    @POST
    @Timed
    @Path(value="release/completed")
    public CompletedReleases getCompletedReleases(ReportForm reportForm) {
        this.checkPermission(reportForm);
        return this.reportService.getCompletedReleases(ReportParams.apply(reportForm));
    }

    @POST
    @Timed
    @Path(value="release/average-and-longest-release-duration")
    public AverageAndLongestReleaseDuration getAverageAndLongestReleaseDuration(ReportForm reportForm) {
        this.checkPermission(reportForm);
        return this.reportService.getAverageAndLongestReleaseDuration(ReportParams.apply(reportForm));
    }

    @POST
    @Timed
    @Path(value="releases/automation")
    public ReleasesAutomation getReleaseAutomation(ReportForm reportForm) {
        this.checkPermission(reportForm);
        return this.reportService.getReleaseAutomationSeries(ReportParams.apply(reportForm));
    }

    @POST
    @Timed
    @Path(value="longest-phases")
    public List<PhaseDuration> getTopLongestPhases(ReportForm reportForm) {
        this.checkPermission(reportForm);
        return this.reportService.getTopLongestPhases(ReportParams.apply(reportForm));
    }

    @POST
    @Timed
    @Path(value="releases/number-by-month")
    public List<Point> getNumberOfReleaseByMonth(ReportForm reportForm) {
        this.checkPermission(reportForm);
        return this.reportService.getNumberOfReleaseByMonth(ReportParams.apply(reportForm));
    }

    @POST
    @Timed
    @Path(value="releases/most-recent/{limit}")
    public List<ReleaseAutomationData> getMostRecentReleaseData(@PathParam(value="limit") Integer limit, ReportForm reportForm) {
        this.checkPermission(reportForm);
        ReportParams params = ReportParams.apply(TimeFrame.RANGE, reportForm.getFrom(), reportForm.getTo(), ReportUtils.splitTags(reportForm.getTags()), reportForm.getFilters(), reportForm.isUserSpecific(), limit, reportForm.isRefresh());
        return this.reportService.getMostRecentReleasesData(params);
    }

    private void checkPermission(ReportForm reportForm) {
        if (!this.permissions.hasGlobalPermission(XLReleasePermissions.AUDIT_ALL) && reportForm.isUserSpecific()) {
            this.permissions.check(XLReleasePermissions.VIEW_REPORTS);
        }
    }

    @POST
    @Timed
    @Path(value="preview")
    @Produces(value={"application/json"})
    public Response preview(ReportDefinition report) {
        this.permissions.check(XLReleasePermissions.AUDIT_ALL);
        String generatedBy = Permissions.getAuthenticatedUserName();
        report.setGeneratedBy(generatedBy);
        Map response = (Map)this.reportingEngineService.preview(report);
        return Response.ok((Object)response).build();
    }

    @POST
    @Timed
    @Path(value="submit")
    @Produces(value={"application/json"})
    public Response submit(ReportDefinition report) {
        this.permissions.check(XLReleasePermissions.AUDIT_ALL);
        String generatedBy = Permissions.getAuthenticatedUserName();
        report.setGeneratedBy(generatedBy);
        report.setGeneratedOn(Date.from(Instant.now()));
        Integer jobId = this.reportingEngineService.submit(report);
        HashMap submitResult = Maps.newHashMap();
        submitResult.put("jobId", jobId);
        UserProfile userProfile = this.userProfileService.findByUsername(generatedBy);
        if (this.isValidEmailConfigured(userProfile.getEmail())) {
            submitResult.put("emailConfigured", true);
        } else {
            submitResult.put("emailConfigured", false);
        }
        return Response.ok((Object)submitResult).build();
    }

    @GET
    @Timed
    @Path(value="download/{jobId}")
    @Produces(value={"application/octet-stream"})
    public Response download(@PathParam(value="jobId") Integer jobId) {
        this.permissions.check(XLReleasePermissions.AUDIT_ALL);
        StreamingReportResult reportResult = this.reportingEngineService.getResult(jobId);
        return ResponseHelper.streamFile((String)reportResult.fileName(), reportResult::write, (String)reportResult.contentType());
    }

    @GET
    @Timed
    @Path(value="status/{jobId}")
    @Produces(value={"application/json"})
    public Response status(@PathParam(value="jobId") Integer jobId) {
        this.permissions.check(XLReleasePermissions.AUDIT_ALL);
        ReportJobStatus status = this.reportingEngineService.status(jobId);
        return Response.ok((Object)((Object)status)).build();
    }

    @GET
    @Timed
    @Path(value="{jobId}")
    @Produces(value={"application/json"})
    public Response get(@PathParam(value="jobId") Integer jobId) {
        this.permissions.check(XLReleasePermissions.AUDIT_ALL);
        ReportJob reportJob = this.reportingEngineService.get(jobId);
        return Response.ok((Object)((Object)reportJob)).build();
    }

    @GET
    @Timed
    @Path(value="search")
    @Produces(value={"application/json"})
    public Page<ReportJob> search(@BeanParam ReportJobFilters reportJobFilters, @DefaultValue(value="0") @QueryParam(value="page") int page, @DefaultValue(value="100") @QueryParam(value="resultsPerPage") int resultsPerPage, @Context UriInfo uriInfo) {
        Checks.checkArgument(((long)resultsPerPage <= 100L ? 1 : 0) != 0, (String)"Number of results per page cannot be more than 100", (Object[])new Object[0]);
        PageRequest pageable = PageRequest.of((int)page, (int)resultsPerPage, (Sort)SortSupport.toSort((UriInfo)uriInfo));
        return this.search(reportJobFilters, (Pageable)pageable);
    }

    @POST
    @Timed
    @Path(value="poll")
    @Produces(value={"application/json"})
    public List<ReportJob> poll(List<Integer> jobIds) {
        Checks.checkNotNull(jobIds, (String)"Report job id list can not be null.", (Object[])new Object[]{""});
        if (jobIds.isEmpty()) {
            return Collections.emptyList();
        }
        ReportJobFilters reportJobFilters = new ReportJobFilters();
        reportJobFilters.setJobIds(jobIds);
        PageRequest pageable = PageRequest.of((int)0, (int)Integer.MAX_VALUE);
        return this.search(reportJobFilters, (Pageable)pageable).getContent();
    }

    @GET
    @Timed
    @Path(value="applicationNames")
    @Produces(value={"application/json"})
    public Set<String> applicationsNames() {
        this.permissions.check(XLReleasePermissions.AUDIT_ALL);
        return CollectionConverters.asJava(this.reportsService.getAllApplicationNames());
    }

    @GET
    @Timed
    @Path(value="environmentNames")
    @Produces(value={"application/json"})
    public Set<String> environmentNames() {
        this.permissions.check(XLReleasePermissions.AUDIT_ALL);
        return CollectionConverters.asJava(this.reportsService.getAllEnvironmentNames());
    }

    @POST
    @Timed
    @Path(value="{jobId}/abort")
    @Produces(value={"application/json"})
    public Response abort(@PathParam(value="jobId") Integer jobId) {
        this.permissions.check(XLReleasePermissions.AUDIT_ALL);
        this.reportingEngineService.abort(jobId);
        return Response.ok().build();
    }

    @POST
    @Timed
    @Path(value="abort")
    @Produces(value={"application/json"})
    public Response abort(List<Integer> jobIds) {
        this.permissions.check(XLReleasePermissions.AUDIT_ALL);
        Checks.checkNotNull(jobIds, (String)"Report job id list can not be null.", (Object[])new Object[]{""});
        List<Integer> abortedJobIds = this.reportingEngineService.abort(jobIds);
        return this.returnList("abortedJobIds", abortedJobIds);
    }

    @POST
    @Timed
    @Path(value="abort/all")
    @Produces(value={"application/json"})
    public Response abortAll() {
        this.permissions.check(XLReleasePermissions.AUDIT_ALL);
        List<Integer> abortedJobIds = this.reportingEngineService.abortAll();
        return this.returnList("abortedJobIds", abortedJobIds);
    }

    @DELETE
    @Timed
    @Path(value="{jobId}")
    @Produces(value={"application/json"})
    public Response delete(@PathParam(value="jobId") Integer jobId) {
        this.permissions.check(XLReleasePermissions.AUDIT_ALL);
        this.reportingEngineService.delete(jobId);
        return Response.ok().build();
    }

    @POST
    @Timed
    @Path(value="delete")
    @Produces(value={"application/json"})
    public Response delete(List<Integer> jobIds) {
        this.permissions.check(XLReleasePermissions.AUDIT_ALL);
        Checks.checkNotNull(jobIds, (String)"Report job id list can not be null.", (Object[])new Object[]{""});
        List<Integer> deletedJobIds = this.reportingEngineService.delete(jobIds);
        return this.returnList("deletedJobIds", deletedJobIds);
    }

    @POST
    @Timed
    @Path(value="delete/all")
    @Produces(value={"application/json"})
    public Response deleteAll() {
        this.permissions.check(XLReleasePermissions.AUDIT_ALL);
        List<Integer> deletedJobIds = this.reportingEngineService.deleteAll();
        return this.returnList("deletedJobIds", deletedJobIds);
    }

    @POST
    @Path(value="pdf/{reportName}")
    @Produces(value={"application/octet-stream"})
    public Response generateReportPdf(@PathParam(value="reportName") String reportName, String pngContent) {
        StreamingOutput output = outputStream -> this.dashboardReportService.generateDashboardReport(pngContent, reportName, outputStream);
        return ResponseHelper.streamFile((String)(reportName + ".pdf"), (StreamingOutput)output, (String)"application/pdf");
    }

    private Response returnList(String listTitle, List<Integer> items) {
        return Response.ok(Collections.singletonMap(listTitle, items)).build();
    }

    private Page<ReportJob> search(ReportJobFilters reportJobFilters, Pageable pageable) {
        this.permissions.check(XLReleasePermissions.AUDIT_ALL);
        ReportJobFilters filters = reportJobFilters == null ? new ReportJobFilters() : reportJobFilters;
        return this.reportingEngineService.findBy(filters, pageable);
    }

    private boolean isValidEmailConfigured(String email) {
        return Strings.isNotBlank((String)email) && UserAccountValidator.isValidEmailAddress((String)email);
    }

    public static enum ReportType {
        RELEASE_DURATION,
        RELEASE_AUTOMATION,
        TOP_PEOPLE_MOST_INVOLVED,
        TOP_LONGEST_TASK,
        TOP_LONGEST_PHASE,
        TOP_LONGEST_RELEASE,
        NUMBER_OF_RELEASE_BY_MONTH;

    }
}

