/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlplatform.cluster;

import akka.actor.ActorRef;
import akka.actor.ActorSystem;
import akka.actor.ExtendedActorSystem;
import akka.actor.Extension;
import akka.cluster.Cluster;
import akka.cluster.Cluster$;
import com.xebialabs.xlplatform.cluster.ClusterConfig;
import com.xebialabs.xlplatform.cluster.ClusterMode;
import com.xebialabs.xlplatform.cluster.ClusterMode$Full$;
import com.xebialabs.xlplatform.cluster.ClusterMode$HotStandby$;
import com.xebialabs.xlplatform.cluster.XlCluster$;
import com.xebialabs.xlplatform.cluster.full.FullClusterNodeStateManager$;
import com.xebialabs.xlplatform.cluster.hotstandby.HotStandbyClusterNodeStateManager$;
import com.xebialabs.xlplatform.cluster.membership.ClusterDiscoveryActor;
import com.xebialabs.xlplatform.cluster.membership.ClusterDiscoveryActor$;
import com.xebialabs.xlplatform.cluster.membership.storage.ClusterMembershipManagement$;
import com.xebialabs.xlplatform.cluster.membership.storage.ClusterMembershipSQLManagement;
import com.zaxxer.hikari.HikariDataSource;
import scala.Function0;
import scala.Function1;
import scala.concurrent.ExecutionContextExecutor;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u000514AAD\b\u00011!Aq\u0005\u0001B\u0001B\u0003%\u0001\u0006\u0003\u0005,\u0001\t\u0005\t\u0015!\u0003-\u0011\u0015\u0001\u0004\u0001\"\u00012\u0011\u001d)\u0004A1A\u0005\fYBaa\u000e\u0001!\u0002\u0013A\u0003b\u0002\u001d\u0001\u0005\u0004%Y!\u000f\u0005\u0007\u0001\u0002\u0001\u000b\u0011\u0002\u001e\t\u000fA\u0001!\u0019!C\u0005\u0003\"1q\t\u0001Q\u0001\n\tCq\u0001\u0013\u0001C\u0002\u0013\u0005\u0011\n\u0003\u0004S\u0001\u0001\u0006IA\u0013\u0005\u0006'\u0002!\t\u0001\u0016\u0005\u0006K\u0002!\tA\u001a\u0002\u001212\u001cE.^:uKJ\u0004&o\u001c<jI\u0016\u0014(B\u0001\t\u0012\u0003\u001d\u0019G.^:uKJT!AE\n\u0002\u0015ad\u0007\u000f\\1uM>\u0014XN\u0003\u0002\u0015+\u0005I\u00010\u001a2jC2\f'm\u001d\u0006\u0002-\u0005\u00191m\\7\u0004\u0001M\u0019\u0001!G\u0010\u0011\u0005iiR\"A\u000e\u000b\u0003q\tQa]2bY\u0006L!AH\u000e\u0003\r\u0005s\u0017PU3g!\t\u0001S%D\u0001\"\u0015\t\u00113%A\u0003bGR|'OC\u0001%\u0003\u0011\t7n[1\n\u0005\u0019\n#!C#yi\u0016t7/[8o\u00039)\u0007\u0010^3oI\u0016$7+_:uK6\u0004\"\u0001I\u0015\n\u0005)\n#aE#yi\u0016tG-\u001a3BGR|'oU=ti\u0016l\u0017AB2p]\u001aLw\r\u0005\u0002.]5\tq\"\u0003\u00020\u001f\ti1\t\\;ti\u0016\u00148i\u001c8gS\u001e\fa\u0001P5oSRtDc\u0001\u001a4iA\u0011Q\u0006\u0001\u0005\u0006O\r\u0001\r\u0001\u000b\u0005\u0006W\r\u0001\r\u0001L\u0001\u0007gf\u001cH/Z7\u0016\u0003!\nqa]=ti\u0016l\u0007%\u0001\tfq\u0016\u001cW\u000f^5p]\u000e{g\u000e^3yiV\t!\b\u0005\u0002<}5\tAH\u0003\u0002>7\u0005Q1m\u001c8dkJ\u0014XM\u001c;\n\u0005}b$\u0001G#yK\u000e,H/[8o\u0007>tG/\u001a=u\u000bb,7-\u001e;pe\u0006\tR\r_3dkRLwN\\\"p]R,\u0007\u0010\u001e\u0011\u0016\u0003\t\u0003\"aQ#\u000e\u0003\u0011S!\u0001E\u0012\n\u0005\u0019#%aB\"mkN$XM]\u0001\tG2,8\u000f^3sA\u0005!R.Z7cKJ\u001c\b.\u001b9NC:\fw-Z7f]R,\u0012A\u0013\t\u0003\u0017Bk\u0011\u0001\u0014\u0006\u0003\u001b:\u000bqa\u001d;pe\u0006<WM\u0003\u0002P\u001f\u0005QQ.Z7cKJ\u001c\b.\u001b9\n\u0005Ec%AH\"mkN$XM]'f[\n,'o\u001d5jaN\u000bF*T1oC\u001e,W.\u001a8u\u0003UiW-\u001c2feND\u0017\u000e]'b]\u0006<W-\\3oi\u0002\n\u0001\u0003Z8XSRDG)\u0019;bg>,(oY3\u0015\u0005UC\u0006C\u0001\u000eW\u0013\t96D\u0001\u0003V]&$\b\"B-\r\u0001\u0004Q\u0016\u0001C2bY2\u0014\u0017mY6\u0011\tiYV,V\u0005\u00039n\u0011\u0011BR;oGRLwN\\\u0019\u0011\u0005y\u001bW\"A0\u000b\u0005\u0001\f\u0017A\u00025jW\u0006\u0014\u0018N\u0003\u0002c+\u00051!0\u0019=yKJL!\u0001Z0\u0003!!K7.\u0019:j\t\u0006$\u0018mU8ve\u000e,\u0017!B:uCJ$HCA+h\u0011\u0015AW\u00021\u0001j\u0003)Ig.\u001b;jC2L'0\u001a\t\u00045),\u0016BA6\u001c\u0005%1UO\\2uS>t\u0007\u0007")
public class XlClusterProvider
implements Extension {
    private final ClusterConfig config;
    private final ExtendedActorSystem system;
    private final ExecutionContextExecutor executionContext;
    private final Cluster cluster;
    private final ClusterMembershipSQLManagement membershipManagement;

    private ExtendedActorSystem system() {
        return this.system;
    }

    private ExecutionContextExecutor executionContext() {
        return this.executionContext;
    }

    private Cluster cluster() {
        return this.cluster;
    }

    public ClusterMembershipSQLManagement membershipManagement() {
        return this.membershipManagement;
    }

    public void doWithDatasource(Function1<HikariDataSource, BoxedUnit> callback) {
        callback.apply((Object)this.membershipManagement().datasource());
    }

    public void start(Function0<BoxedUnit> initialize) {
        ActorRef actorRef;
        ClusterMode clusterMode = this.config.mode();
        if (ClusterMode$Full$.MODULE$.equals(clusterMode)) {
            actorRef = this.system().actorOf(FullClusterNodeStateManager$.MODULE$.stateManager(initialize));
        } else if (ClusterMode$HotStandby$.MODULE$.equals(clusterMode)) {
            actorRef = this.system().actorOf(HotStandbyClusterNodeStateManager$.MODULE$.stateManager(initialize));
        } else {
            throw new IllegalArgumentException("This extension is only valid with cluster usage.");
        }
        ActorRef clusterStateManagerActor = actorRef;
        ActorRef discoveryActor = this.system().actorOf(ClusterDiscoveryActor$.MODULE$.props(this.cluster(), this.membershipManagement(), this.config.membership().heartbeatInterval()));
        ClusterDiscoveryActor.Start x$1 = new ClusterDiscoveryActor.Start(clusterStateManagerActor);
        ActorRef x$2 = discoveryActor.$bang$default$2((Object)x$1);
        discoveryActor.$bang((Object)x$1, x$2);
        XlCluster$.MODULE$.cluster().set(this.cluster());
        XlCluster$.MODULE$.membershipManagement().set(this.membershipManagement());
        XlCluster$.MODULE$.actorSystem().set((ActorSystem)this.system());
    }

    public XlClusterProvider(ExtendedActorSystem extendedSystem, ClusterConfig config) {
        this.config = config;
        this.system = extendedSystem;
        this.executionContext = extendedSystem.dispatcher();
        this.cluster = (Cluster)Cluster$.MODULE$.apply((ActorSystem)this.system());
        this.membershipManagement = ClusterMembershipManagement$.MODULE$.selectDialect(config.membership().datasource(), config.membership().ttl(), ClusterMembershipManagement$.MODULE$.selectDialect$default$3());
    }
}

