/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlplatform.cluster.full.downing;

import akka.actor.Address;
import akka.actor.Props;
import akka.cluster.Member;
import com.xebialabs.xlplatform.cluster.NodeState$;
import com.xebialabs.xlplatform.cluster.full.downing.AutoDowning$;
import com.xebialabs.xlplatform.cluster.full.downing.LeaderAutoDowningActor;
import com.xebialabs.xlplatform.cluster.full.downing.LeaderAutoDowningActor$DownReachable$;
import com.xebialabs.xlplatform.cluster.full.downing.LeaderAutoDowningActor$DownUnreachable$;
import com.xebialabs.xlplatform.cluster.full.downing.OldestLeaderAutoDowning$;
import java.io.Serializable;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.collection.immutable.Seq;
import scala.concurrent.duration.FiniteDuration;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0005%<Qa\u0003\u0007\t\u0002e1Qa\u0007\u0007\t\u0002qAQaI\u0001\u0005\u0002\u0011BQ!J\u0001\u0005\u0002\u00192Aa\u0007\u0007\u0001w!I\u0001\u0007\u0002B\u0001B\u0003%\u0011g\u0010\u0005\nu\u0011\u0011\t\u0011)A\u0005c\u0001CQa\t\u0003\u0005\u0002\u0005CQ!\u0012\u0003\u0005\u0002\u0019CQ!\u0018\u0003\u0005ByCQa\u001a\u0003\u0005B!\fqc\u00147eKN$H*Z1eKJ\fU\u000f^8E_^t\u0017N\\4\u000b\u00055q\u0011a\u00023po:Lgn\u001a\u0006\u0003\u001fA\tAAZ;mY*\u0011\u0011CE\u0001\bG2,8\u000f^3s\u0015\t\u0019B#\u0001\u0006yYBd\u0017\r\u001e4pe6T!!\u0006\f\u0002\u0013a,'-[1mC\n\u001c(\"A\f\u0002\u0007\r|Wn\u0001\u0001\u0011\u0005i\tQ\"\u0001\u0007\u0003/=cG-Z:u\u0019\u0016\fG-\u001a:BkR|Gi\\<oS:<7CA\u0001\u001e!\tq\u0012%D\u0001 \u0015\u0005\u0001\u0013!B:dC2\f\u0017B\u0001\u0012 \u0005\u0019\te.\u001f*fM\u00061A(\u001b8jiz\"\u0012!G\u0001\u0006aJ|\u0007o\u001d\u000b\u0004O=J\u0004C\u0001\u0015.\u001b\u0005I#B\u0001\u0016,\u0003\u0015\t7\r^8s\u0015\u0005a\u0013\u0001B1lW\u0006L!AL\u0015\u0003\u000bA\u0013x\u000e]:\t\u000bA\u001a\u0001\u0019A\u0019\u0002\u0017M$\u0018M\u00197f\u0003\u001a$XM\u001d\t\u0003e]j\u0011a\r\u0006\u0003iU\n\u0001\u0002Z;sCRLwN\u001c\u0006\u0003m}\t!bY8oGV\u0014(/\u001a8u\u0013\tA4G\u0001\bGS:LG/\u001a#ve\u0006$\u0018n\u001c8\t\u000bi\u001a\u0001\u0019A\u0019\u0002#\u0011|wO\u001c*f[>4\u0018\r\\'be\u001eLgn\u0005\u0002\u0005yA\u0011!$P\u0005\u0003}1\u0011a\u0003T3bI\u0016\u0014\u0018)\u001e;p\t><h.\u001b8h\u0003\u000e$xN]\u0005\u0003auJ!AO\u001f\u0015\u0007\t\u001bE\t\u0005\u0002\u001b\t!)\u0001g\u0002a\u0001c!)!h\u0002a\u0001c\u00051A-Z2jI\u0016$\u0012a\u0012\t\u0003\u0011js!!\u0013-\u000f\u0005);fBA&W\u001d\taUK\u0004\u0002N):\u0011aj\u0015\b\u0003\u001fJk\u0011\u0001\u0015\u0006\u0003#b\ta\u0001\u0010:p_Rt\u0014\"A\f\n\u0005U1\u0012BA\n\u0015\u0013\t\t\"#\u0003\u0002\u0010!%\u0011QBD\u0005\u000332\ta\u0003T3bI\u0016\u0014\u0018)\u001e;p\t><h.\u001b8h\u0003\u000e$xN]\u0005\u00037r\u0013!\u0002R8x]\u0006\u001bG/[8o\u0015\tIF\"\u0001\u0003e_^tGCA0c!\tq\u0002-\u0003\u0002b?\t!QK\\5u\u0011\u0015\u0019\u0017\u00021\u0001e\u0003\u0011qw\u000eZ3\u0011\u0005!*\u0017B\u00014*\u0005\u001d\tE\r\u001a:fgN\f\u0001\u0002Z8x]N+GN\u001a\u000b\u0002?\u0002")
public class OldestLeaderAutoDowning
extends LeaderAutoDowningActor {
    public static Props props(FiniteDuration stableAfter, FiniteDuration downRemovalMargin) {
        return OldestLeaderAutoDowning$.MODULE$.props(stableAfter, downRemovalMargin);
    }

    @Override
    public LeaderAutoDowningActor.DownAction decide() {
        int unreachableSize = this.unreachableMembers().size();
        int membersSize = this.members().size();
        this.log().info("Deciding on current cluster state: " + unreachableSize + " of " + membersSize + " members unreachable.");
        Seq<Address> activeMembers = this.getActiveMembers();
        Option option = this.members().find((Function1 & Serializable)member -> BoxesRunTime.boxToBoolean((boolean)activeMembers.contains((Object)member.address())));
        if (None$.MODULE$.equals(option)) {
            this.log().info("Downing my partition [" + this.reachable() + "] - no active cluster members found.");
            return LeaderAutoDowningActor$DownReachable$.MODULE$;
        }
        if (option instanceof Some) {
            Some some = (Some)option;
            Member oldestMember = (Member)some.value();
            this.log().info("Current active oldest member is [" + oldestMember.address() + "].");
            if (this.unreachable().apply((Object)oldestMember.address())) {
                this.log().info("Downing my partition [" + this.reachable() + "] - other partition has active oldest.");
                return LeaderAutoDowningActor$DownReachable$.MODULE$;
            }
            this.log().info("Downing other partition [" + this.unreachable() + "] - my partition has the current active oldest.");
            return LeaderAutoDowningActor$DownUnreachable$.MODULE$;
        }
        throw new MatchError((Object)option);
    }

    @Override
    public void down(Address node) {
        this.log().info("Downing member [{}].", (Object)node);
        this.cluster().down(node);
    }

    @Override
    public void downSelf() {
        this.log().info("Deactivating myself.");
        NodeState$.MODULE$.setActive(false);
        AutoDowning$.MODULE$.setDowning(true);
        this.log().info("Downing myself.");
        this.shutdownMember();
    }

    public OldestLeaderAutoDowning(FiniteDuration stableAfter, FiniteDuration downRemovalMargin) {
        super(stableAfter, downRemovalMargin);
    }
}

