import React, { useEffect } from 'react';
import { DotButton, DotThemeProvider } from '@digital-ai/dot-components';
import './applications-page.component.less';
import { CreateApplicationDrawer } from './components/create-application-drawer';
import { applicationManagement } from '../../ducks/managed-application.reducer';
import { useAppDispatch, useAppSelector } from '../../../../../../../../../../core/xlr-ui/app/js/hooks';
import { Template } from '../../managed-application.types';
import { getTemplates } from '../../ducks/managed-application.selectors';
import { Folder } from '../../../../../../../../../../core/xlr-ui/app/types';

const { fetchTemplates } = applicationManagement.actions;

export interface ApplicationsPageProps {
    createApplicationView: boolean;
    folder: Folder;
    onViewChange: () => void;
    setCreateApplicationView: (_: boolean) => void;
}

export const ApplicationsPageComponent = ({ createApplicationView, folder, onViewChange, setCreateApplicationView }: ApplicationsPageProps) => {
    const dispatch = useAppDispatch();
    const templates: Array<Template> = useAppSelector(getTemplates);

    useEffect(() => {
        dispatch(fetchTemplates({ parentId: folder.id }));
    }, []);

    return (
        <DotThemeProvider>
            <div className="applications-placeholder">
                <div className="applications">
                    <img alt="Applications" src={`static/@project.version@/include/applications-management/assets/applications.png`} width="300" />
                    <div className="applications-title">Applications</div>
                    <div className="applications-description">
                        Getting started with your applications. Create new applications in Argo CD or Digital.ai Deploy.
                        <div className="applications-buttons">
                            <DotButton data-testid="discover-btn" onClick={() => onViewChange()} type="outlined">
                                Discover applications
                            </DotButton>
                            <DotButton
                                className="applications-create-btn"
                                data-testid="create-btn"
                                onClick={() => setCreateApplicationView(true)}
                                type="primary"
                            >
                                Create application
                            </DotButton>
                        </div>
                    </div>
                    <CreateApplicationDrawer onClose={() => setCreateApplicationView(false)} open={createApplicationView} templates={templates} />
                </div>
            </div>
        </DotThemeProvider>
    );
};
