/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.jms.selector.filter;

import org.apache.qpid.jms.selector.filter.BinaryExpression;
import org.apache.qpid.jms.selector.filter.Expression;
import org.apache.qpid.jms.selector.filter.FilterException;
import org.apache.qpid.jms.selector.filter.Filterable;

public abstract class ArithmeticExpression
extends BinaryExpression {
    protected static final int INTEGER = 1;
    protected static final int LONG = 2;
    protected static final int DOUBLE = 3;

    public ArithmeticExpression(Expression left, Expression right) {
        super(left, right);
    }

    public static Expression createPlus(Expression left, Expression right) {
        return new ArithmeticExpression(left, right){

            @Override
            protected Object evaluate(Object lvalue, Object rvalue) {
                if (lvalue instanceof String) {
                    String text = (String)lvalue;
                    String answer = text + rvalue;
                    return answer;
                }
                return this.plus(this.asNumber(lvalue), this.asNumber(rvalue));
            }

            @Override
            public String getExpressionSymbol() {
                return "+";
            }
        };
    }

    public static Expression createMinus(Expression left, Expression right) {
        return new ArithmeticExpression(left, right){

            @Override
            protected Object evaluate(Object lvalue, Object rvalue) {
                return this.minus(this.asNumber(lvalue), this.asNumber(rvalue));
            }

            @Override
            public String getExpressionSymbol() {
                return "-";
            }
        };
    }

    public static Expression createMultiply(Expression left, Expression right) {
        return new ArithmeticExpression(left, right){

            @Override
            protected Object evaluate(Object lvalue, Object rvalue) {
                return this.multiply(this.asNumber(lvalue), this.asNumber(rvalue));
            }

            @Override
            public String getExpressionSymbol() {
                return "*";
            }
        };
    }

    public static Expression createDivide(Expression left, Expression right) {
        return new ArithmeticExpression(left, right){

            @Override
            protected Object evaluate(Object lvalue, Object rvalue) {
                return this.divide(this.asNumber(lvalue), this.asNumber(rvalue));
            }

            @Override
            public String getExpressionSymbol() {
                return "/";
            }
        };
    }

    public static Expression createMod(Expression left, Expression right) {
        return new ArithmeticExpression(left, right){

            @Override
            protected Object evaluate(Object lvalue, Object rvalue) {
                return this.mod(this.asNumber(lvalue), this.asNumber(rvalue));
            }

            @Override
            public String getExpressionSymbol() {
                return "%";
            }
        };
    }

    protected Number plus(Number left, Number right) {
        switch (this.numberType(left, right)) {
            case 1: {
                return left.intValue() + right.intValue();
            }
            case 2: {
                return left.longValue() + right.longValue();
            }
        }
        return left.doubleValue() + right.doubleValue();
    }

    protected Number minus(Number left, Number right) {
        switch (this.numberType(left, right)) {
            case 1: {
                return left.intValue() - right.intValue();
            }
            case 2: {
                return left.longValue() - right.longValue();
            }
        }
        return left.doubleValue() - right.doubleValue();
    }

    protected Number multiply(Number left, Number right) {
        switch (this.numberType(left, right)) {
            case 1: {
                return left.intValue() * right.intValue();
            }
            case 2: {
                return left.longValue() * right.longValue();
            }
        }
        return left.doubleValue() * right.doubleValue();
    }

    protected Number divide(Number left, Number right) {
        return left.doubleValue() / right.doubleValue();
    }

    protected Number mod(Number left, Number right) {
        return left.doubleValue() % right.doubleValue();
    }

    private int numberType(Number left, Number right) {
        if (this.isDouble(left) || this.isDouble(right)) {
            return 3;
        }
        if (left instanceof Long || right instanceof Long) {
            return 2;
        }
        return 1;
    }

    private boolean isDouble(Number n) {
        return n instanceof Float || n instanceof Double;
    }

    protected Number asNumber(Object value) {
        if (value instanceof Number) {
            return (Number)value;
        }
        throw new RuntimeException("Cannot convert value: " + value + " into a number");
    }

    @Override
    public Object evaluate(Filterable message) throws FilterException {
        Object lvalue = this.left.evaluate(message);
        if (lvalue == null) {
            return null;
        }
        Object rvalue = this.right.evaluate(message);
        if (rvalue == null) {
            return null;
        }
        return this.evaluate(lvalue, rvalue);
    }

    protected abstract Object evaluate(Object var1, Object var2);
}

