/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.ascode.service;

import com.xebialabs.ascode.exception.AsCodeException;
import com.xebialabs.ascode.exception.AsCodeException$;
import com.xebialabs.ascode.yaml.dto.AsCodeResponse;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.xlrelease.ascode.service.FolderAsCodeService;
import com.xebialabs.xlrelease.ascode.service.ImportResult;
import com.xebialabs.xlrelease.ascode.service.ImportResult$;
import com.xebialabs.xlrelease.ascode.service.PostCommitAction;
import com.xebialabs.xlrelease.ascode.service.ReferenceSolver;
import com.xebialabs.xlrelease.ascode.service.spec.CiSpecInterpreter;
import com.xebialabs.xlrelease.ascode.utils.FolderScope;
import com.xebialabs.xlrelease.ascode.utils.ImportContext;
import com.xebialabs.xlrelease.delivery.events.DeliveryCreatedFromAsCodeEvent;
import com.xebialabs.xlrelease.delivery.events.DeliveryUpdatedFromAsCodeEvent;
import com.xebialabs.xlrelease.delivery.repository.DeliveryRepository;
import com.xebialabs.xlrelease.delivery.service.DeliveryPatternService;
import com.xebialabs.xlrelease.delivery.util.DeliveryObjectFactory;
import com.xebialabs.xlrelease.domain.delivery.Condition;
import com.xebialabs.xlrelease.domain.delivery.Delivery;
import com.xebialabs.xlrelease.domain.delivery.DeliveryStatus;
import com.xebialabs.xlrelease.domain.delivery.Stage;
import com.xebialabs.xlrelease.domain.delivery.Transition;
import com.xebialabs.xlrelease.domain.events.XLReleaseEvent;
import com.xebialabs.xlrelease.events.XLReleaseEventBus;
import com.xebialabs.xlrelease.repository.Ids;
import com.xebialabs.xlrelease.service.CiIdService;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.Serializable;
import java.util.Date;
import org.slf4j.Marker;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@Service
@ScalaSignature(bytes="\u0006\u0005\u0005\u0015g\u0001B\t\u0013\u0001uA\u0001\u0002\f\u0001\u0003\u0002\u0003\u0006I!\f\u0005\ti\u0001\u0011\t\u0011)A\u0005k!A1\b\u0001B\u0001B\u0003%A\b\u0003\u0005A\u0001\t\u0005\t\u0015!\u0003B\u0011!1\u0005A!A!\u0002\u00139\u0005\u0002\u0003&\u0001\u0005\u0003\u0005\u000b\u0011B&\t\u000bE\u0003A\u0011\u0001*\t\u000f\u0001\u0004!\u0019!C\tS\"1\u0001\u000f\u0001Q\u0001\n)DQ!\u001d\u0001\u0005\u0002IDq!a\u0004\u0001\t\u0013\t\t\u0002C\u0004\u0002\u001e\u0001!I!a\b\t\u000f\u0005%\u0002\u0001\"\u0003\u0002,!9\u0011Q\u000b\u0001\u0005\u0002\u0005]\u0003\"CA3\u0001E\u0005I\u0011AA4\u0011\u001d\tY\b\u0001C\u0005\u0003{\u0012A\u0004R3mSZ,'/\u001f)biR,'O\\!t\u0007>$WmU3sm&\u001cWM\u0003\u0002\u0014)\u000591/\u001a:wS\u000e,'BA\u000b\u0017\u0003\u0019\t7oY8eK*\u0011q\u0003G\u0001\nq2\u0014X\r\\3bg\u0016T!!\u0007\u000e\u0002\u0013a,'-[1mC\n\u001c(\"A\u000e\u0002\u0007\r|Wn\u0001\u0001\u0014\u0007\u0001qB\u0005\u0005\u0002 E5\t\u0001EC\u0001\"\u0003\u0015\u00198-\u00197b\u0013\t\u0019\u0003E\u0001\u0004B]f\u0014VM\u001a\t\u0003K)j\u0011A\n\u0006\u0003O!\nQa\u001d7gi)T\u0011!K\u0001\tOJL'P\u001f7fI&\u00111F\n\u0002\b\u0019><w-\u001b8h\u0003Y!W\r\\5wKJL\b+\u0019;uKJt7+\u001a:wS\u000e,\u0007C\u0001\u00183\u001b\u0005y#BA\n1\u0015\t\td#\u0001\u0005eK2Lg/\u001a:z\u0013\t\u0019tF\u0001\fEK2Lg/\u001a:z!\u0006$H/\u001a:o'\u0016\u0014h/[2f\u0003I!W\r\\5wKJL(+\u001a9pg&$xN]=\u0011\u0005YJT\"A\u001c\u000b\u0005a\u0002\u0014A\u0003:fa>\u001c\u0018\u000e^8ss&\u0011!h\u000e\u0002\u0013\t\u0016d\u0017N^3ssJ+\u0007o\\:ji>\u0014\u00180A\bsK\u001a,'/\u001a8dKN{GN^3s!\tid(D\u0001\u0013\u0013\ty$CA\bSK\u001a,'/\u001a8dKN{GN^3s\u0003-\u0019\u0017.\u00133TKJ4\u0018nY3\u0011\u0005\t#U\"A\"\u000b\u0005M1\u0012BA#D\u0005-\u0019\u0015.\u00133TKJ4\u0018nY3\u0002'\u0019|G\u000eZ3s\u0003N\u001cu\u000eZ3TKJ4\u0018nY3\u0011\u0005uB\u0015BA%\u0013\u0005M1u\u000e\u001c3fe\u0006\u001b8i\u001c3f'\u0016\u0014h/[2f\u0003!)g/\u001a8u\u0005V\u001c\bC\u0001'P\u001b\u0005i%B\u0001(\u0017\u0003\u0019)g/\u001a8ug&\u0011\u0001+\u0014\u0002\u001212\u0013V\r\\3bg\u0016,e/\u001a8u\u0005V\u001c\u0018A\u0002\u001fj]&$h\bF\u0004T)V3v\u000bW-\u0011\u0005u\u0002\u0001\"\u0002\u0017\b\u0001\u0004i\u0003\"\u0002\u001b\b\u0001\u0004)\u0004\"B\u001e\b\u0001\u0004a\u0004\"\u0002!\b\u0001\u0004\t\u0005\"\u0002$\b\u0001\u00049\u0005\"\u0002&\b\u0001\u0004Y\u0005FA\u0004\\!\tav-D\u0001^\u0015\tqv,\u0001\u0006b]:|G/\u0019;j_:T!\u0001Y1\u0002\u000f\u0019\f7\r^8ss*\u0011!mY\u0001\u0006E\u0016\fgn\u001d\u0006\u0003I\u0016\fqb\u001d9sS:<gM]1nK^|'o\u001b\u0006\u0002M\u0006\u0019qN]4\n\u0005!l&!C!vi><\u0018N]3e+\u0005Q\u0007CA6o\u001b\u0005a'BA71\u0003\u0011)H/\u001b7\n\u0005=d'!\u0006#fY&4XM]=PE*,7\r\u001e$bGR|'/_\u0001\tM\u0006\u001cGo\u001c:zA\u00059\u0001O]8dKN\u001cHcA:w}B\u0011Q\b^\u0005\u0003kJ\u0011A\"S7q_J$(+Z:vYRDQa\u001e\u0006A\u0002a\fqaY8oi\u0016DH\u000f\u0005\u0002zy6\t!P\u0003\u0002|)\u0005)Q\u000f^5mg&\u0011QP\u001f\u0002\u000e\u00136\u0004xN\u001d;D_:$X\r\u001f;\t\r}T\u0001\u0019AA\u0001\u0003\u001d\u0001\u0018\r\u001e;fe:\u0004B!a\u0001\u0002\f5\u0011\u0011Q\u0001\u0006\u0004c\u0005\u001d!bAA\u0005-\u00051Am\\7bS:LA!!\u0004\u0002\u0006\tAA)\u001a7jm\u0016\u0014\u00180\u0001\u0003gS:$GCBA\n\u00033\tY\u0002E\u0003 \u0003+\t\t!C\u0002\u0002\u0018\u0001\u0012aa\u00149uS>t\u0007\"B<\f\u0001\u0004A\bBB@\f\u0001\u0004\t\t!\u0001\u0004va\u0012\fG/\u001a\u000b\t\u0003\u0003\t\t#a\t\u0002(!)q\u000f\u0004a\u0001q\"9\u0011Q\u0005\u0007A\u0002\u0005\u0005\u0011\u0001C3ySN$\u0018N\\4\t\r}d\u0001\u0019AA\u0001\u0003\u0019\u0019'/Z1uKRQ\u0011\u0011AA\u0017\u0003_\t\t$a\u0013\t\u000b]l\u0001\u0019\u0001=\t\r}l\u0001\u0019AA\u0001\u0011\u001d\t\u0019$\u0004a\u0001\u0003k\t!!\u001b3\u0011\t\u0005]\u0012Q\t\b\u0005\u0003s\t\t\u0005E\u0002\u0002<\u0001j!!!\u0010\u000b\u0007\u0005}B$\u0001\u0004=e>|GOP\u0005\u0004\u0003\u0007\u0002\u0013A\u0002)sK\u0012,g-\u0003\u0003\u0002H\u0005%#AB*ue&twMC\u0002\u0002D\u0001Bq!!\u0014\u000e\u0001\u0004\ty%A\btKR$UMZ1vYR\u001cF/Y4f!\ry\u0012\u0011K\u0005\u0004\u0003'\u0002#a\u0002\"p_2,\u0017M\\\u0001\re\u0016\u001cX\r\u001e)biR,'O\u001c\u000b\u0007\u00033\ny&!\u0019\u0011\u0007}\tY&C\u0002\u0002^\u0001\u0012A!\u00168ji\"1qP\u0004a\u0001\u0003\u0003A\u0011\"a\u0019\u000f!\u0003\u0005\r!a\u0014\u0002\u0017\u0019|'oY3OK^LEm]\u0001\u0017e\u0016\u001cX\r\u001e)biR,'O\u001c\u0013eK\u001a\fW\u000f\u001c;%eU\u0011\u0011\u0011\u000e\u0016\u0005\u0003\u001f\nYg\u000b\u0002\u0002nA!\u0011qNA<\u001b\t\t\tH\u0003\u0003\u0002t\u0005U\u0014!C;oG\",7m[3e\u0015\tq\u0006%\u0003\u0003\u0002z\u0005E$!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0006\u0011r-\u001a8fe\u0006$Xm\u0014:Va\u0012\fG/Z%e+\u0011\ty(a&\u0015\u0015\u0005\u0005\u0015\u0011VAW\u0003c\u000b)\f\u0006\u0003\u00026\u0005\r\u0005\"CAC!\u0005\u0005\t9AAD\u0003))g/\u001b3f]\u000e,G%\r\t\u0007\u0003\u0013\u000by)a%\u000e\u0005\u0005-%bAAGA\u00059!/\u001a4mK\u000e$\u0018\u0002BAI\u0003\u0017\u0013\u0001b\u00117bgN$\u0016m\u001a\t\u0005\u0003+\u000b9\n\u0004\u0001\u0005\u000f\u0005e\u0005C1\u0001\u0002\u001c\n\tA+\u0005\u0003\u0002\u001e\u0006\r\u0006cA\u0010\u0002 &\u0019\u0011\u0011\u0015\u0011\u0003\u000f9{G\u000f[5oOB\u0019q$!*\n\u0007\u0005\u001d\u0006EA\u0002B]fDq!a+\u0011\u0001\u0004\t)$\u0001\u0006fq&\u001cH/\u001b8h\u0013\u0012Dq!a,\u0011\u0001\u0004\t)$A\u0006pY\u0012\u0004\u0016M]3oi&#\u0007bBAZ!\u0001\u0007\u0011QG\u0001\f]\u0016<\b+\u0019:f]RLE\rC\u0004\u0002dA\u0001\r!a\u0014)\u0007\u0001\tI\f\u0005\u0003\u0002<\u0006\u0005WBAA_\u0015\r\tylY\u0001\u000bgR,'/Z8usB,\u0017\u0002BAb\u0003{\u0013qaU3sm&\u001cW\r")
public class DeliveryPatternAsCodeService
implements Logging {
    private final DeliveryPatternService deliveryPatternService;
    private final DeliveryRepository deliveryRepository;
    private final ReferenceSolver referenceSolver;
    private final FolderAsCodeService folderAsCodeService;
    private final XLReleaseEventBus eventBus;
    private final DeliveryObjectFactory factory;
    private transient Logger grizzled$slf4j$Logging$$_logger;
    private volatile transient boolean bitmap$trans$0;

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        DeliveryPatternAsCodeService deliveryPatternAsCodeService = this;
        synchronized (deliveryPatternAsCodeService) {
            if (!this.bitmap$trans$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        if (!this.bitmap$trans$0) {
            return this.grizzled$slf4j$Logging$$_logger$lzycompute();
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public DeliveryObjectFactory factory() {
        return this.factory;
    }

    public ImportResult process(ImportContext context, Delivery pattern) {
        CiSpecInterpreter.ProcessedCi<Delivery> processedCi;
        this.logger().debug((Function0 & Serializable)() -> "Processing Delivery Pattern: " + pattern.toString() + " with metadata " + context.metadata().toString());
        this.referenceSolver.resolveReferences((ConfigurationItem)pattern, context.references(), (String)context.scope().getFolderId().get());
        Option<Delivery> option = this.find(context, pattern);
        if (option instanceof Some) {
            Some some = (Some)option;
            Delivery existing = (Delivery)some.value();
            if (!existing.getFolderId().equals(context.scope().getFolderId().get())) {
                String newFolder = ((FolderScope)context.scope()).path();
                String oldFolder = this.folderAsCodeService.getFolderPath(existing.getFolderId());
                throw new AsCodeException("Can't create pattern " + pattern.getTitle() + " in folder " + newFolder + " because one already exists with that name in " + oldFolder, AsCodeException$.MODULE$.$lessinit$greater$default$2());
            }
            this.logger().debug((Function0 & Serializable)() -> "Updating Delivery Pattern: " + existing.toString());
            Delivery updated = this.update(context, existing, pattern);
            processedCi = new CiSpecInterpreter.ProcessedCi<Delivery>(updated, AsCodeResponse.EntityKinds$.MODULE$.ExtendedString(AsCodeResponse.EntityKinds$.MODULE$.CI()).ids().withUpdated(updated.getId()), (Seq<PostCommitAction>)new .colon.colon(() -> $this.eventBus.publish((XLReleaseEvent)new DeliveryUpdatedFromAsCodeEvent(updated, context.scmData())), (List)Nil$.MODULE$));
        } else if (None$.MODULE$.equals(option)) {
            this.logger().debug((Function0 & Serializable)() -> "Creating Delivery Pattern: " + pattern.toString());
            Delivery created = this.create(context, pattern, this.factory().deliveryId(), true);
            processedCi = new CiSpecInterpreter.ProcessedCi<Delivery>(created, AsCodeResponse.EntityKinds$.MODULE$.ExtendedString(AsCodeResponse.EntityKinds$.MODULE$.CI()).ids().withCreated(created.getId()), (Seq<PostCommitAction>)new .colon.colon(() -> $this.eventBus.publish((XLReleaseEvent)new DeliveryCreatedFromAsCodeEvent(created, context.scmData())), (List)Nil$.MODULE$));
        } else {
            throw new MatchError(option);
        }
        CiSpecInterpreter.ProcessedCi<Delivery> processed = processedCi;
        return new ImportResult((List<AsCodeResponse.ChangedIds>)new .colon.colon((Object)processed.changedIds(), (List)Nil$.MODULE$), processed.postCommitActions(), ImportResult$.MODULE$.apply$default$3(), ImportResult$.MODULE$.apply$default$4());
    }

    private Option<Delivery> find(ImportContext context, Delivery pattern) {
        return this.deliveryRepository.findPatternByTitle(pattern.getTitle());
    }

    private Delivery update(ImportContext context, Delivery existing, Delivery pattern) {
        this.deliveryRepository.delete(existing.getId());
        return this.create(context, pattern, existing.getId(), false);
    }

    private Delivery create(ImportContext context, Delivery pattern, String id, boolean setDefaultStage) {
        pattern.setId(id);
        pattern.setStatus(DeliveryStatus.TEMPLATE);
        pattern.setFolderId((String)context.scope().getFolderId().get());
        this.deliveryPatternService.validatePattern(pattern, false);
        this.resetPattern(pattern, this.resetPattern$default$2());
        if (pattern.getStages().isEmpty() && setDefaultStage) {
            Stage defaultStage = new Stage("New Stage");
            defaultStage.setId(this.factory().createUniqueId(pattern.getId(), ClassTag$.MODULE$.apply(Stage.class)));
            pattern.addStage(defaultStage);
        }
        this.deliveryPatternService.validateStagesAndTransitionsAndItems(pattern);
        this.deliveryRepository.create(pattern);
        return pattern;
    }

    public void resetPattern(Delivery pattern, boolean forceNewIds) {
        String oldDeliveryId;
        Date resetDate = new Date();
        String newDeliveryId = oldDeliveryId = pattern.getId();
        pattern.getStages().forEach(stage -> {
            String oldStageId = stage.getId();
            String newStageId = this.generateOrUpdateId(oldStageId, oldDeliveryId, newDeliveryId, forceNewIds, ClassTag$.MODULE$.apply(Stage.class));
            stage.setId(newStageId);
            Option$.MODULE$.apply((Object)stage.getTransition()).foreach((Function1 & Serializable)transition -> {
                DeliveryPatternAsCodeService.$anonfun$resetPattern$2(this, oldStageId, newStageId, forceNewIds, stage, transition);
                return BoxedUnit.UNIT;
            });
        });
        pattern.getTrackedItems().forEach(item -> {
            item.setId(this.factory().trackedItemId(newDeliveryId));
            item.setCreatedDate(resetDate);
            item.setModifiedDate(resetDate);
        });
    }

    public boolean resetPattern$default$2() {
        return false;
    }

    private <T> String generateOrUpdateId(String existingId, String oldParentId, String newParentId, boolean forceNewIds, ClassTag<T> evidence$1) {
        boolean idNotDefined;
        String typeName = Type.valueOf((Class)((ClassTag)Predef$.MODULE$.implicitly(evidence$1)).runtimeClass()).getName();
        boolean bl = idNotDefined = existingId == null || existingId.trim().isEmpty() || !Ids.getName((String)existingId).startsWith(typeName);
        if (forceNewIds || idNotDefined) {
            return this.factory().createUniqueId(newParentId, evidence$1);
        }
        return existingId.replace((CharSequence)Option$.MODULE$.apply((Object)oldParentId).getOrElse((Function0 & Serializable)() -> ""), (CharSequence)Option$.MODULE$.apply((Object)newParentId).getOrElse((Function0 & Serializable)() -> ""));
    }

    public static final /* synthetic */ void $anonfun$resetPattern$2(DeliveryPatternAsCodeService $this, String oldStageId$1, String newStageId$1, boolean forceNewIds$1, Stage stage$1, Transition transition) {
        String oldTransitionId = transition.getId();
        String newTransitionId = $this.generateOrUpdateId(transition.getId(), oldStageId$1, newStageId$1, forceNewIds$1, ClassTag$.MODULE$.apply(Transition.class));
        transition.setId(newTransitionId);
        transition.setStage(stage$1);
        transition.getAllConditions().forEach(condition -> condition.setId($this.generateOrUpdateId(condition.getId(), oldTransitionId, newTransitionId, forceNewIds$1, ClassTag$.MODULE$.apply(Condition.class))));
    }

    @Autowired
    public DeliveryPatternAsCodeService(DeliveryPatternService deliveryPatternService, DeliveryRepository deliveryRepository, ReferenceSolver referenceSolver, CiIdService ciIdService, FolderAsCodeService folderAsCodeService, XLReleaseEventBus eventBus) {
        this.deliveryPatternService = deliveryPatternService;
        this.deliveryRepository = deliveryRepository;
        this.referenceSolver = referenceSolver;
        this.folderAsCodeService = folderAsCodeService;
        this.eventBus = eventBus;
        Logging.$init$((Logging)this);
        this.factory = new DeliveryObjectFactory(ciIdService);
    }
}

