/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.api.v1;

import com.xebialabs.xlrelease.api.ApiService;
import com.xebialabs.xlrelease.api.v1.forms.ReleaseGroupFilters;
import com.xebialabs.xlrelease.api.v1.forms.ReleaseGroupOrderMode;
import com.xebialabs.xlrelease.api.v1.views.ReleaseGroupTimeline;
import com.xebialabs.xlrelease.domain.group.ReleaseGroup;
import java.util.List;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;

@Path(value="/api/v1/release-groups")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
public interface ReleaseGroupApi
extends ApiService {
    @Override
    default public String serviceName() {
        return "releaseGroupApi";
    }

    @GET
    @Path(value="/{groupId:.*ReleaseGroup[^/]*}")
    public ReleaseGroup getGroup(@PathParam(value="groupId") String var1);

    @DELETE
    @Path(value="/{groupId:.*ReleaseGroup[^/]*}")
    public void deleteGroup(@PathParam(value="groupId") String var1);

    @POST
    public ReleaseGroup createGroup(ReleaseGroup var1);

    @PUT
    @Path(value="/{groupId:.*ReleaseGroup[^/]*}")
    public ReleaseGroup updateGroup(@PathParam(value="groupId") String var1, ReleaseGroup var2);

    @GET
    @Path(value="/{groupId:.*ReleaseGroup[^/]*}/members")
    public List<String> getMembers(@PathParam(value="groupId") String var1);

    @POST
    @Path(value="/{groupId:.*ReleaseGroup[^/]*}/members")
    public void addMembersToGroup(@PathParam(value="groupId") String var1, List<String> var2);

    @DELETE
    @Path(value="/{groupId:.*ReleaseGroup[^/]*}/members")
    public void removeMembersFromGroup(@PathParam(value="groupId") String var1, List<String> var2);

    @POST
    @Path(value="search")
    public List<ReleaseGroup> searchGroups(ReleaseGroupFilters var1, @DefaultValue(value="0") @QueryParam(value="page") Long var2, @DefaultValue(value="100") @QueryParam(value="resultsPerPage") Long var3, @DefaultValue(value="RISK") @QueryParam(value="orderBy") ReleaseGroupOrderMode var4);

    @GET
    @Path(value="/{groupId:.*ReleaseGroup[^/]*}/timeline")
    public ReleaseGroupTimeline getReleaseGroupTimeline(@PathParam(value="groupId") String var1);
}

