/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.environments.repository.sql.persistence;

import com.xebialabs.deployit.exception.NotFoundException;
import com.xebialabs.xlrelease.db.sql.SqlBuilder;
import com.xebialabs.xlrelease.db.sql.transaction.IsTransactional;
import com.xebialabs.xlrelease.domain.environments.Environment;
import com.xebialabs.xlrelease.environments.repository.sql.persistence.EnvironmentLabelPersistence;
import com.xebialabs.xlrelease.environments.repository.sql.persistence.EnvironmentStagePersistence;
import com.xebialabs.xlrelease.environments.repository.sql.persistence.Mappers$;
import com.xebialabs.xlrelease.environments.repository.sql.persistence.builder.EnvironmentSqlBuilder$;
import com.xebialabs.xlrelease.environments.repository.sql.persistence.package$;
import com.xebialabs.xlrelease.environments.repository.sql.persistence.schema.EnvironmentSchema$;
import com.xebialabs.xlrelease.environments.repository.sql.persistence.schema.EnvironmentSchema$ENVIRONMENTS$;
import com.xebialabs.xlrelease.environments.repository.sql.persistence.schema.EnvironmentSchema$ENV_TO_LABEL$;
import com.xebialabs.xlrelease.repository.sql.persistence.CompressionSupport;
import com.xebialabs.xlrelease.repository.sql.persistence.PersistenceSupport;
import com.xebialabs.xlrelease.repository.sql.persistence.SecurablePersistence;
import com.xebialabs.xlrelease.repository.sql.persistence.Utils;
import com.xebialabs.xlrelease.repository.sql.persistence.Utils$;
import com.xebialabs.xlrelease.repository.sql.persistence.package;
import com.xebialabs.xlrelease.service.CiIdService;
import java.io.InputStream;
import java.io.Serializable;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.Collection;
import java.util.UUID;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.dao.DuplicateKeyException;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.PreparedStatementCallback;
import org.springframework.jdbc.core.ResultSetExtractor;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.stereotype.Repository;
import org.springframework.util.CollectionUtils;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.IterableOnceOps;
import scala.collection.Set;
import scala.collection.StringOps$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.collection.mutable.Buffer;
import scala.jdk.CollectionConverters$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;
import scala.util.Try;
import scala.util.Try$;

@Repository
@IsTransactional
@ScalaSignature(bytes="\u0006\u0005\t=e\u0001B\u0013'\u0001UB\u0001b\u0011\u0001\u0003\u0006\u0004%\u0019\u0001\u0012\u0005\t#\u0002\u0011\t\u0011)A\u0005\u000b\"A!\u000b\u0001BC\u0002\u0013\r1\u000b\u0003\u0005l\u0001\t\u0005\t\u0015!\u0003U\u0011!a\u0007A!b\u0001\n\u0007i\u0007\u0002\u0003;\u0001\u0005\u0003\u0005\u000b\u0011\u00028\t\u0011U\u0004!Q1A\u0005\u0002YD\u0001B\u001f\u0001\u0003\u0002\u0003\u0006Ia\u001e\u0005\tw\u0002\u0011)\u0019!C\u0001y\"I\u00111\u0001\u0001\u0003\u0002\u0003\u0006I! \u0005\u000b\u0003\u000b\u0001!Q1A\u0005\u0002\u0005\u001d\u0001BCA\b\u0001\t\u0005\t\u0015!\u0003\u0002\n!9\u0011\u0011\u0003\u0001\u0005\u0002\u0005M\u0001\"CA(\u0001\t\u0007I\u0011BA)\u0011!\t\u0019\u0007\u0001Q\u0001\n\u0005M\u0003\"CA3\u0001\t\u0007I\u0011BA4\u0011!\t9\b\u0001Q\u0001\n\u0005%\u0004bBA=\u0001\u0011\u0005\u00111\u0010\u0005\n\u0003S\u0003!\u0019!C\u0005\u0003#B\u0001\"a+\u0001A\u0003%\u00111\u000b\u0005\n\u0003[\u0003!\u0019!C\u0005\u0003#B\u0001\"a,\u0001A\u0003%\u00111\u000b\u0005\b\u0003c\u0003A\u0011AAZ\u0011\u001d\ti\f\u0001C\u0001\u0003\u007fCq!a9\u0001\t\u0003\t)\u000fC\u0004\u0002r\u0002!\t!a=\t\u000f\u0005e\b\u0001\"\u0001\u0002|\"9!Q\u0002\u0001\u0005\u0002\t=\u0001\"\u0003B\u000b\u0001\t\u0007I\u0011BA)\u0011!\u00119\u0002\u0001Q\u0001\n\u0005M\u0003b\u0002B\r\u0001\u0011\u0005!1\u0004\u0005\b\u0005W\u0001A\u0011\u0002B\u0017\u0011\u001d\u00119\u0004\u0001C\u0005\u0005sAqA!\u0015\u0001\t\u0013\u0011\u0019\u0006C\u0004\u0003Z\u0001!\tAa\u0017\t\u000f\t\u001d\u0004\u0001\"\u0003\u0003j\t1RI\u001c<je>tW.\u001a8u!\u0016\u00148/[:uK:\u001cWM\u0003\u0002(Q\u0005Y\u0001/\u001a:tSN$XM\\2f\u0015\tI#&A\u0002tc2T!a\u000b\u0017\u0002\u0015I,\u0007o\\:ji>\u0014\u0018P\u0003\u0002.]\u0005aQM\u001c<je>tW.\u001a8ug*\u0011q\u0006M\u0001\nq2\u0014X\r\\3bg\u0016T!!\r\u001a\u0002\u0013a,'-[1mC\n\u001c(\"A\u001a\u0002\u0007\r|Wn\u0001\u0001\u0014\u0007\u00011D\b\u0005\u00028u5\t\u0001HC\u0001:\u0003\u0015\u00198-\u00197b\u0013\tY\u0004H\u0001\u0004B]f\u0014VM\u001a\t\u0003{\u0005k\u0011A\u0010\u0006\u0003O}R!!\u000b!\u000b\u0005-r\u0013B\u0001\"?\u0005I\u0001VM]:jgR,gnY3TkB\u0004xN\u001d;\u0002\u0019)$'m\u0019+f[Bd\u0017\r^3\u0016\u0003\u0015\u0003\"AR(\u000e\u0003\u001dS!\u0001S%\u0002\t\r|'/\u001a\u0006\u0003\u0015.\u000bAA\u001b3cG*\u0011A*T\u0001\u0010gB\u0014\u0018N\\4ge\u0006lWm^8sW*\ta*A\u0002pe\u001eL!\u0001U$\u0003\u0019)#'m\u0019+f[Bd\u0017\r^3\u0002\u001b)$'m\u0019+f[Bd\u0017\r^3!\u0003\u001d!\u0017.\u00197fGR,\u0012\u0001\u0016\t\u0003+\"t!AV3\u000f\u0005]\u001bgB\u0001-b\u001d\tI\u0006M\u0004\u0002[?:\u00111LX\u0007\u00029*\u0011Q\fN\u0001\u0007yI|w\u000e\u001e \n\u0003MJ!!\r\u001a\n\u0005=\u0002\u0014B\u00012/\u0003\t!'-\u0003\u0002*I*\u0011!ML\u0005\u0003M\u001e\f!bU9m\u0005VLG\u000eZ3s\u0015\tIC-\u0003\u0002jU\n9A)[1mK\u000e$(B\u00014h\u0003!!\u0017.\u00197fGR\u0004\u0013aC2j\u0013\u0012\u001cVM\u001d<jG\u0016,\u0012A\u001c\t\u0003_Jl\u0011\u0001\u001d\u0006\u0003c:\nqa]3sm&\u001cW-\u0003\u0002ta\nY1)[%e'\u0016\u0014h/[2f\u00031\u0019\u0017.\u00133TKJ4\u0018nY3!\u0003Q\u0019XmY;sC\ndW\rU3sg&\u001cH/\u001a8dKV\tq\u000f\u0005\u0002>q&\u0011\u0011P\u0010\u0002\u0015'\u0016\u001cWO]1cY\u0016\u0004VM]:jgR,gnY3\u0002+M,7-\u001e:bE2,\u0007+\u001a:tSN$XM\\2fA\u0005YRM\u001c<je>tW.\u001a8u'R\fw-\u001a)feNL7\u000f^3oG\u0016,\u0012! \t\u0003}~l\u0011AJ\u0005\u0004\u0003\u00031#aG#om&\u0014xN\\7f]R\u001cF/Y4f!\u0016\u00148/[:uK:\u001cW-\u0001\u000ff]ZL'o\u001c8nK:$8\u000b^1hKB+'o]5ti\u0016t7-\u001a\u0011\u00027\u0015tg/\u001b:p]6,g\u000e\u001e'bE\u0016d\u0007+\u001a:tSN$XM\\2f+\t\tI\u0001E\u0002\u007f\u0003\u0017I1!!\u0004'\u0005m)eN^5s_:lWM\u001c;MC\n,G\u000eU3sg&\u001cH/\u001a8dK\u0006aRM\u001c<je>tW.\u001a8u\u0019\u0006\u0014W\r\u001c)feNL7\u000f^3oG\u0016\u0004\u0013A\u0002\u001fj]&$h\b\u0006\u0002\u0002\u0016Qq\u0011qCA\r\u0003o\ty$!\u0011\u0002D\u0005\u0015\u0003C\u0001@\u0001\u0011\u0015\u0019U\u0002q\u0001FQ!\tI\"!\b\u00022\u0005M\u0002\u0003BA\u0010\u0003[i!!!\t\u000b\t\u0005\r\u0012QE\u0001\u000bC:tw\u000e^1uS>t'\u0002BA\u0014\u0003S\tqAZ1di>\u0014\u0018PC\u0002\u0002,-\u000bQAY3b]NLA!a\f\u0002\"\tI\u0011+^1mS\u001aLWM]\u0001\u0006m\u0006dW/Z\u0011\u0003\u0003k\t\u0011\u0004\u001f7s%\u0016\u0004xn]5u_JL(\n\u001a2d)\u0016l\u0007\u000f\\1uK\")!+\u0004a\u0002)\"B\u0011qGA\u000f\u0003c\tY$\t\u0002\u0002>\u00059\u0002\u0010\u001c:SKB|7/\u001b;pef\u001c\u0016\u000f\u001c#jC2,7\r\u001e\u0005\u0006Y6\u0001\u001dA\u001c\u0005\u0006k6\u0001\ra\u001e\u0005\u0006w6\u0001\r! \u0005\b\u0003\u000bi\u0001\u0019AA\u0005Q\ri\u0011\u0011\n\t\u0005\u0003?\tY%\u0003\u0003\u0002N\u0005\u0005\"!C!vi><\u0018N]3e\u0003a\u0019F+\u0014+`\u0013:\u001bVI\u0015+`\u000b:3\u0016JU(O\u001b\u0016sEkU\u000b\u0003\u0003'\u0002B!!\u0016\u0002^9!\u0011qKA-!\tY\u0006(C\u0002\u0002\\a\na\u0001\u0015:fI\u00164\u0017\u0002BA0\u0003C\u0012aa\u0015;sS:<'bAA.q\u0005I2\u000bV'U?&s5+\u0012*U?\u0016se+\u0013*P\u001d6+e\nV*!\u0003}\u0019F+\u0014+`\u000bbK5\u000bV*`\u0005f{F+\u0013+M\u000b~KuIT(S\u000b\u000e\u000b5+R\u000b\u0003\u0003S\u0002B!a\u001b\u0002v5\u0011\u0011Q\u000e\u0006\u0005\u0003_\n\t(\u0001\u0003mC:<'BAA:\u0003\u0011Q\u0017M^1\n\t\u0005}\u0013QN\u0001!'RkEkX#Y\u0013N#6k\u0018\"Z?RKE\u000bT#`\u0013\u001esuJU#D\u0003N+\u0005%\u0001\u0004j]N,'\u000f\u001e\u000b\u0005\u0003{\n9\n\u0005\u0003\u0002\u0000\u0005Ee\u0002BAA\u0003\u001bsA!a!\u0002\f:!\u0011QQAE\u001d\rA\u0016qQ\u0005\u0003W9J!!\u000b!\n\u0005\u001dz\u0014bAAH}\u0005!1)[%e\u0013\u0011\t\u0019*!&\u0003\t\rK\u0017\n\u001a\u0006\u0004\u0003\u001fs\u0004bBAM%\u0001\u0007\u00111T\u0001\fK:4\u0018N]8o[\u0016tG\u000f\u0005\u0003\u0002\u001e\u0006\u0015VBAAP\u0015\ri\u0013\u0011\u0015\u0006\u0004\u0003Gs\u0013A\u00023p[\u0006Lg.\u0003\u0003\u0002(\u0006}%aC#om&\u0014xN\\7f]R\f\u0001d\u0015+N)~+\u0006\u000bR!U\u000b~+eJV%S\u001f:kUI\u0014+T\u0003e\u0019F+\u0014+`+B#\u0015\tV#`\u000b:3\u0016JU(O\u001b\u0016sEk\u0015\u0011\u0002EM#V\nV0F1&\u001bFkU0B\u001d>#\u0006*\u0012*`\u000b:3vlV%U\u0011~#\u0016\n\u0016'F\u0003\r\u001aF+\u0014+`\u000bbK5\u000bV*`\u0003:{E\u000bS#S?\u0016sekX,J)\"{F+\u0013+M\u000b\u0002\na!\u001e9eCR,G\u0003BA[\u0003w\u00032aNA\\\u0013\r\tI\f\u000f\u0002\b\u0005>|G.Z1o\u0011\u001d\tIj\u0006a\u0001\u00037\u000baBZ5oI&#7OQ=Rk\u0016\u0014\u0018\u0010\u0006\u0003\u0002B\u0006M\u0007CBAb\u0003\u001b\fiH\u0004\u0003\u0002F\u0006%gbA.\u0002H&\t\u0011(C\u0002\u0002Lb\nq\u0001]1dW\u0006<W-\u0003\u0003\u0002P\u0006E'aA*fc*\u0019\u00111\u001a\u001d\t\u000f\u0005U\u0007\u00041\u0001\u0002X\u0006\t2/\u001d7XSRD\u0007+\u0019:b[\u0016$XM]:\u0011\t\u0005e\u0017Q\u001c\b\u0004-\u0006m\u0017bAAfO&!\u0011q\\Aq\u0005E\u0019\u0016\u000f\\,ji\"\u0004\u0016M]1nKR,'o\u001d\u0006\u0004\u0003\u0017<\u0017\u0001\u00034j]\u0012\u0014\u00150\u00133\u0015\t\u0005\u001d\u0018Q\u001e\t\u0006o\u0005%\u00181T\u0005\u0004\u0003WD$AB(qi&|g\u000eC\u0004\u0002pf\u0001\r!! \u0002\u001b\u0015tg/\u001b:p]6,g\u000e^%e\u0003-1\u0017N\u001c3CsRKG\u000f\\3\u0015\t\u0005\u001d\u0018Q\u001f\u0005\b\u0003oT\u0002\u0019AA?\u0003A)gN^5s_:lWM\u001c;USRdW-A\u0006gS:$W+\u001b3Cs&#G\u0003BA\u007f\u0005\u0017\u0001RaNAu\u0003\u007f\u0004BA!\u0001\u0003\u00069!\u0011\u0011\u0011B\u0002\u0013\r\tYMP\u0005\u0005\u0005\u000f\u0011IAA\u0003DSVKGMC\u0002\u0002LzBq!a<\u001c\u0001\u0004\ti(\u0001\u0004tK\u0006\u00148\r\u001b\u000b\u0005\u0005#\u0011\u0019\u0002\u0005\u0004\u0002D\u00065\u00171\u0014\u0005\b\u0003+d\u0002\u0019AAl\u0003y\u0019F+\u0014+`\t\u0016cU\tV#`\u000b:3\u0016JU(O\u001b\u0016sEkU0C3~KE)A\u0010T)6#v\fR#M\u000bR+u,\u0012(W\u0013J{e*T#O)N{&)W0J\t\u0002\na\u0001Z3mKR,G\u0003\u0002B\u000f\u0005S\u0001bAa\b\u0003&\u0005UVB\u0001B\u0011\u0015\r\u0011\u0019\u0003O\u0001\u0005kRLG.\u0003\u0003\u0003(\t\u0005\"a\u0001+ss\"9\u0011q^\u0010A\u0002\u0005u\u0014\u0001D4fi2\u000b'-\u001a7VS\u0012\u001cH\u0003\u0002B\u0018\u0005k\u0001\u0002\"!\u0016\u00032\u0005u\u0014q`\u0005\u0005\u0005g\t\tGA\u0002NCBDq!!'!\u0001\u0004\tY*\u0001\u000ej]N,'\u000f^#omR{G*\u00192fYJ+g-\u001a:f]\u000e,7\u000f\u0006\u0004\u0003<\t\r#q\t\t\u0007\u0003\u0007\fiM!\u0010\u0011\u0007]\u0012y$C\u0002\u0003Ba\u00121!\u00138u\u0011\u001d\u0011)%\ta\u0001\u0003\u007f\fa\"\u001a8wSJ|g.\\3oiVKG\rC\u0004\u0003J\u0005\u0002\rAa\u0013\u0002\u00131\f'-\u001a7VS\u0012\u001c\bCBA+\u0005\u001b\ny0\u0003\u0003\u0003P\u0005\u0005$aA*fi\u0006QR\u000f\u001d3bi\u0016,eN\u001e+p\u0019\u0006\u0014W\r\u001c*fM\u0016\u0014XM\\2fgR1!1\bB+\u0005/Bq!!'#\u0001\u0004\tY\nC\u0004\u0003F\t\u0002\r!a@\u0002\u0019\u001d,G/V5eg\nK\u0018\nZ:\u0015\t\t=\"Q\f\u0005\b\u0005?\u001a\u0003\u0019\u0001B1\u00039)gN^5s_:lWM\u001c;JIN\u0004b!a1\u0003d\u0005u\u0014\u0002\u0002B3\u0003#\u0014\u0001\"\u0013;fe\u0006\u0014G.Z\u0001\u0019g\u0006t\u0017\u000e^5{K\u0016sg/\u001b:p]6,g\u000e^%oaV$H\u0003\u0002B6\u0005c\u00022a\u000eB7\u0013\r\u0011y\u0007\u000f\u0002\u0005+:LG\u000fC\u0004\u0002\u001a\u0012\u0002\r!a')\u0007\u0001\u0011)\b\u0005\u0003\u0003x\tuTB\u0001B=\u0015\r\u0011YhS\u0001\u000bgR,'/Z8usB,\u0017\u0002\u0002B@\u0005s\u0012!BU3q_NLGo\u001c:zQ\r\u0001!1\u0011\t\u0005\u0005\u000b\u0013Y)\u0004\u0002\u0003\b*\u0019!\u0011R4\u0002\u0017Q\u0014\u0018M\\:bGRLwN\\\u0005\u0005\u0005\u001b\u00139IA\bJgR\u0013\u0018M\\:bGRLwN\\1m\u0001")
public class EnvironmentPersistence
implements PersistenceSupport {
    private final JdbcTemplate jdbcTemplate;
    private final SqlBuilder.Dialect dialect;
    private final CiIdService ciIdService;
    private final SecurablePersistence securablePersistence;
    private final EnvironmentStagePersistence environmentStagePersistence;
    private final EnvironmentLabelPersistence environmentLabelPersistence;
    private final String STMT_INSERT_ENVIRONMENTS;
    private final String STMT_EXISTS_BY_TITLE_IGNORECASE;
    private final String STMT_UPDATE_ENVIRONMENTS;
    private final String STMT_EXISTS_ANOTHER_ENV_WITH_TITLE;
    private final String STMT_DELETE_ENVIRONMENTS_BY_ID;
    private NamedParameterJdbcTemplate namedTemplate;
    private volatile boolean bitmap$0;

    public MapSqlParameterSource paramMap2MapSqlParameterSource(Map<String, Object> params) {
        return PersistenceSupport.paramMap2MapSqlParameterSource$((PersistenceSupport)this, params);
    }

    public Integer sqlInsert(String pkColumn, String sqlStatement, Map<String, Object> params) {
        return PersistenceSupport.sqlInsert$((PersistenceSupport)this, (String)pkColumn, (String)sqlStatement, params);
    }

    public <R> R sqlInsert(String pkColumn, String sqlStatement, Map<String, Object> params, Function1<Integer, R> mapper) {
        return (R)PersistenceSupport.sqlInsert$((PersistenceSupport)this, (String)pkColumn, (String)sqlStatement, params, mapper);
    }

    public <R> R sqlInsert(String pkColumn, String sqlStatement, MapSqlParameterSource params, Function1<Integer, R> mapper) {
        return (R)PersistenceSupport.sqlInsert$((PersistenceSupport)this, (String)pkColumn, (String)sqlStatement, (MapSqlParameterSource)params, mapper);
    }

    public void sqlInsert(String sqlStatement, MapSqlParameterSource params) {
        PersistenceSupport.sqlInsert$((PersistenceSupport)this, (String)sqlStatement, (MapSqlParameterSource)params);
    }

    public <R> R sqlExec(String sqlStatement, Map<String, Object> params, PreparedStatementCallback<R> callback) {
        return (R)PersistenceSupport.sqlExec$((PersistenceSupport)this, (String)sqlStatement, params, callback);
    }

    public <R> R sqlExecWithContent(String sqlStatement, Map<String, Object> params, Tuple2<String, String> contentParam, Function1<Object, R> mapper) {
        return (R)PersistenceSupport.sqlExecWithContent$((PersistenceSupport)this, (String)sqlStatement, params, contentParam, mapper);
    }

    public <R> R sqlInsertWithContent(String pkColumn, String sqlStatement, Map<String, Object> params, Tuple2<String, String> contentParam, Function1<Integer, R> mapper) {
        return (R)PersistenceSupport.sqlInsertWithContent$((PersistenceSupport)this, (String)pkColumn, (String)sqlStatement, params, contentParam, mapper);
    }

    public <R> R sqlUpdate(String sqlStatement, MapSqlParameterSource params, Function1<Object, R> mapper) {
        return (R)PersistenceSupport.sqlUpdate$((PersistenceSupport)this, (String)sqlStatement, (MapSqlParameterSource)params, mapper);
    }

    public <R> R sqlSet(String sqlStatement, Function1<PreparedStatement, PreparedStatement> setup, Function1<Object, R> callback) {
        return (R)PersistenceSupport.sqlSet$((PersistenceSupport)this, (String)sqlStatement, setup, callback);
    }

    public Function1<Object, BoxedUnit> checkCiUpdated(String entityId) {
        return PersistenceSupport.checkCiUpdated$((PersistenceSupport)this, (String)entityId);
    }

    public Function1<Object, UUID> checkCiUpdated(Integer uid, Option<UUID> token, UUID freshToken) {
        return PersistenceSupport.checkCiUpdated$((PersistenceSupport)this, (Integer)uid, token, (UUID)freshToken);
    }

    public Function1<Object, BoxedUnit> checkCiDeleted(Integer uid) {
        return PersistenceSupport.checkCiDeleted$((PersistenceSupport)this, (Integer)uid);
    }

    public <R> Buffer<R> sqlQuery(String sqlStatement, Map<String, Object> params, RowMapper<R> mapper) {
        return PersistenceSupport.sqlQuery$((PersistenceSupport)this, (String)sqlStatement, params, mapper);
    }

    public <R> Buffer<R> sqlQuery(String sqlStatement, Map<String, Object> params, Function1<ResultSet, R> mapper) {
        return PersistenceSupport.sqlQuery$((PersistenceSupport)this, (String)sqlStatement, params, mapper);
    }

    public <R> R sqlQuery(String sqlStatement, Map<String, Object> params, ResultSetExtractor<R> extractor) {
        return (R)PersistenceSupport.sqlQuery$((PersistenceSupport)this, (String)sqlStatement, params, extractor);
    }

    public Seq<Object> sqlBatch(String sqlStatement, scala.collection.immutable.Set<Map<String, Object>> parameters) {
        return PersistenceSupport.sqlBatch$((PersistenceSupport)this, (String)sqlStatement, parameters);
    }

    public Seq<Object> sqlBatchWithContent(String sqlStatement, Seq<Tuple2<Map<String, Object>, Tuple2<String, String>>> params) {
        return PersistenceSupport.sqlBatchWithContent$((PersistenceSupport)this, (String)sqlStatement, params);
    }

    public String pkName(String pkColumn) {
        return PersistenceSupport.pkName$((PersistenceSupport)this, (String)pkColumn);
    }

    public MapSqlParameterSource paramSource(Seq<Tuple2<String, Object>> pairs) {
        return PersistenceSupport.paramSource$((PersistenceSupport)this, pairs);
    }

    public byte[] compress(String text) {
        return CompressionSupport.compress$((CompressionSupport)this, (String)text);
    }

    public String decompress(InputStream inputStream) {
        return CompressionSupport.decompress$((CompressionSupport)this, (InputStream)inputStream);
    }

    public byte[] compress(byte[] byteArray) {
        return CompressionSupport.compress$((CompressionSupport)this, (byte[])byteArray);
    }

    public byte[] decompress(byte[] byteArray) {
        return CompressionSupport.decompress$((CompressionSupport)this, (byte[])byteArray);
    }

    public <A> Option<A> findOptional(Function1<JdbcTemplate, A> body, JdbcTemplate jdbcTemplate) {
        return Utils.findOptional$((Utils)this, body, (JdbcTemplate)jdbcTemplate);
    }

    public <A> Option<A> findOne(Function0<Buffer<A>> body) {
        return Utils.findOne$((Utils)this, body);
    }

    public <A> Seq<A> findMany(Function0<Buffer<A>> body) {
        return Utils.findMany$((Utils)this, body);
    }

    private NamedParameterJdbcTemplate namedTemplate$lzycompute() {
        EnvironmentPersistence environmentPersistence = this;
        synchronized (environmentPersistence) {
            if (!this.bitmap$0) {
                this.namedTemplate = PersistenceSupport.namedTemplate$((PersistenceSupport)this);
                this.bitmap$0 = true;
            }
        }
        return this.namedTemplate;
    }

    public NamedParameterJdbcTemplate namedTemplate() {
        if (!this.bitmap$0) {
            return this.namedTemplate$lzycompute();
        }
        return this.namedTemplate;
    }

    public JdbcTemplate jdbcTemplate() {
        return this.jdbcTemplate;
    }

    public SqlBuilder.Dialect dialect() {
        return this.dialect;
    }

    public CiIdService ciIdService() {
        return this.ciIdService;
    }

    public SecurablePersistence securablePersistence() {
        return this.securablePersistence;
    }

    public EnvironmentStagePersistence environmentStagePersistence() {
        return this.environmentStagePersistence;
    }

    public EnvironmentLabelPersistence environmentLabelPersistence() {
        return this.environmentLabelPersistence;
    }

    private String STMT_INSERT_ENVIRONMENTS() {
        return this.STMT_INSERT_ENVIRONMENTS;
    }

    private String STMT_EXISTS_BY_TITLE_IGNORECASE() {
        return this.STMT_EXISTS_BY_TITLE_IGNORECASE;
    }

    public String insert(Environment environment) {
        this.sanitizeEnvironmentInput(environment);
        Integer stageUid = (Integer)this.environmentStagePersistence().findUidById(environment.getStage().getId()).getOrElse((Function0 & Serializable)() -> {
            throw new NotFoundException("Environment stage [" + environment.getStage().getId() + "] not found", new Object[0]);
        });
        boolean exists = BoxesRunTime.unboxToBoolean((Object)this.sqlQuery(this.STMT_EXISTS_BY_TITLE_IGNORECASE(), (Map<String, Object>)Utils$.MODULE$.params((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)EnvironmentSchema$ENVIRONMENTS$.MODULE$.TITLE()), (Object)environment.getTitle())})), (Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)EnvironmentPersistence.$anonfun$insert$2(x$1))).head());
        if (exists) {
            throw new IllegalArgumentException("Environment with title '" + environment.getTitle() + "' already exists");
        }
        Map<String, Integer> labelIdsToUids = this.getLabelUids(environment);
        Integer ciUid = this.securablePersistence().insert();
        String envId = package$.MODULE$.createPersistedId(ClassTag$.MODULE$.apply(Environment.class), this.ciIdService());
        String displayedEnvId = package$.MODULE$.toDisplayId(envId);
        try {
            this.sqlExec(this.STMT_INSERT_ENVIRONMENTS(), (Map<String, Object>)Utils$.MODULE$.params((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)EnvironmentSchema$ENVIRONMENTS$.MODULE$.CI_UID()), (Object)ciUid), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)EnvironmentSchema$ENVIRONMENTS$.MODULE$.ID()), (Object)envId), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)EnvironmentSchema$ENVIRONMENTS$.MODULE$.DESCRIPTION()), (Object)environment.getDescription()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)EnvironmentSchema$ENVIRONMENTS$.MODULE$.TITLE()), (Object)environment.getTitle()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)EnvironmentSchema$ENVIRONMENTS$.MODULE$.ENV_STAGE_UID()), (Object)stageUid)})), x$2 -> BoxesRunTime.boxToBoolean((boolean)x$2.execute()));
        }
        catch (DuplicateKeyException ex) {
            throw new IllegalArgumentException("Environment with ID '" + displayedEnvId + "' already exists", ex);
        }
        this.insertEnvToLabelReferences(ciUid, (scala.collection.immutable.Set<Integer>)labelIdsToUids.valuesIterator().toSet());
        return displayedEnvId;
    }

    private String STMT_UPDATE_ENVIRONMENTS() {
        return this.STMT_UPDATE_ENVIRONMENTS;
    }

    private String STMT_EXISTS_ANOTHER_ENV_WITH_TITLE() {
        return this.STMT_EXISTS_ANOTHER_ENV_WITH_TITLE;
    }

    public boolean update(Environment environment) {
        Integer environmentUid = (Integer)this.findUidById(environment.getId()).getOrElse((Function0 & Serializable)() -> {
            throw new NotFoundException("Environment [" + environment.getId() + "] not found", new Object[0]);
        });
        Integer stageUid = (Integer)this.environmentStagePersistence().findUidById(environment.getStage().getId()).getOrElse((Function0 & Serializable)() -> {
            throw new NotFoundException("Environment stage [" + environment.getStage().getId() + "] not found", new Object[0]);
        });
        this.sanitizeEnvironmentInput(environment);
        boolean existsAnotherWithSameTitle = BoxesRunTime.unboxToBoolean((Object)this.sqlQuery(this.STMT_EXISTS_ANOTHER_ENV_WITH_TITLE(), (Map<String, Object>)Utils$.MODULE$.params((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)EnvironmentSchema$ENVIRONMENTS$.MODULE$.TITLE()), (Object)environment.getTitle()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)EnvironmentSchema$ENVIRONMENTS$.MODULE$.CI_UID()), (Object)environmentUid)})), (Function1 & Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)EnvironmentPersistence.$anonfun$update$3(x$3))).head());
        if (existsAnotherWithSameTitle) {
            throw new IllegalArgumentException("Environment with title '" + environment.getTitle() + "' already exists");
        }
        this.updateEnvToLabelReferences(environment, environmentUid);
        return BoxesRunTime.unboxToBoolean(this.sqlUpdate(this.STMT_UPDATE_ENVIRONMENTS(), this.paramMap2MapSqlParameterSource((Map<String, Object>)Utils$.MODULE$.params((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)EnvironmentSchema$ENVIRONMENTS$.MODULE$.DESCRIPTION()), (Object)environment.getDescription()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)EnvironmentSchema$ENVIRONMENTS$.MODULE$.TITLE()), (Object)environment.getTitle()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)EnvironmentSchema$ENVIRONMENTS$.MODULE$.CI_UID()), (Object)environmentUid), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)EnvironmentSchema$ENVIRONMENTS$.MODULE$.ENV_STAGE_UID()), (Object)stageUid)}))), (Function1)(JFunction1.mcZI.sp & Serializable)x$4 -> x$4 == 1));
    }

    public Seq<String> findIdsByQuery(Tuple2<String, Seq<Object>> sqlWithParameters) {
        Tuple2<String, Seq<Object>> tuple2 = sqlWithParameters;
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        String sql = (String)tuple2._1();
        Seq params = (Seq)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)sql, (Object)params);
        String sql2 = (String)tuple22._1();
        Seq params2 = (Seq)tuple22._2();
        return CollectionConverters$.MODULE$.ListHasAsScala(this.jdbcTemplate().queryForList(sql2, (Object[])params2.toArray(ClassTag$.MODULE$.AnyRef()), String.class)).asScala().toSeq();
    }

    public Option<Environment> findById(String environmentId) {
        Tuple2<String, Seq<Object>> tuple2 = EnvironmentSqlBuilder$.MODULE$.apply(EnvironmentSqlBuilder$.MODULE$.apply$default$1(), this.dialect()).select().withEnvironmentId(package$.MODULE$.toPersistedId(environmentId)).build();
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        String sql = (String)tuple2._1();
        Seq params = (Seq)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)sql, (Object)params);
        String sql2 = (String)tuple22._1();
        Seq params2 = (Seq)tuple22._2();
        return (Option)this.jdbcTemplate().query(sql2, (Object[])params2.toArray(ClassTag$.MODULE$.AnyRef()), Mappers$.MODULE$.environmentResultSetExtractor(Mappers$.MODULE$.environmentResultSetExtractor$default$1(), Mappers$.MODULE$.environmentResultSetExtractor$default$2()));
    }

    public Option<Environment> findByTitle(String environmentTitle) {
        Tuple2<String, Seq<Object>> tuple2 = EnvironmentSqlBuilder$.MODULE$.apply(EnvironmentSqlBuilder$.MODULE$.apply$default$1(), this.dialect()).select().withEnvironmentTitle(environmentTitle).build();
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        String sql = (String)tuple2._1();
        Seq params = (Seq)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)sql, (Object)params);
        String sql2 = (String)tuple22._1();
        Seq params2 = (Seq)tuple22._2();
        return (Option)this.jdbcTemplate().query(sql2, (Object[])params2.toArray(ClassTag$.MODULE$.AnyRef()), Mappers$.MODULE$.environmentResultSetExtractor(Mappers$.MODULE$.environmentResultSetExtractor$default$1(), Mappers$.MODULE$.environmentResultSetExtractor$default$2()));
    }

    public Option<Integer> findUidById(String environmentId) {
        String stmt = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("|SELECT " + EnvironmentSchema$ENVIRONMENTS$.MODULE$.CI_UID() + "\n          |FROM " + EnvironmentSchema$ENVIRONMENTS$.MODULE$.TABLE() + "\n          |WHERE " + EnvironmentSchema$ENVIRONMENTS$.MODULE$.ID() + " = :environmentId"));
        return this.sqlQuery(stmt, (Map<String, Object>)Utils$.MODULE$.params((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"environmentId"), (Object)package$.MODULE$.toPersistedId(environmentId))})), (Function1 & Serializable)rs -> package.CiUid$.MODULE$.apply(rs.getInt(EnvironmentSchema$ENVIRONMENTS$.MODULE$.CI_UID()))).headOption();
    }

    public Seq<Environment> search(Tuple2<String, Seq<Object>> sqlWithParameters) {
        Tuple2<String, Seq<Object>> tuple2 = sqlWithParameters;
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        String sql = (String)tuple2._1();
        Seq params = (Seq)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)sql, (Object)params);
        String sql2 = (String)tuple22._1();
        Seq params2 = (Seq)tuple22._2();
        return (Seq)this.jdbcTemplate().query(sql2, (Object[])params2.toArray(ClassTag$.MODULE$.AnyRef()), Mappers$.MODULE$.environmentSearchResultSetExtractor());
    }

    private String STMT_DELETE_ENVIRONMENTS_BY_ID() {
        return this.STMT_DELETE_ENVIRONMENTS_BY_ID;
    }

    public Try<Object> delete(String environmentId) {
        return (Try)this.sqlExec(this.STMT_DELETE_ENVIRONMENTS_BY_ID(), (Map<String, Object>)Utils$.MODULE$.params((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"environmentId"), (Object)package$.MODULE$.toPersistedId(environmentId))})), ps -> Try$.MODULE$.apply((Function0)(JFunction0.mcZ.sp & Serializable)() -> ps.execute()));
    }

    private Map<String, Integer> getLabelUids(Environment environment) {
        Map<String, Integer> labelIdsToUids;
        if (CollectionUtils.isEmpty((Collection)environment.getLabels())) {
            return Predef$.MODULE$.Map().empty();
        }
        scala.collection.immutable.Set labelIds = ((IterableOnceOps)CollectionConverters$.MODULE$.ListHasAsScala(environment.getLabels()).asScala().map((Function1 & Serializable)x$9 -> x$9.getId())).toSet();
        scala.collection.immutable.Set labelDiff = (scala.collection.immutable.Set)labelIds.diff((Set)(labelIdsToUids = this.environmentLabelPersistence().getUidsByIds((Iterable<String>)labelIds)).keySet());
        if (labelDiff.nonEmpty()) {
            throw new NotFoundException("Environment labels [" + labelDiff.mkString(", ") + "] not found", new Object[0]);
        }
        return labelIdsToUids;
    }

    private Seq<Object> insertEnvToLabelReferences(Integer environmentUid, scala.collection.immutable.Set<Integer> labelUids) {
        String insertEnvToLabelStmt = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("INSERT INTO " + EnvironmentSchema$ENV_TO_LABEL$.MODULE$.TABLE() + " (\n         |" + EnvironmentSchema$ENV_TO_LABEL$.MODULE$.ENVIRONMENT_UID() + ",\n         |" + EnvironmentSchema$ENV_TO_LABEL$.MODULE$.LABEL_UID() + "\n         |)\n         |VALUES (\n         |:" + EnvironmentSchema$ENV_TO_LABEL$.MODULE$.ENVIRONMENT_UID() + ",\n         |:" + EnvironmentSchema$ENV_TO_LABEL$.MODULE$.LABEL_UID() + "\n         |)\n       "));
        return this.sqlBatch(insertEnvToLabelStmt, (scala.collection.immutable.Set<Map<String, Object>>)((scala.collection.immutable.Set)labelUids.map((Function1 & Serializable)labelUid -> Utils$.MODULE$.params((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)EnvironmentSchema$ENV_TO_LABEL$.MODULE$.ENVIRONMENT_UID()), (Object)environmentUid), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)EnvironmentSchema$ENV_TO_LABEL$.MODULE$.LABEL_UID()), labelUid)})))));
    }

    private Seq<Object> updateEnvToLabelReferences(Environment environment, Integer environmentUid) {
        Map<String, Integer> labelIdsToUids = this.getLabelUids(environment);
        String deleteEnvToLabelRefsStmt = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n         |DELETE FROM " + EnvironmentSchema$ENV_TO_LABEL$.MODULE$.TABLE() + "\n         | WHERE\n         | " + EnvironmentSchema$ENV_TO_LABEL$.MODULE$.ENVIRONMENT_UID() + " = :" + EnvironmentSchema$ENV_TO_LABEL$.MODULE$.ENVIRONMENT_UID() + "\n       "));
        this.sqlExec(deleteEnvToLabelRefsStmt, (Map<String, Object>)Utils$.MODULE$.params((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)EnvironmentSchema$ENV_TO_LABEL$.MODULE$.ENVIRONMENT_UID()), (Object)environmentUid)})), x$10 -> BoxesRunTime.boxToBoolean((boolean)x$10.execute()));
        return this.insertEnvToLabelReferences(environmentUid, (scala.collection.immutable.Set<Integer>)labelIdsToUids.valuesIterator().toSet());
    }

    public Map<String, Integer> getUidsByIds(Iterable<String> environmentIds) {
        String stmt = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("|SELECT " + EnvironmentSchema$ENVIRONMENTS$.MODULE$.CI_UID() + ", " + EnvironmentSchema$ENVIRONMENTS$.MODULE$.ID() + "\n          |FROM " + EnvironmentSchema$ENVIRONMENTS$.MODULE$.TABLE() + "\n          |WHERE " + EnvironmentSchema$ENVIRONMENTS$.MODULE$.ID() + " IN (:environmentIds)\n       "));
        return this.sqlQuery(stmt, (Map<String, Object>)Utils$.MODULE$.params((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"environmentIds"), (Object)CollectionConverters$.MODULE$.IterableHasAsJava((Iterable)environmentIds.map((Function1 & Serializable)id -> package$.MODULE$.toPersistedId((String)id))).asJava())})), (Function1 & Serializable)rs -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)package$.MODULE$.ResultSetExtension((ResultSet)rs).getCiId(EnvironmentSchema$ENVIRONMENTS$.MODULE$.ID())), (Object)package.CiUid$.MODULE$.apply(rs.getInt(EnvironmentSchema$ENVIRONMENTS$.MODULE$.CI_UID())))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    private void sanitizeEnvironmentInput(Environment environment) {
        environment.setTitle(Utils.RichStringAsTruncatable$.MODULE$.trimAndTruncate$extension(Utils$.MODULE$.RichStringAsTruncatable(environment.getTitle()), EnvironmentSchema$.MODULE$.TITLE_LENGTH()));
        environment.setDescription(Utils.RichStringAsTruncatable$.MODULE$.trimAndTruncate$extension(Utils$.MODULE$.RichStringAsTruncatable(environment.getDescription()), EnvironmentSchema$.MODULE$.DESCRIPTION_LENGTH()));
    }

    public static final /* synthetic */ boolean $anonfun$insert$2(ResultSet x$1) {
        return x$1.getInt(1) > 0;
    }

    public static final /* synthetic */ boolean $anonfun$update$3(ResultSet x$3) {
        return x$3.getInt(1) > 0;
    }

    @Autowired
    public EnvironmentPersistence(@Qualifier(value="xlrRepositoryJdbcTemplate") JdbcTemplate jdbcTemplate, @Qualifier(value="xlrRepositorySqlDialect") SqlBuilder.Dialect dialect, CiIdService ciIdService, SecurablePersistence securablePersistence, EnvironmentStagePersistence environmentStagePersistence, EnvironmentLabelPersistence environmentLabelPersistence) {
        this.jdbcTemplate = jdbcTemplate;
        this.dialect = dialect;
        this.ciIdService = ciIdService;
        this.securablePersistence = securablePersistence;
        this.environmentStagePersistence = environmentStagePersistence;
        this.environmentLabelPersistence = environmentLabelPersistence;
        Utils.$init$((Utils)this);
        CompressionSupport.$init$((CompressionSupport)this);
        PersistenceSupport.$init$((PersistenceSupport)this);
        this.STMT_INSERT_ENVIRONMENTS = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n       |INSERT INTO " + EnvironmentSchema$ENVIRONMENTS$.MODULE$.TABLE() + "\n       |(" + EnvironmentSchema$ENVIRONMENTS$.MODULE$.CI_UID() + ",\n       |" + EnvironmentSchema$ENVIRONMENTS$.MODULE$.ID() + ",\n       |" + EnvironmentSchema$ENVIRONMENTS$.MODULE$.TITLE() + ",\n       |" + EnvironmentSchema$ENVIRONMENTS$.MODULE$.DESCRIPTION() + ",\n       |" + EnvironmentSchema$ENVIRONMENTS$.MODULE$.ENV_STAGE_UID() + ")\n       |VALUES\n       |(:" + EnvironmentSchema$ENVIRONMENTS$.MODULE$.CI_UID() + ",\n       |:" + EnvironmentSchema$ENVIRONMENTS$.MODULE$.ID() + ",\n       |:" + EnvironmentSchema$ENVIRONMENTS$.MODULE$.TITLE() + ",\n       |:" + EnvironmentSchema$ENVIRONMENTS$.MODULE$.DESCRIPTION() + ",\n       |:" + EnvironmentSchema$ENVIRONMENTS$.MODULE$.ENV_STAGE_UID() + ")\n      "));
        this.STMT_EXISTS_BY_TITLE_IGNORECASE = "SELECT COUNT(*) FROM " + EnvironmentSchema$ENVIRONMENTS$.MODULE$.TABLE() + " WHERE LOWER(" + EnvironmentSchema$ENVIRONMENTS$.MODULE$.TITLE() + ") = LOWER(:" + EnvironmentSchema$ENVIRONMENTS$.MODULE$.TITLE() + ")";
        this.STMT_UPDATE_ENVIRONMENTS = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("|UPDATE " + EnvironmentSchema$ENVIRONMENTS$.MODULE$.TABLE() + "\n        | SET\n        |  " + EnvironmentSchema$ENVIRONMENTS$.MODULE$.DESCRIPTION() + " = :" + EnvironmentSchema$ENVIRONMENTS$.MODULE$.DESCRIPTION() + ",\n        |  " + EnvironmentSchema$ENVIRONMENTS$.MODULE$.TITLE() + " = :" + EnvironmentSchema$ENVIRONMENTS$.MODULE$.TITLE() + ",\n        |  " + EnvironmentSchema$ENVIRONMENTS$.MODULE$.ENV_STAGE_UID() + " = :" + EnvironmentSchema$ENVIRONMENTS$.MODULE$.ENV_STAGE_UID() + "\n        | WHERE\n        |  " + EnvironmentSchema$ENVIRONMENTS$.MODULE$.CI_UID() + " = :" + EnvironmentSchema$ENVIRONMENTS$.MODULE$.CI_UID() + "\n        "));
        this.STMT_EXISTS_ANOTHER_ENV_WITH_TITLE = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n       |" + this.STMT_EXISTS_BY_TITLE_IGNORECASE() + "\n       |AND " + EnvironmentSchema$ENVIRONMENTS$.MODULE$.CI_UID() + " <> :" + EnvironmentSchema$ENVIRONMENTS$.MODULE$.CI_UID() + "\n      "));
        this.STMT_DELETE_ENVIRONMENTS_BY_ID = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("|DELETE FROM " + EnvironmentSchema$ENVIRONMENTS$.MODULE$.TABLE() + "\n        | WHERE " + EnvironmentSchema$ENVIRONMENTS$.MODULE$.ID() + " = :environmentId"));
    }
}

