/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.api.internal;

import com.xebialabs.deployit.checks.Checks;
import com.xebialabs.xlrelease.api.internal.BaseActivityLogsResource;
import com.xebialabs.xlrelease.param.IdParam;
import com.xebialabs.xlrelease.security.PermissionChecker;
import com.xebialabs.xlrelease.service.ReleaseActivityLogsService;
import com.xebialabs.xlrelease.views.ActivityLogEntryView;
import com.xebialabs.xlrelease.views.LogsFilters;
import com.xebialabs.xlrelease.views.converters.UserViewConverter;
import java.util.List;
import javax.ws.rs.Consumes;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.stereotype.Controller;

@Path(value="/activity")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
@Controller
public class ReleaseActivityLogsResource
extends BaseActivityLogsResource {
    private PermissionChecker permissions;

    @Autowired
    public ReleaseActivityLogsResource(ReleaseActivityLogsService releaseActivityLogsService, UserViewConverter userViewConverter, PermissionChecker permissions) {
        super(releaseActivityLogsService, userViewConverter);
        this.permissions = permissions;
    }

    @POST
    @Path(value="/{releaseId:.*Release[^/-]*}/logs/search")
    public List<ActivityLogEntryView> searchReleaseLogs(@PathParam(value="releaseId") @IdParam String releaseId, @DefaultValue(value="0") @QueryParam(value="page") int page, @DefaultValue(value="100") @QueryParam(value="resultsPerPage") int resultsPerPage, LogsFilters filters) {
        Checks.checkArgument(((long)resultsPerPage <= 100L ? 1 : 0) != 0, (String)"Number of results per page cannot be more than %d", (Object[])new Object[]{100L});
        this.permissions.checkView(releaseId);
        PageRequest pageable = PageRequest.of((int)page, (int)resultsPerPage, (Sort)Sort.unsorted());
        return this.searchLogs(releaseId, filters, (Pageable)pageable);
    }
}

