/*
 * Decompiled with CFR 0.152.
 */
package org.rzo.yajsw.app;

import com.sun.management.HotSpotDiagnosticMXBean;
import io.netty.bootstrap.Bootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.oio.OioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.oio.OioSocketChannel;
import io.netty.handler.codec.DelimiterBasedFrameDecoder;
import io.netty.handler.codec.Delimiters;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.SimpleLoggerFactory;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.management.ThreadMXBean;
import java.lang.reflect.Method;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.URL;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Properties;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import javax.management.MBeanServer;
import javax.management.MBeanServerFactory;
import javax.management.ObjectName;
import org.apache.commons.configuration2.Configuration;
import org.apache.commons.logging.LogFactory;
import org.rzo.yajsw.Constants;
import org.rzo.yajsw.YajswVersion;
import org.rzo.yajsw.action.Action;
import org.rzo.yajsw.action.ActionFactory;
import org.rzo.yajsw.app.WrapperManager;
import org.rzo.yajsw.app.WrapperManagerImplMBean;
import org.rzo.yajsw.config.ConfigUtils;
import org.rzo.yajsw.config.YajswConfiguration;
import org.rzo.yajsw.config.YajswConfigurationImpl;
import org.rzo.yajsw.controller.Message;
import org.rzo.yajsw.controller.jvm.MessageDecoder;
import org.rzo.yajsw.controller.jvm.MessageEncoder;
import org.rzo.yajsw.io.CyclicBufferFileInputStream;
import org.rzo.yajsw.io.CyclicBufferFilePrintStream;
import org.rzo.yajsw.io.TeeInputStream;
import org.rzo.yajsw.io.TeeOutputStream;
import org.rzo.yajsw.nettyutils.SystemOutLoggingFilter;
import org.rzo.yajsw.os.OperatingSystem;
import org.rzo.yajsw.script.Script;
import org.rzo.yajsw.script.ScriptFactory;
import org.rzo.yajsw.util.Cycler;
import org.rzo.yajsw.util.DaemonThreadFactory;
import org.rzo.yajsw.util.Utils;
import org.rzo.yajsw.wrapper.AlphaNumericComparator;

public class WrapperManagerImpl
implements WrapperManager,
Constants,
WrapperManagerImplMBean {
    int _port = 15003;
    int _debug = 3;
    boolean _debugComm = false;
    final InternalLogger log = SimpleLoggerFactory.getInstance("WrapperManager");
    volatile boolean _started = false;
    String _key;
    int _pingInterval = 5000;
    Bootstrap connector;
    volatile Channel _session;
    volatile boolean _stopping = false;
    Configuration _config;
    static WrapperManagerImpl instance;
    int _exitCode = 0;
    Method mainMethod = null;
    String mainClassName = null;
    String module = null;
    List<String> modulePath = null;
    String[] mainMethodArgs = null;
    int exitOnMainTerminate = -1;
    private int exitOnException = 999;
    volatile int _myPid = -1;
    boolean _externalStop = false;
    String _groovyScript = null;
    Cycler _pinger;
    OutputStream _outStream;
    OutputStream _errStream;
    volatile boolean _appearHanging = false;
    boolean _overrideStdErr = false;
    boolean _haltAppOnWrapper = false;
    Lock _lock = new ReentrantLock();
    Condition _connectEnd = this._lock.newCondition();
    Executor executor = Executors.newCachedThreadPool(new DaemonThreadFactory("yajsw-pool", 10));
    long _startupTimeout = 0L;
    volatile String shutdownScript = null;
    Properties _properties;
    volatile boolean _dumpingHeap = false;
    volatile String _stopReason = null;
    float currentPercentHeap = -1.0f;
    long minorGCDuration = -1L;
    long fullGCDuration = -1L;
    final MemoryMXBean memoryBean = ManagementFactory.getMemoryMXBean();
    final long maxHeap = this.memoryBean.getHeapMemoryUsage().getMax();
    final Object _heapDataLock = new Object();
    boolean _sendHeapData = false;
    private long lastMinorCollectionCount;
    private long lastMinorCollectionTime;
    private long lastFullCollectionCount;
    private long lastFullCollectionTime;
    Long usedHeap = null;
    Long timeMinorGC = null;
    Long timeFullGC = null;
    Long lastUsedHeap = null;
    GarbageCollectorMXBean minorGCBean;
    GarbageCollectorMXBean fullGCBean;
    MessageFormat gcFormat = null;
    boolean _initGCBeans = false;
    volatile Runnable _shutdownListener;
    volatile long _pingTime = System.currentTimeMillis();
    BlockingQueue<String> _keystoreResult = new ArrayBlockingQueue<String>(1);
    private boolean _wrapperPingCheckAck = false;
    volatile boolean _heapNotified = false;
    private static final String HOTSPOT_BEAN_NAME = "com.sun.management:type=HotSpotDiagnostic";

    private String getSystemProperty(String key) {
        String result = System.getProperty(key);
        if (result != null && result.contains("\"")) {
            result.replaceAll("\"", "");
        }
        return result;
    }

    public void init(String[] args, ClassLoader wrapperClassLoader) {
        String preScript;
        String vStr;
        boolean visible;
        System.out.println("YAJSW: yajsw-stable-13.07");
        System.out.println("OS   : " + YajswVersion.OS_VERSION);
        System.out.println("JVM  : " + YajswVersion.JAVA_VERSION);
        ClassLoader currentClassLoader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(wrapperClassLoader);
        LogFactory.getFactory().setAttribute("org.apache.commons.logging.Log", (Object)"org.apache.commons.logging.impl.SimpleLog");
        instance = this;
        String outFile = this.getSystemProperty("wrapper.teeName");
        String outPath = this.getSystemProperty("wrapper.tmp.path");
        if (outPath != null) {
            outPath = outPath.replaceAll("\"", "");
        }
        boolean bl = visible = (vStr = this.getSystemProperty("wrapper.console.visible")) != null && vStr.equals("true");
        if (outFile != null) {
            this.teeSystemStreams(outFile, outPath, visible);
        }
        if ((preScript = this.getSystemProperty("wrapper.app.pre.script")) != null & !"".equals(preScript)) {
            try {
                Script script;
                if (this._debug > 2) {
                    System.out.println("wrapped process: executing pre script " + preScript);
                }
                if ((script = ScriptFactory.createScript(preScript, "wrapper.app.pre.script", null, new String[0], this.log, 0, "UTF-8", false, this._debug, 1)) != null) {
                    script.execute();
                } else {
                    System.out.println("wrapped process: executing pre script error: could not open script");
                }
            }
            catch (Throwable ex) {
                ex.printStackTrace();
            }
        }
        YajswConfigurationImpl config = new YajswConfigurationImpl();
        config.init();
        boolean dbg = config.getBoolean("wrapper.debug", false);
        int debugLevel = config.getInt("wrapper.debug.level", 3);
        this._debug = dbg ? debugLevel : 0;
        this._debugComm = config.getBoolean("wrapper.debug.comm", false);
        this.logJavaInfo(args);
        try {
            this._overrideStdErr = config.getBoolean("wrapper.java.dump.override", false);
        }
        catch (Exception ex) {
            System.out.println("Error getting wrapper.java.dump.override " + ex.getMessage());
        }
        try {
            String control;
            this.mainClassName = config.getString("wrapper.java.app.mainclass");
            String jarName = config.getString("wrapper.java.app.jar");
            Configuration mp = config.subset("wrapper.java.app.module-path");
            if (mp != null && !mp.isEmpty()) {
                this.modulePath = new ArrayList<String>();
                Iterator it = mp.getKeys();
                while (it.hasNext()) {
                    this.modulePath.add(mp.getString((String)it.next()));
                }
            }
            this.module = config.getString("wrapper.java.app.module", null);
            String groovyScript = config.getString("wrapper.groovy");
            if (this.mainClassName == null && jarName == null && groovyScript == null && this.module == null) {
                this.mainClassName = config.getString("wrapper.app.parameter.1");
            }
            if (this._debug > 1) {
                System.out.println("mainClass/jar/script/module: " + this.mainClassName + "/" + jarName + "/" + groovyScript + "/" + this.module);
            }
            if (jarName == null && this.mainClassName == null && groovyScript == null && this.module == null) {
                System.out.println("missing main class name or jar file or groovy file or module. please check configuration");
                return;
            }
            if (jarName != null && this.module == null) {
                this.mainMethod = this.loadJar(jarName);
            } else if (this.mainClassName != null && this.module == null) {
                try {
                    Class<?> cls = ClassLoader.getSystemClassLoader().loadClass(this.mainClassName);
                    this.mainMethod = cls.getMethod("main", String[].class);
                }
                catch (Exception e) {
                    System.out.println("error finding main method in class: " + this.mainClassName + " : " + e.getMessage());
                    e.printStackTrace();
                    return;
                }
            } else {
                this._groovyScript = groovyScript;
            }
            String stopConfig = config.getString("wrapper.stop.conf");
            if (stopConfig != null) {
                File f = new File(stopConfig);
                this._externalStop = true;
            }
            if (this._debug > 1) {
                System.out.println("external stop " + this._externalStop);
            }
            this.exitOnMainTerminate = config.getInt("wrapper.exit_on_main_terminate", -1);
            this.exitOnException = config.getInt("wrapper.exit_on_main_exception", 999);
            this.mainMethodArgs = this.getAppParam((Configuration)config);
            this.setConfiguration((Configuration)config);
            if (this._config.getBoolean("wrapper.java.jmx", false)) {
                this.registerMBean(config);
            }
            if ("TIGHT".equals(control = this._config.getString("wrapper.control", "TIGHT")) || "APPLICATION".equals(control)) {
                this._haltAppOnWrapper = true;
            }
            this.setKey(this._config.getString("wrapper.key"));
            this.setPort(this._config.getInt("wrapper.port"));
            this.setPingInterval(this._config.getInt("wrapper.ping.interval", 5));
            this._startupTimeout = this._config.getInt("wrapper.startup.timeout", 30) * 1000;
            this._wrapperPingCheckAck = this._config.getBoolean("wrapper.ping.check_ack", false);
            this.shutdownScript = this._config.getString("wrapper.app.shutdown.script", null);
            if (this.shutdownScript != null && !"".equals(this.shutdownScript)) {
                Runtime.getRuntime().addShutdownHook(new Thread(){

                    @Override
                    public void run() {
                        WrapperManagerImpl.this.executeShutdownScript();
                    }
                });
            }
            try {
                this._sendHeapData = config.getBoolean("wrapper.java.monitor.gc.restart", false) || config.getBoolean("wrapper.java.monitor.heap", false);
            }
            catch (Exception ex) {
                System.out.println("error reading wrapper.java.monitor.*.restart");
            }
            this.monitorDeadLocks(config);
            this.monitorHeap(config);
            this.monitorGc(config);
            if (this._debug > 1) {
                System.out.println("terminated WrapperManager.init()");
            }
            LogFactory.getFactory().removeAttribute("org.apache.commons.logging.Log");
            Utils.verifyIPv4IsPreferred(null);
        }
        catch (Throwable ex) {
            ex.printStackTrace();
        }
        if (currentClassLoader != null) {
            Thread.currentThread().setContextClassLoader(currentClassLoader);
        }
    }

    private void monitorDeadLocks(YajswConfigurationImpl config) {
        if (config.getBoolean("wrapper.java.monitor.deadlock", false)) {
            final long cycle = config.getLong("wrapper.java.monitor.deadlock.interval", 30L) * 1000L;
            final ThreadMXBean bean = ManagementFactory.getThreadMXBean();
            if (this._debug > 2) {
                System.out.println("monitor deadlock: start");
            }
            this.executor.execute(new Runnable(){

                @Override
                public void run() {
                    while (!WrapperManagerImpl.this._stopping) {
                        long[] ids = bean.findDeadlockedThreads();
                        if (ids != null && ids.length > 0) {
                            System.err.println("wrapper.java.monitor.deadlock: DEADLOCK IN THREADS: ");
                            WrapperManagerImpl.this.threadDump(ids);
                            return;
                        }
                        try {
                            Thread.sleep(cycle);
                        }
                        catch (InterruptedException e) {
                            return;
                        }
                    }
                }
            });
        }
    }

    private void monitorHeap(YajswConfigurationImpl config) {
        if (config.getBoolean("wrapper.java.monitor.heap", false)) {
            final long cycle = config.getLong("wrapper.java.monitor.heap.interval", 30L) * 1000L;
            final int thresholdPercent = config.getInt("wrapper.java.monitor.heap.threshold.percent", 95);
            if (this._debug > 2) {
                System.out.println("monitor heap: start");
            }
            this.executor.execute(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    while (!WrapperManagerImpl.this._stopping) {
                        Object object = WrapperManagerImpl.this._heapDataLock;
                        synchronized (object) {
                            long usedMem = WrapperManagerImpl.this.memoryBean.getHeapMemoryUsage().getUsed();
                            WrapperManagerImpl.this.currentPercentHeap = (float)((double)usedMem / (double)WrapperManagerImpl.this.maxHeap * 100.0);
                            if (WrapperManagerImpl.this.currentPercentHeap > (float)thresholdPercent) {
                                if (!WrapperManagerImpl.this._heapNotified) {
                                    System.err.println("wrapper.java.monitor.heap: HEAP SIZE EXCEEDS THRESHOLD: " + usedMem + "/" + WrapperManagerImpl.this.maxHeap + " => " + WrapperManagerImpl.this.currentPercentHeap + "%");
                                    WrapperManagerImpl.this._heapNotified = true;
                                }
                            } else if (WrapperManagerImpl.this._heapNotified) {
                                System.err.println("wrapper.java.monitor.heap: HEAP SIZE OK: " + usedMem + "/" + WrapperManagerImpl.this.maxHeap + " => " + WrapperManagerImpl.this.currentPercentHeap + "%");
                                WrapperManagerImpl.this._heapNotified = false;
                            }
                        }
                        try {
                            Thread.sleep(cycle);
                        }
                        catch (InterruptedException e) {
                            return;
                        }
                    }
                }
            });
        }
    }

    private void monitorGc(YajswConfigurationImpl config) {
        this.initGCBeans();
        String mFormat = config.getString("wrapper.java.monitor.gc", null);
        boolean gcRestart = config.getBoolean("wrapper.java.monitor.gc.restart", false);
        if (mFormat != null || gcRestart) {
            try {
                if (this._debug > 2) {
                    System.out.println("monitor GC: " + mFormat);
                }
                if (mFormat != null) {
                    this.gcFormat = new MessageFormat(mFormat);
                }
                final long cycle = config.getLong("wrapper.java.monitor.gc.interval", 1L) * 1000L;
                if (this._debug > 2) {
                    System.out.println("monitor gc: minorGCBean/fullGCBean: " + this.minorGCBean.getName() + "/" + this.fullGCBean.getName());
                    System.out.println("monitor gc: start cycle " + cycle + "ms");
                }
                this.executor.execute(new Runnable(){

                    @Override
                    public void run() {
                        if (WrapperManagerImpl.this.minorGCBean == null) {
                            System.err.println("monitor gc: could not find minorGCBean -> abort monitor");
                            return;
                        }
                        if (WrapperManagerImpl.this.fullGCBean == null) {
                            System.err.println("monitor gc: could not find fullGCBean -> abort monitor");
                            return;
                        }
                        try {
                            while (!WrapperManagerImpl.this._stopping) {
                                WrapperManagerImpl.this.getGCData();
                                Thread.sleep(cycle);
                            }
                        }
                        catch (Exception ex) {
                            ex.printStackTrace();
                        }
                        System.err.println("monitor gc: end");
                    }
                });
            }
            catch (Exception ex) {
                System.err.println("monitor gc: exception: " + ex);
                ex.printStackTrace();
            }
        }
    }

    private void initGCBeans() {
        if (this._initGCBeans) {
            return;
        }
        GarbageCollectorMXBean minorGCBeanX = null;
        GarbageCollectorMXBean fullGCBeanX = null;
        try {
            List<GarbageCollectorMXBean> gcMBeans = ManagementFactory.getGarbageCollectorMXBeans();
            for (GarbageCollectorMXBean gcBean : gcMBeans) {
                if (gcBean.getName().toLowerCase().contains("copy")) {
                    minorGCBeanX = gcBean;
                    continue;
                }
                if ("ParNew".equals(gcBean.getName())) {
                    minorGCBeanX = gcBean;
                    continue;
                }
                if (gcBean.getName().toLowerCase().contains("scavenge")) {
                    minorGCBeanX = gcBean;
                    continue;
                }
                if (gcBean.getName().toLowerCase().contains("marksweep")) {
                    fullGCBeanX = gcBean;
                    continue;
                }
                if (gcBean.getName().toLowerCase().contains("young")) {
                    minorGCBeanX = gcBean;
                    continue;
                }
                if (gcBean.getName().toLowerCase().contains("old")) {
                    fullGCBeanX = gcBean;
                    continue;
                }
                System.err.println("Unable to classify GarbageCollectorMXBean [" + gcBean.getName() + "]");
            }
        }
        catch (Throwable e) {
            System.out.println("error getting GC beans");
        }
        this.minorGCBean = minorGCBeanX;
        this.fullGCBean = fullGCBeanX;
        this._initGCBeans = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getGCData() {
        long diffTime;
        long diffCount;
        this.initGCBeans();
        if (this.minorGCBean == null || this.fullGCBean == null) {
            return;
        }
        if (this.minorGCBean.getCollectionCount() != this.lastMinorCollectionCount) {
            diffCount = this.minorGCBean.getCollectionCount() - this.lastMinorCollectionCount;
            diffTime = this.minorGCBean.getCollectionTime() - this.lastMinorCollectionTime;
            this.timeMinorGC = diffCount != 0L && diffCount != 1L ? Long.valueOf(diffTime / diffCount) : Long.valueOf(diffTime);
            this.usedHeap = this.memoryBean.getHeapMemoryUsage().getUsed();
            this.lastMinorCollectionCount = this.minorGCBean.getCollectionCount();
            this.lastMinorCollectionTime = this.minorGCBean.getCollectionTime();
        }
        if (this.fullGCBean.getCollectionCount() != this.lastFullCollectionCount) {
            diffCount = this.fullGCBean.getCollectionCount() - this.lastFullCollectionCount;
            diffTime = this.fullGCBean.getCollectionTime() - this.lastFullCollectionTime;
            this.timeFullGC = diffCount != 0L && diffCount != 1L ? Long.valueOf(diffTime / diffCount) : Long.valueOf(diffTime);
            this.lastFullCollectionCount = this.fullGCBean.getCollectionCount();
            this.lastFullCollectionTime = this.fullGCBean.getCollectionTime();
        }
        this.usedHeap = this.memoryBean.getHeapMemoryUsage().getUsed();
        if (this.usedHeap != null) {
            if (this.timeMinorGC == null) {
                this.timeMinorGC = 0L;
            }
            if (this.timeFullGC == null) {
                this.timeFullGC = 0L;
            }
            Object object = this._heapDataLock;
            synchronized (object) {
                this.currentPercentHeap = (float)this.usedHeap.longValue() / (float)this.maxHeap * 100.0f;
                if (this.minorGCDuration == -1L) {
                    this.minorGCDuration = 0L;
                }
                if (this.fullGCDuration == -1L) {
                    this.fullGCDuration = 0L;
                }
                this.minorGCDuration += this.timeMinorGC.longValue();
                this.fullGCDuration += this.timeFullGC.longValue();
            }
            this.lastUsedHeap = this.usedHeap;
            if (this.gcFormat != null) {
                System.err.println(this.gcFormat.format(new Object[]{this.usedHeap, this.timeMinorGC, this.timeFullGC}));
            }
            this.usedHeap = null;
            this.timeMinorGC = null;
            this.timeFullGC = null;
        }
    }

    private void registerMBean(YajswConfiguration config) {
        MBeanServer server = null;
        ArrayList<MBeanServer> servers = MBeanServerFactory.findMBeanServer(null);
        try {
            if (servers != null && servers.size() > 0) {
                server = servers.get(0);
            }
            if (server != null) {
                String name = config.getString("wrapper.console.title");
                if (name == null) {
                    name = config.getString("wrapper.ntservice.name");
                }
                if (name == null) {
                    name = "yajsw.noname";
                }
                name = ObjectName.quote(name);
                ObjectName oName = new ObjectName("Wrapper", "name", name);
                server.registerMBean(this, oName);
            } else {
                System.out.println("ERROR: no mbean server found ");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public Method getMainMethod() {
        return this.mainMethod;
    }

    public String getMainClassName() {
        return this.mainClassName;
    }

    public String getModule() {
        return this.module;
    }

    public List<String> getModulePath() {
        return this.modulePath;
    }

    public Object[] getMainMethodArgs() {
        return this.mainMethodArgs;
    }

    public int getExitOnMainTerminate() {
        if (this._debug > 2) {
            System.out.println("exit on main terminate " + this.exitOnMainTerminate);
        }
        return this.exitOnMainTerminate;
    }

    public int getExitOnException() {
        if (this._debug > 2) {
            System.out.println("exit on main exception " + this.exitOnException);
        }
        return this.exitOnException;
    }

    private Method loadJar(String jarName) {
        String mainClassName;
        Manifest manifest;
        URL url = null;
        try {
            url = new File(jarName).toURI().toURL();
        }
        catch (MalformedURLException e2) {
            e2.printStackTrace();
            return null;
        }
        try {
            manifest = new JarFile(new File(jarName)).getManifest();
        }
        catch (IOException e1) {
            e1.printStackTrace();
            return null;
        }
        Attributes attr = manifest.getMainAttributes();
        String cl = attr.getValue("Class-Path");
        ClassLoader loader = null;
        if (loader == null) {
            loader = ClassLoader.getSystemClassLoader();
        }
        if ((mainClassName = attr.getValue("Main-Class")) == null) {
            return null;
        }
        Method mainMethod = null;
        try {
            Class<?> cls = loader.loadClass(mainClassName);
            mainMethod = cls.getMethod("main", String[].class);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            System.err.println("ERROR: could not load main method from class/jar: " + mainClassName + "/" + jarName);
        }
        return mainMethod;
    }

    private File createRWfile(String path, String fname) {
        File pFile = new File(path);
        try {
            if (!pFile.exists()) {
                pFile.mkdirs();
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        File result = new File(path, fname);
        if (OperatingSystem.instance().isPosix()) {
            String absPath = result.getAbsolutePath();
            try {
                if (!result.exists()) {
                    result.createNewFile();
                }
                result.deleteOnExit();
                Process p = Runtime.getRuntime().exec("chmod 777 " + absPath);
                int i = 0;
                boolean ok = false;
                while (!ok && i < 200) {
                    try {
                        ++i;
                        Thread.yield();
                        p.exitValue();
                        ok = true;
                    }
                    catch (IllegalThreadStateException ex) {
                        Thread.sleep(100L);
                    }
                }
                p.destroy();
            }
            catch (Exception ex) {
                ex.printStackTrace(System.out);
            }
        }
        return result;
    }

    private void teeSystemStreams(String outFile, String path, boolean visible) {
        File fOut = this.createRWfile(path, "out_" + outFile);
        fOut.deleteOnExit();
        File fErr = this.createRWfile(path, "err_" + outFile);
        fErr.deleteOnExit();
        File fIn = this.createRWfile(path, "in_" + outFile);
        fIn.deleteOnExit();
        try {
            CyclicBufferFilePrintStream wrapperOut = new CyclicBufferFilePrintStream(fOut);
            TeeOutputStream newOut = new TeeOutputStream();
            newOut.connect(wrapperOut);
            if (visible) {
                newOut.connect(System.out);
            }
            this._outStream = wrapperOut;
            System.setOut(new PrintStream(newOut));
        }
        catch (Throwable e) {
            e.printStackTrace(System.out);
        }
        try {
            CyclicBufferFilePrintStream wrapperErr = new CyclicBufferFilePrintStream(fErr);
            TeeOutputStream newErr = new TeeOutputStream();
            newErr.connect(wrapperErr);
            if (visible) {
                newErr.connect(System.err);
            }
            this._errStream = newErr;
            System.setErr(new PrintStream(newErr));
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        try {
            CyclicBufferFileInputStream wrapperIn = new CyclicBufferFileInputStream(fIn, "r");
            TeeInputStream newIn = new TeeInputStream();
            newIn.connect(wrapperIn);
            newIn.connect(System.in);
            System.setIn(newIn);
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    private void logJavaInfo(String[] args) {
        if (this._debug > 1) {
            System.out.println("APP user name=" + this.getSystemProperty("user.name"));
            System.out.println("APP working dir=" + this.getSystemProperty("user.dir"));
            System.out.println("APP java version=" + this.getSystemProperty("java.version"));
            System.out.println("APP class path=" + this.getSystemProperty("java.class.path"));
            System.out.println("APP library path=" + this.getSystemProperty("java.library.path"));
        }
        String[] files = this.getSystemProperty("java.class.path").split(File.pathSeparator);
        for (int i = 0; i < files.length; ++i) {
            File f = new File(files[i]);
            if (f.exists()) continue;
            System.err.println("Classpath File not found: " + files[i]);
        }
        if (this._debug > 1) {
            String argsStr = "Application args: ";
            if (args != null && args.length > 0) {
                for (int i = 0; i < args.length; ++i) {
                    argsStr = argsStr + args[i] + " ";
                }
            } else {
                argsStr = argsStr + "no args";
            }
            System.out.println(argsStr);
        }
    }

    private String[] getAppParam(Configuration config) {
        ArrayList<String> result = new ArrayList<String>();
        ArrayList keys = new ArrayList();
        ListIterator it = config.getKeys("wrapper.app.parameter");
        while (it.hasNext()) {
            keys.add(it.next());
        }
        Collections.sort(keys, new AlphaNumericComparator());
        it = keys.listIterator();
        while (it.hasNext()) {
            String arg = config.getString((String)it.next());
            if (arg == null || (arg = arg.trim()).length() <= 0) continue;
            result.add(arg);
        }
        String[] args = new String[result.size()];
        int i = 0;
        Iterator it2 = result.iterator();
        while (it2.hasNext()) {
            args[i] = (String)it2.next();
            ++i;
        }
        if (this._debug > 1) {
            System.out.println("args: ");
            for (String arg : args) {
                System.out.println(arg);
            }
        }
        return args;
    }

    void setConfiguration(Configuration config) {
        this._config = config;
    }

    @Override
    public void start() {
        block5: {
            try {
                if (this._config.getBoolean("wrapper.console.pipestreams", false)) {
                    Socket dummy = new Socket("127.0.0.1", this._port);
                    OutputStream out = dummy.getOutputStream();
                    out.close();
                    dummy.close();
                }
            }
            catch (Throwable e1) {
                if (this._debug <= 1) break block5;
                e1.printStackTrace();
            }
        }
        this.connector = new Bootstrap();
        OioEventLoopGroup workerGroup = new OioEventLoopGroup(0, (ThreadFactory)new DaemonThreadFactory("netty", 10));
        this.connector.group((EventLoopGroup)workerGroup);
        this.connector.channel(OioSocketChannel.class);
        this.connector.remoteAddress((SocketAddress)new InetSocketAddress("127.0.0.1", this._port));
        this.connector.option(ChannelOption.SO_REUSEADDR, (Object)true);
        this.connector.option(ChannelOption.CONNECT_TIMEOUT_MILLIS, (Object)10000);
        this.connector.option(ChannelOption.TCP_NODELAY, (Object)true);
        if (this._debugComm) {
            this.connector.handler((ChannelHandler)new ChannelInitializer<SocketChannel>(){

                protected void initChannel(SocketChannel ch) throws Exception {
                    ch.pipeline().addLast(new ChannelHandler[]{new SystemOutLoggingFilter("WrapperManager"), new DelimiterBasedFrameDecoder(8192, true, Delimiters.nulDelimiter()), new MessageEncoder(), new MessageDecoder(), new WrapperHandler()});
                }
            });
        } else {
            this.connector.handler((ChannelHandler)new ChannelInitializer<SocketChannel>(){

                protected void initChannel(SocketChannel ch) throws Exception {
                    ch.pipeline().addLast(new ChannelHandler[]{new DelimiterBasedFrameDecoder(8192, true, Delimiters.nulDelimiter()), new MessageEncoder(), new MessageDecoder(), new WrapperHandler()});
                }
            });
        }
        this._pinger = new Cycler(this.getPingInterval(), 0L, Executors.newCachedThreadPool(new DaemonThreadFactory("pinger", 10)), new Runnable(){
            long start = System.currentTimeMillis();

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                ChannelFuture future = null;
                if (WrapperManagerImpl.this._session != null && WrapperManagerImpl.this._session.isActive() && !WrapperManagerImpl.this._stopping && !WrapperManagerImpl.this._appearHanging) {
                    if (WrapperManagerImpl.this._wrapperPingCheckAck && System.currentTimeMillis() - WrapperManagerImpl.this._pingTime > (long)(3 * WrapperManagerImpl.this.getPingInterval())) {
                        System.out.println("missing ping ack for " + (System.currentTimeMillis() - WrapperManagerImpl.this._pingTime) + " ms. Closing tcp/ip connection");
                        WrapperManagerImpl.this._session.close();
                    } else {
                        Object object = WrapperManagerImpl.this._heapDataLock;
                        synchronized (object) {
                            if (WrapperManagerImpl.this._sendHeapData) {
                                if (WrapperManagerImpl.this.minorGCDuration == -1L) {
                                    WrapperManagerImpl.this.getGCData();
                                }
                                future = WrapperManagerImpl.this._session.writeAndFlush((Object)new Message(103, "" + WrapperManagerImpl.this.currentPercentHeap + ";" + WrapperManagerImpl.this.minorGCDuration + ";" + WrapperManagerImpl.this.fullGCDuration + ";" + WrapperManagerImpl.this.lastUsedHeap));
                                WrapperManagerImpl.this.currentPercentHeap = -1.0f;
                                WrapperManagerImpl.this.minorGCDuration = -1L;
                                WrapperManagerImpl.this.fullGCDuration = -1L;
                            } else {
                                future = WrapperManagerImpl.this._session.writeAndFlush((Object)new Message(103, ""));
                            }
                        }
                    }
                    try {
                        if (future != null) {
                            future.await(10000L);
                        }
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                    this.start = System.currentTimeMillis();
                } else if (WrapperManagerImpl.this._haltAppOnWrapper && System.currentTimeMillis() - this.start > WrapperManagerImpl.this._startupTimeout && !WrapperManagerImpl.this._stopping) {
                    System.out.println("no connection to wrapper during " + WrapperManagerImpl.this._startupTimeout / 1000L + " seconds -> System.exit(-1)");
                    System.out.println("if this is due to server overload consider increasing yajsw configuration property wrapper.startup.timeout");
                    System.exit(-1);
                }
            }
        });
        this._pinger.start();
        this.reconnect();
    }

    private void reconnect() {
        while (!this._started) {
            if (this._debug > 1) {
                System.out.println("connecting to port " + this._port);
            }
            ChannelFuture future1 = this.connector.connect();
            try {
                Thread.yield();
                future1.await(10000L);
                this._started = future1.isSuccess();
            }
            catch (Exception e1) {
                System.out.println("error connecting to wrapper: " + e1);
                e1.printStackTrace();
            }
            if (this._started) {
                if (this._debug > 2) {
                    System.out.println("WrapperManager: channel connected, sending key");
                }
                future1.channel().writeAndFlush((Object)new Message(110, this._key));
                continue;
            }
            try {
                if (this._debug > 0) {
                    System.out.println("connection failed -> sleep then retry");
                }
                this._started = false;
                Thread.sleep(5000L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    int getPort() {
        return this._port;
    }

    public void setPort(int port) {
        this._port = port;
    }

    int getDebug() {
        return this._debug;
    }

    void setDebug(int debug) {
        this._debug = debug;
    }

    String getKey() {
        return this._key;
    }

    public void setKey(String key) {
        this._key = key;
    }

    boolean isStarted() {
        return this._started;
    }

    int getPingInterval() {
        return this._pingInterval;
    }

    void setPingInterval(int pingInterval) {
        this._pingInterval = pingInterval * 1000;
    }

    @Override
    public void stop() {
        if (this._session != null) {
            while (this._session != null && !this._stopping) {
                this._session.writeAndFlush((Object)new Message(101, null));
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
            while (true) {
                try {
                    while (true) {
                        Thread.sleep(1000L);
                    }
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                    continue;
                }
                break;
            }
        }
        System.exit(0);
    }

    @Override
    public void stopTimer() {
        if (this._session != null) {
            while (this._session != null && !this._stopping) {
                this._session.writeAndFlush((Object)new Message(117, null));
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    @Override
    public void restart() {
        if (this._session != null) {
            while (this._session != null && !this._stopping) {
                ChannelFuture future = this._session.writeAndFlush((Object)new Message(102, null));
                try {
                    future.await(1000L);
                }
                catch (InterruptedException e1) {
                    e1.printStackTrace();
                }
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
            while (true) {
                try {
                    while (true) {
                        Thread.sleep(1000L);
                    }
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                    continue;
                }
                break;
            }
        }
        System.out.println("not connected to wrapper -> cannot send restart command");
    }

    public static WrapperManagerImpl instance() {
        return instance;
    }

    public int getPid() {
        return this._myPid;
    }

    @Override
    public boolean isControlledByWrapper() {
        return this._started;
    }

    @Override
    public boolean isLaunchedAsService() {
        return this._config.getBoolean("wrapper.service", false);
    }

    public String getGroovyScript() {
        return this._groovyScript;
    }

    @Override
    public void threadDump() {
        System.out.println("yajsw: thread dump requested");
        this.threadDump(null);
    }

    public void threadDump(long[] ids) {
        Message m = new Message(118, null);
        Action a = ActionFactory.getAction(m);
        try {
            if (this._overrideStdErr) {
                a.execute(m, this._session, new PrintStream(this._errStream), ids);
            } else {
                a.execute(m, this._session, System.err, ids);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void gc() {
        System.out.println("yajsw: gc requested");
        System.gc();
    }

    @Override
    public void dumpHeap(final String fileName) {
        if (this._dumpingHeap) {
            return;
        }
        System.out.println("yajsw: dumpHeap requested " + fileName);
        this._dumpingHeap = true;
        this.executor.execute(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    File parent;
                    File file = fileName == null || fileName.length() < 1 ? new File(".") : new File(fileName);
                    if (file.isDirectory()) {
                        parent = file;
                        file = new File(parent, "dump_" + new SimpleDateFormat("yyyy_MM_dd-hh_mm").format(new Date()) + ".hprof");
                    } else {
                        parent = file.getParentFile();
                    }
                    if (!parent.exists()) {
                        parent.mkdirs();
                    }
                    HotSpotDiagnosticMXBean mb = ManagementFactory.newPlatformMXBeanProxy(ManagementFactory.getPlatformMBeanServer(), WrapperManagerImpl.HOTSPOT_BEAN_NAME, HotSpotDiagnosticMXBean.class);
                    File dumpFile = new File(parent, file.getName());
                    mb.dumpHeap(dumpFile.getAbsolutePath(), true);
                    System.out.println("yajsw: dumpHeap done " + dumpFile.getAbsolutePath());
                }
                catch (Throwable ex) {
                    ex.printStackTrace();
                }
                finally {
                    WrapperManagerImpl.this._dumpingHeap = false;
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws MalformedURLException {
        String name = "c:/test test/start.jar";
        System.out.println(new File(name).exists());
        System.out.println(new File(new File(name).toURI().getPath()).exists());
        WrapperManagerImpl wm = new WrapperManagerImpl();
        wm.loadJar("c:/test test/start.jar");
        WrapperManagerImpl wrapperManagerImpl = wm;
        synchronized (wrapperManagerImpl) {
            wm.threadDump();
        }
    }

    @Override
    public boolean isAppearHanging() {
        return this._appearHanging;
    }

    @Override
    public void setAppearHanging(boolean appearHanging) {
        this._appearHanging = appearHanging;
    }

    public void reportServiceStartup() {
        boolean reported = false;
        while (!reported && !this._stopping) {
            if (this._session == null || !this._session.isActive()) {
                try {
                    Thread.sleep(500L);
                }
                catch (Exception exception) {}
                continue;
            }
            this._session.writeAndFlush((Object)new Message(119, null));
            reported = true;
        }
    }

    private void executeShutdownScript() {
        if (this.shutdownScript != null & !"".equals(this.shutdownScript)) {
            if (this._debug > 1) {
                System.out.println("executing shutdown script " + this.shutdownScript);
            }
            Script script = ScriptFactory.createScript(this.shutdownScript, "wrapper.app.shutdown.script", null, new String[0], this.log, 0, this._config.getString("wrapper.script.encoding"), this._config.getBoolean("wrapper.script.reload", false), this._debug, 1);
            this.shutdownScript = null;
            if (script != null) {
                script.execute();
                if (this._debug > 2) {
                    System.out.println("terminated shutdown script ");
                }
            } else {
                System.out.println("Error " + this.shutdownScript + "not initialized");
            }
        }
    }

    private void executeShutdownListener() {
        if (this._shutdownListener == null) {
            return;
        }
        new Thread(this._shutdownListener).start();
    }

    public void executeScript(String scriptFileName, ClassLoader wrapperClassLoader) {
        System.out.println("initializing script " + scriptFileName);
        ClassLoader currentClassLoader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(wrapperClassLoader);
        try {
            Script script = ScriptFactory.createScript(scriptFileName, "", null, (String[])this.getMainMethodArgs(), null, 0, this._config.getString("wrapper.script.encoding"), this._config.getBoolean("wrapper.script.reload", false), this._debug, 1);
            if (script != null) {
                script.execute();
            } else {
                System.err.println("error opening script script: " + scriptFileName);
            }
        }
        catch (Throwable ex) {
            System.err.println("error executing script: " + scriptFileName);
            ex.printStackTrace();
        }
        Thread.currentThread().setContextClassLoader(currentClassLoader);
    }

    public void signalStopping(int timeoutHint) {
        try {
            if (this._session == null || !this._session.isActive()) {
                ChannelFuture future1 = this.connector.connect();
                future1.await();
                future1.isSuccess();
                this._session = future1.channel();
            }
            ChannelFuture wFuture = this._session.writeAndFlush((Object)new Message(104, String.valueOf(timeoutHint)));
            wFuture.await();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            this._session.close();
            this._session = null;
        }
    }

    public String keystore(String key) throws InterruptedException {
        String result = null;
        System.out.println("get keystore for " + key);
        int i = 0;
        while (this._session == null && !this._stopping && i++ < 10) {
            Thread.sleep(1000L);
        }
        if (this._session != null && !this._stopping) {
            try {
                this._session.writeAndFlush((Object)new Message(115, key));
                result = this._keystoreResult.poll(5000L, TimeUnit.MILLISECONDS);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        } else {
            System.out.println("no session");
        }
        return result;
    }

    public Properties getProperties() {
        if (this._properties == null) {
            this._properties = ConfigUtils.asProperties(this._config);
        }
        return this._properties;
    }

    @Override
    public String getStopReason() {
        return this._stopReason;
    }

    public void setShutdownListener(Runnable listener) {
        this._shutdownListener = listener;
    }

    public void warn(String string) {
        if (this._debug > 1) {
            System.out.println(string);
        }
    }

    class WrapperHandler
    extends ChannelInboundHandlerAdapter {
        WrapperHandler() {
        }

        public void channelInactive(ChannelHandlerContext ctx) throws Exception {
            if (WrapperManagerImpl.this._debug > 1) {
                System.out.println("session closed");
            }
            WrapperManagerImpl.this._started = false;
            if (WrapperManagerImpl.this._session != null) {
                try {
                    WrapperManagerImpl.this._session.close();
                }
                catch (Throwable ex) {
                    ex.printStackTrace();
                }
            }
            WrapperManagerImpl.this._session = null;
            if (!WrapperManagerImpl.this._stopping) {
                if (WrapperManagerImpl.this._debug > 0) {
                    System.out.println("try reconnect");
                }
                WrapperManagerImpl.this.executor.execute(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            Thread.sleep(5000L);
                        }
                        catch (InterruptedException e) {
                            e.printStackTrace();
                        }
                        WrapperManagerImpl.this.reconnect();
                    }
                });
            }
        }

        public void channelRead(ChannelHandlerContext ctx, Object message) {
            Message msg = (Message)message;
            if (WrapperManagerImpl.this._stopping) {
                return;
            }
            Channel session = ctx.channel();
            if (msg.getCode() == 101) {
                try {
                    System.out.println("wrapper manager received " + msg);
                    WrapperManagerImpl.this._stopping = true;
                    if (session != null) {
                        session.close();
                    }
                    if (msg.getMessage() != null && msg.getMessage().length() > 0) {
                        try {
                            String[] txt = msg.getMessage().split(":");
                            if (txt[0].length() > 0) {
                                WrapperManagerImpl.this._exitCode = Integer.parseInt(txt[0]);
                            }
                            if (txt.length > 1 && txt[1].length() > 0) {
                                WrapperManagerImpl.this._stopReason = txt[1];
                            }
                        }
                        catch (Exception txt) {
                            // empty catch block
                        }
                    }
                    WrapperManagerImpl.this.executeShutdownScript();
                    WrapperManagerImpl.this.executeShutdownListener();
                    if (!WrapperManagerImpl.this._externalStop) {
                        System.exit(WrapperManagerImpl.this._exitCode);
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            } else if (msg.getCode() == 116) {
                WrapperManagerImpl.this._session = session;
                try {
                    WrapperManagerImpl.this._myPid = Integer.parseInt(msg.getMessage());
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            } else if (msg.getCode() == 118) {
                WrapperManagerImpl.this.threadDump();
            } else if (msg.getCode() == 120) {
                WrapperManagerImpl.this.gc();
            } else if (msg.getCode() == 121) {
                WrapperManagerImpl.this.dumpHeap(msg.getMessage());
            } else if (msg.getCode() == 103) {
                WrapperManagerImpl.this._pingTime = System.currentTimeMillis();
            } else if (msg.getCode() == 122) {
                System.out.println("received keystore value");
                WrapperManagerImpl.this._keystoreResult.add(msg.getMessage());
            }
        }

        public void exceptionCaught(ChannelHandlerContext ctx, Throwable e) throws Exception {
            if (WrapperManagerImpl.this._debug > 1) {
                Throwable th = e;
                if (th == null) {
                    return;
                }
                String msg = th.getMessage();
                if (msg == null) {
                    return;
                }
                System.err.println(msg);
                if (!msg.toLowerCase().contains("connection refused")) {
                    th.printStackTrace(System.err);
                }
            }
        }
    }
}

