import React from 'react';
import PropTypes from 'prop-types';

const RELEASE_FLAG_STATUSES = {
    AT_RISK: <i className="xl-icon flag-risk-icon" />,
    OK: <i className="xl-icon flag-none-icon icon-l" />,
    ATTENTION_NEEDED: <i className="xl-icon flag-attention-icon" />,
};

const ReleaseFlagComponent = ({ status }) => {
    return RELEASE_FLAG_STATUSES[status];
};

ReleaseFlagComponent.propTypes = {
    status: PropTypes.string.isRequired,
};

export { ReleaseFlagComponent };
