import { RootState } from '../../../../../../../../../core/xlr-ui/app/js/store.types';
import { ManagedApplicationType, ManagedApplicationsPage, Template } from '../managed-application.types';
import { ApplicationManagementState } from './managed-application.reducer';
import { PluginInfo } from '../../external-deployments/components/wizard/basic-wizard/application-discovery-basic.component';

export const getTemplates = (state: RootState): Array<Template> => getApplicationManagementState(state).templates;
export const getApplicationManagementState = (state: RootState): ApplicationManagementState => state.applicationManagement;
export const getCreatedApplicationsSelector = (state: RootState): Array<ManagedApplicationType> => getApplicationManagementState(state).managedApplications;
export const getCreatedApplicationsCountSelector = (state: RootState): number => getApplicationManagementState(state).count;
export const getCreatedApplicationsTotalCountSelector = (state: RootState): number => getApplicationManagementState(state).totalCount;
export const getCreatedApplicationsLoadingSelector = (state: RootState): boolean => getApplicationManagementState(state).isLoading;
export const getCreatedApplicationsPageSelector = (state: RootState): ManagedApplicationsPage => getApplicationManagementState(state).page;
export const getValidServerCards = (state: RootState): PluginInfo[] => getApplicationManagementState(state).validServerCards;
export const getConditionSelector = (state: RootState): string => getApplicationManagementState(state).condition;
