import React from 'react';
import { ReactWrapper } from 'enzyme';
import { DotRadioGroup, RadioGroupProps } from '@digital-ai/dot-components';
import { stringPropertyMock } from '../../../../../../../../../../../core/xlr-ui/app/features/tasks/__mocks__/property.mock';
import { taskMock } from '../../../../../../../../../../../core/xlr-ui/app/features/tasks/__mocks__/task.mock';
import { mountWithTheme } from '../../../../../../../../../../../core/xlr-ui/tests/unit/testing-utils';
import { MarkStatus, WaitStatus } from './status.component';
import { PropertiesEnum } from '../../../../../../../../../../../core/xlr-ui/app/features/tasks/components/rails/config/components/types';

describe('Status component', () => {
    const onChange = jest.fn();
    let wrapper: ReactWrapper;

    const getRadioGroup = () => wrapper.find(DotRadioGroup);

    const task = {
        ...taskMock,
        inputProperties: {
            string: {
                value: 'READY',
            },
        },
    };

    const expectCommonProps = (props: RadioGroupProps) => {
        expect(props.className).toBe('radio-status');
        expect(props.disableGroup).toBe(false);
        expect(props.groupLabel).toBe(stringPropertyMock.label);
        expect(props.helperText).toBe(stringPropertyMock.description);
        expect(props.name).toBe(stringPropertyMock.name);
        expect(props.required).toBe(stringPropertyMock.required);
        expect(props.row).toBe(false);
        expect(props.value).toBe('READY');
    };

    describe('MarkStatus', () => {
        beforeEach(() => {
            wrapper = mountWithTheme(
                <MarkStatus
                    disabled={false}
                    expanded={false}
                    onChange={onChange}
                    propertiesEnum={PropertiesEnum.InputProperties}
                    property={stringPropertyMock}
                    task={task}
                />,
            );
        });

        it('should pass props', () => {
            const radioProps = getRadioGroup().props();
            expectCommonProps(radioProps);
            expect(radioProps.options).toStrictEqual([
                { label: 'Completed', value: 'READY' },
                {
                    label: 'Skipped',
                    value: 'SKIPPED',
                },
                { label: 'In progress', value: 'NOT_READY' },
            ]);
        });
        it('should have handle on change', () => {
            const radioProps = getRadioGroup().props();
            radioProps.onChange?.({} as never, 'SKIPPED');
            expect(onChange).toHaveBeenCalledWith({ value: 'SKIPPED', variable: null });
        });
    });

    describe('WaitStatus', () => {
        beforeEach(() => {
            wrapper = mountWithTheme(
                <WaitStatus
                    disabled={false}
                    expanded={false}
                    onChange={onChange}
                    propertiesEnum={PropertiesEnum.InputProperties}
                    property={stringPropertyMock}
                    task={task}
                />,
            );
        });
        it('should pass props', () => {
            const radioProps = getRadioGroup().props();
            expectCommonProps(radioProps);
            expect(radioProps.options).toStrictEqual([
                { label: 'Completed', value: 'READY' },
                { label: 'Available', value: 'NOT_READY' },
            ]);
        });

        it('should have handle on change', () => {
            const radioProps = getRadioGroup().props();
            radioProps.onChange?.({} as never, 'NOT_READY');
            expect(onChange).toHaveBeenCalledWith({ value: 'NOT_READY', variable: null });
        });
    });
});
