import { call, put, select } from 'redux-saga/effects';
import getAngularService from '../../../../../../../../../core/xlr-ui/app/features/common/services/angular-accessor';
import { IStateParamsService } from 'angular-ui-router';

import { registerSidebarProvider, SidebarProvider } from '../../../../../../../../../core/xlr-ui/app/features/custom-ui/sidebar.registry';
import { navigation } from '../../../../../../../../../core/xlr-ui/app/features/main-navigation/ducks/navigation.reducer';
import { MainNavigationItem, UiExtensionsService } from '../../../../../../../../../core/xlr-ui/app/features/tasks/types/angular';
import { Delivery } from '../../Tasks/js/components/types';
import { RootState } from '../../../../../../../../../core/xlr-ui/app/js/store.types';
import { BaseSidebarProvider } from '../../sidebar-provider/base-sidebar-provider';

const { setSidebarMenu, setBackItem } = navigation.actions;

export const selectDelivery = (state: RootState) => state.deliveryPatterns.delivery;

export class DeliveryPatternSidebarProvider extends BaseSidebarProvider implements SidebarProvider {
    isSupported(path: string): boolean {
        return path.includes('/delivery-patterns/Deliveries/');
    }

    *provide(path: string) {
        const stateParams: IStateParamsService = yield call(getAngularService, '$stateParams');
        const delivery: Delivery = yield select(selectDelivery);
        const uiExtensionsService: UiExtensionsService = yield call(getAngularService, 'UiExtensionsService');
        const deliveryPatternItems: MainNavigationItem[] = yield call(
            [uiExtensionsService, uiExtensionsService.getMenuItems],
            'xlrelease.DeliveryPatternPageMenu',
            delivery,
        );

        const sidebarMenu = deliveryPatternItems
            .filter(({ permitted }) => permitted)
            .map(({ pathSuffix, label, weight, icon = 'file' }) => ({
                pathSuffix: this.fixPath(`folders/${stateParams.folderId}/delivery-patterns/${delivery.id}/${pathSuffix}`),
                text: label,
                startIconId: icon,
                weight,
                selected: this.checkIfSelected(path, pathSuffix),
            }));

        yield put(setSidebarMenu({ sidebarMenu, withFolder: false }));
        yield put(
            setBackItem({
                pathSuffix: `folders/${stateParams.folderId}/delivery-patterns`,
                title: 'patterns',
                text: delivery.title,
            }),
        );
    }
}

registerSidebarProvider(new DeliveryPatternSidebarProvider());
