/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.plugins.jenkins;

import com.nimbusds.jose.JOSEObjectType;
import com.nimbusds.jose.JWSAlgorithm;
import com.nimbusds.jose.JWSHeader;
import com.nimbusds.jose.JWSSigner;
import com.nimbusds.jose.crypto.ECDSASigner;
import com.nimbusds.jose.crypto.RSASSASigner;
import com.nimbusds.jwt.JWTClaimsSet;
import com.nimbusds.jwt.SignedJWT;
import java.security.KeyFactory;
import java.security.PrivateKey;
import java.security.interfaces.ECPrivateKey;
import java.security.interfaces.RSAPrivateKey;
import java.security.spec.PKCS8EncodedKeySpec;
import java.util.Base64;
import java.util.Date;

public class JwtSigner {
    public static String signJwt(String algorithm, String privateKeyString, String privateKeyId, String audience, String issuer, String subject) throws Exception {
        RSASSASigner signer;
        JWSAlgorithm alg = JWSAlgorithm.parse((String)algorithm);
        String keyAlgorithm = alg.getName().startsWith("RS") || alg.getName().startsWith("PS") ? "RSA" : "EC";
        PrivateKey privateKey = JwtSigner.convertStringToPrivateKey(privateKeyString, keyAlgorithm);
        if (alg.getName().startsWith("RS") || alg.getName().startsWith("PS")) {
            signer = new RSASSASigner((PrivateKey)((RSAPrivateKey)privateKey));
        } else if (alg.getName().startsWith("ES")) {
            signer = new ECDSASigner((ECPrivateKey)privateKey);
        } else {
            throw new IllegalArgumentException("Unsupported algorithm: " + String.valueOf(alg));
        }
        JWTClaimsSet.Builder claimsBuilder = new JWTClaimsSet.Builder().issuer(issuer).subject(subject).audience(audience).issueTime(new Date()).expirationTime(new Date(System.currentTimeMillis() + 600000L)).claim("target_audience", (Object)audience);
        JWTClaimsSet claims = claimsBuilder.build();
        JWSHeader.Builder headerBuilder = new JWSHeader.Builder(alg).type(JOSEObjectType.JWT);
        if (privateKeyId != null) {
            headerBuilder.keyID(privateKeyId);
        }
        SignedJWT jwt = new SignedJWT(headerBuilder.build(), claims);
        jwt.sign((JWSSigner)signer);
        return jwt.serialize();
    }

    public static PrivateKey convertStringToPrivateKey(String privateKeyString, String algorithm) throws Exception {
        byte[] keyBytes;
        if (privateKeyString == null || privateKeyString.trim().isEmpty()) {
            throw new IllegalArgumentException("Private key string cannot be null or empty.");
        }
        privateKeyString = privateKeyString.replace("\\n", "\n").replace("\r\n", "\n").replace("\r", "\n").replace("-----BEGIN PRIVATE KEY-----", "").replace("-----END PRIVATE KEY-----", "").replaceAll("\\s", "");
        try {
            keyBytes = Base64.getDecoder().decode(privateKeyString);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("Invalid Base64 private key format.", e);
        }
        PKCS8EncodedKeySpec spec = new PKCS8EncodedKeySpec(keyBytes);
        KeyFactory keyFactory = KeyFactory.getInstance(algorithm);
        return keyFactory.generatePrivate(spec);
    }
}

