/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.configuration;

import com.google.common.base.Preconditions;
import com.xebialabs.deployit.plugin.api.udm.Metadata;
import com.xebialabs.deployit.plugin.api.udm.Property;
import com.xebialabs.xlrelease.domain.BaseSettings;

@Metadata(root=Metadata.ConfigurationItemRoot.CONFIGURATION, versioned=false, label="Task execution log purging", description="Release will use this setting to delete task execution logs that have been stored on the server. After deletion, task execution logs can no longer be visible or downloaded.")
public class ExecutionLogPurgeSettings
extends BaseSettings {
    public static final String EXECUTION_LOG_SETTINGS_ID = "Configuration/settings/ExecutionLogPurgeSettings";
    @Property(defaultValue="archive", hidden=true)
    private String displayIcon;
    @Property(defaultValue="tasks-settings", hidden=true)
    private String displayPage;
    @Property(defaultValue="how-to/configure-tasks", hidden=true)
    private String documentationPage;
    @Property(defaultValue="20", hidden=true)
    private Integer weight;
    @Property(defaultValue="10", required=false, label="Delete Task execution logs older than")
    private Integer executionLogsRetentionPeriod;

    public void validate() {
        Preconditions.checkArgument((this.executionLogsRetentionPeriod >= 0 ? 1 : 0) != 0, (Object)"Execution logs retention period must be greater than or equal to 0 days.");
        Preconditions.checkArgument((this.executionLogsRetentionPeriod <= 45 ? 1 : 0) != 0, (Object)"Execution logs retention period must be less than 45 days.");
    }

    public Integer getExecutionLogsRetentionPeriod() {
        return this.executionLogsRetentionPeriod;
    }

    public void setExecutionLogsRetentionPeriod(Integer executionLogsRetentionPeriod) {
        this.executionLogsRetentionPeriod = executionLogsRetentionPeriod;
    }
}

