/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.domain;

import com.xebialabs.xlplatform.documentation.PublicApiRef;
import com.xebialabs.xlplatform.documentation.ShowOnlyPublicApiMembers;
import java.util.Arrays;
import org.springframework.util.StringUtils;

@PublicApiRef
@ShowOnlyPublicApiMembers
public enum ReleaseKind {
    RELEASE("release"),
    WORKFLOW("workflow");

    private final String value;

    private ReleaseKind(String v) {
        this.value = v;
    }

    public String value() {
        return this.value;
    }

    public static ReleaseKind fromString(String kind) {
        try {
            if (StringUtils.hasText((String)kind)) {
                return ReleaseKind.valueOf(kind.toUpperCase());
            }
            throw new IllegalArgumentException("Kind value cannot be null or empty");
        }
        catch (IllegalArgumentException e) {
            String validKinds = Arrays.toString((Object[])ReleaseKind.values());
            throw new IllegalArgumentException("Invalid kind value: " + kind + ". Allowed values for the 'kind' parameter are: " + validKinds);
        }
    }
}

