/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.domain.group;

import com.xebialabs.xlplatform.documentation.PublicApiRef;
import com.xebialabs.xlplatform.documentation.ShowOnlyPublicApiMembers;
import com.xebialabs.xlrelease.domain.status.ReleaseStatus;

@PublicApiRef
@ShowOnlyPublicApiMembers
public enum ReleaseGroupStatus {
    PLANNED("planned"),
    IN_PROGRESS("in_progress"),
    PAUSED("paused"),
    FAILING("failing"),
    FAILED("failed"),
    COMPLETED("completed"),
    ABORTED("aborted");

    private final String value;
    public static final ReleaseGroupStatus[] INACTIVE_STATUSES;

    private ReleaseGroupStatus(String v) {
        this.value = v;
    }

    public String value() {
        return this.value;
    }

    public static ReleaseGroupStatus fromRelease(ReleaseStatus status) {
        if (status == ReleaseStatus.TEMPLATE) {
            return PLANNED;
        }
        return ReleaseGroupStatus.valueOf(status.name());
    }

    static {
        INACTIVE_STATUSES = new ReleaseGroupStatus[]{COMPLETED, ABORTED};
    }
}

