/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.risk.export;

import com.xebialabs.xlrelease.domain.Release;
import com.xebialabs.xlrelease.export.TemplateImportProcessor;
import com.xebialabs.xlrelease.risk.domain.RiskProfile;
import com.xebialabs.xlrelease.risk.service.RiskProfileService;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class RiskProfileImportProcessor
implements TemplateImportProcessor {
    private RiskProfileService riskProfileService;

    @Autowired
    public RiskProfileImportProcessor(RiskProfileService riskProfileService) {
        this.riskProfileService = riskProfileService;
    }

    public List<String> process(Release template, String destinationId) {
        ArrayList<String> warnings = new ArrayList<String>();
        if (!template.hasProperty("riskProfile")) {
            return warnings;
        }
        RiskProfile riskProfile = (RiskProfile)template.getProperty("riskProfile");
        if (null == riskProfile) {
            return warnings;
        }
        if (!this.riskProfileService.exists(riskProfile.getId())) {
            warnings.add("Associated Risk profile does not exist: Used \"Default risk profile\"");
            template.setProperty("riskProfile", (Object)this.riskProfileService.findById(RiskProfile.DEFAULT_RISK_PROFILE_ID));
        }
        return warnings;
    }
}

