/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.handler;

import com.xebialabs.xlrelease.builder.LogsFiltersBuilder;
import com.xebialabs.xlrelease.domain.ActivityLogEntry;
import com.xebialabs.xlrelease.handler.BaseActivityLogsApiHandler;
import com.xebialabs.xlrelease.repository.Ids;
import com.xebialabs.xlrelease.security.PermissionChecker;
import com.xebialabs.xlrelease.service.ReleaseActivityLogsService;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;
import scala.reflect.ScalaSignature;

@Component
@ScalaSignature(bytes="\u0006\u0005y3A!\u0002\u0004\u0001\u001f!IA\u0003\u0001B\u0001B\u0003%Qc\u0007\u0005\t;\u0001\u0011\t\u0011)A\u0005=!)A\u0005\u0001C\u0001K!)\u0001\b\u0001C!s\tQB+Y:l\u0003\u000e$\u0018N^5us2{wm]!qS\"\u000bg\u000e\u001a7fe*\u0011q\u0001C\u0001\bQ\u0006tG\r\\3s\u0015\tI!\"A\u0005yYJ,G.Z1tK*\u00111\u0002D\u0001\nq\u0016\u0014\u0017.\u00197bENT\u0011!D\u0001\u0004G>l7\u0001A\n\u0003\u0001A\u0001\"!\u0005\n\u000e\u0003\u0019I!a\u0005\u0004\u00035\t\u000b7/Z!di&4\u0018\u000e^=M_\u001e\u001c\u0018\t]5IC:$G.\u001a:\u00025I,G.Z1tK\u0006\u001bG/\u001b<jifdunZ:TKJ4\u0018nY3\u0011\u0005YIR\"A\f\u000b\u0005aA\u0011aB:feZL7-Z\u0005\u00035]\u0011!DU3mK\u0006\u001cX-Q2uSZLG/\u001f'pON\u001cVM\u001d<jG\u0016L!\u0001\b\n\u0002/\t\f7/Z!di&4\u0018\u000e^=M_\u001e\u001c8+\u001a:wS\u000e,\u0017a\u00039fe6L7o]5p]N\u0004\"a\b\u0012\u000e\u0003\u0001R!!\t\u0005\u0002\u0011M,7-\u001e:jifL!a\t\u0011\u0003#A+'/\\5tg&|gn\u00115fG.,'/\u0001\u0004=S:LGO\u0010\u000b\u0004M\u001dB\u0003CA\t\u0001\u0011\u0015!2\u00011\u0001\u0016\u0011\u0015i2\u00011\u0001\u001fQ\t\u0019!\u0006\u0005\u0002,m5\tAF\u0003\u0002.]\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\u000b\u0005=\u0002\u0014a\u00024bGR|'/\u001f\u0006\u0003cI\nQAY3b]NT!a\r\u001b\u0002\u001fM\u0004(/\u001b8hMJ\fW.Z<pe.T\u0011!N\u0001\u0004_J<\u0017BA\u001c-\u0005%\tU\u000f^8xSJ,G-A\bhKR\f5\r^5wSRLHj\\4t)\tQ\u0004\nE\u0002<\u0001\nk\u0011\u0001\u0010\u0006\u0003{y\nA!\u001e;jY*\tq(\u0001\u0003kCZ\f\u0017BA!=\u0005\u0011a\u0015n\u001d;\u0011\u0005\r3U\"\u0001#\u000b\u0005\u0015C\u0011A\u00023p[\u0006Lg.\u0003\u0002H\t\n\u0001\u0012i\u0019;jm&$\u0018\u0010T8h\u000b:$(/\u001f\u0005\u0006\u0013\u0012\u0001\rAS\u0001\u0007i\u0006\u001c8.\u00133\u0011\u0005-#fB\u0001'S!\ti\u0005+D\u0001O\u0015\tye\"\u0001\u0004=e>|GO\u0010\u0006\u0002#\u0006)1oY1mC&\u00111\u000bU\u0001\u0007!J,G-\u001a4\n\u0005U3&AB*ue&twM\u0003\u0002T!\"\u0012\u0001\u0001\u0017\t\u00033rk\u0011A\u0017\u0006\u00037J\n!b\u001d;fe\u0016|G/\u001f9f\u0013\ti&LA\u0005D_6\u0004xN\\3oi\u0002")
public class TaskActivityLogsApiHandler
extends BaseActivityLogsApiHandler {
    private final PermissionChecker permissions;

    @Override
    public List<ActivityLogEntry> getActivityLogs(String taskId) {
        String releaseId = Ids.releaseIdFrom((String)taskId);
        this.permissions.checkView(releaseId);
        return ((ReleaseActivityLogsService)super.baseActivityLogsService()).getFilteredLogs(releaseId, LogsFiltersBuilder.newLogsFilters().withTargetId(taskId).build(), Pageable.unpaged());
    }

    @Autowired
    public TaskActivityLogsApiHandler(ReleaseActivityLogsService releaseActivityLogsService, PermissionChecker permissions) {
        this.permissions = permissions;
        super(releaseActivityLogsService, "task");
    }
}

