/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.service;

import com.xebialabs.xlrelease.domain.ActivityLogEntry;
import com.xebialabs.xlrelease.repository.ActivityLogRepository;
import com.xebialabs.xlrelease.service.UserInfoResolver;
import com.xebialabs.xlrelease.views.LogsFilters;
import java.io.Serializable;
import java.util.Date;
import org.springframework.data.domain.Pageable;
import scala.Function1;
import scala.MatchError;
import scala.Tuple2;
import scala.collection.StrictOptimizedIterableOps;
import scala.collection.immutable.List;
import scala.jdk.CollectionConverters$;
import scala.math.Ordering;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0005\u0005Mc!B\t\u0013\u0003\u0003Y\u0002\u0002\u0003\u0012\u0001\u0005\u000b\u0007I\u0011A\u0012\t\u0011!\u0002!\u0011!Q\u0001\n\u0011B\u0001\"\u000b\u0001\u0003\u0006\u0004%\tA\u000b\u0005\tc\u0001\u0011\t\u0011)A\u0005W!)!\u0007\u0001C\u0001g!)q\u0007\u0001C\u0001q!)\u0011\u000b\u0001C\u0001%\")\u0001\r\u0001C\u0001C\")Q\r\u0001C\u0005M\")a\u000e\u0001C\u0005_\")!\u000f\u0001C\u0001g\"9\u0011Q\u0005\u0001\u0005\u0002\u0005\u001d\u0002bBA\u001a\u0001\u0019\u0005\u0011Q\u0007\u0005\b\u0003w\u0001a\u0011AA\u001f\u0011\u001d\t9\u0005\u0001C\u0001\u0003\u0013Bq!!\u0014\u0001\t\u0003\tyEA\fCCN,\u0017i\u0019;jm&$\u0018\u0010T8hgN+'O^5dK*\u00111\u0003F\u0001\bg\u0016\u0014h/[2f\u0015\t)b#A\u0005yYJ,G.Z1tK*\u0011q\u0003G\u0001\nq\u0016\u0014\u0017.\u00197bENT\u0011!G\u0001\u0004G>l7\u0001A\n\u0003\u0001q\u0001\"!\b\u0011\u000e\u0003yQ\u0011aH\u0001\u0006g\u000e\fG.Y\u0005\u0003Cy\u0011a!\u00118z%\u00164\u0017\u0001E;tKJLeNZ8SKN|GN^3s+\u0005!\u0003CA\u0013'\u001b\u0005\u0011\u0012BA\u0014\u0013\u0005A)6/\u001a:J]\u001a|'+Z:pYZ,'/A\tvg\u0016\u0014\u0018J\u001c4p%\u0016\u001cx\u000e\u001c<fe\u0002\nQ#Y2uSZLG/\u001f'pOJ+\u0007o\\:ji>\u0014\u00180F\u0001,!\tas&D\u0001.\u0015\tqC#\u0001\u0006sKB|7/\u001b;pefL!\u0001M\u0017\u0003+\u0005\u001bG/\u001b<jifdun\u001a*fa>\u001c\u0018\u000e^8ss\u00061\u0012m\u0019;jm&$\u0018\u0010T8h%\u0016\u0004xn]5u_JL\b%\u0001\u0004=S:LGO\u0010\u000b\u0004iU2\u0004CA\u0013\u0001\u0011\u0015\u0011S\u00011\u0001%\u0011\u0015IS\u00011\u0001,\u0003\u001di\u0017\r^2iKN$2!\u000f\u001fE!\ti\"(\u0003\u0002<=\t9!i\\8mK\u0006t\u0007\"B\u001f\u0007\u0001\u0004q\u0014\u0001\u00037pO\u0016sGO]=\u0011\u0005}\u0012U\"\u0001!\u000b\u0005\u0005#\u0012A\u00023p[\u0006Lg.\u0003\u0002D\u0001\n\u0001\u0012i\u0019;jm&$\u0018\u0010T8h\u000b:$(/\u001f\u0005\u0006\u000b\u001a\u0001\rAR\u0001\u0007M&dG/\u001a:\u0011\u0005\u001dseB\u0001%M!\tIe$D\u0001K\u0015\tY%$\u0001\u0004=e>|GOP\u0005\u0003\u001bz\ta\u0001\u0015:fI\u00164\u0017BA(Q\u0005\u0019\u0019FO]5oO*\u0011QJH\u0001\bE\u0016$x/Z3o)\u0011I4\u000b\u00160\t\u000bu:\u0001\u0019\u0001 \t\u000bU;\u0001\u0019\u0001,\u0002\t\u0019\u0014x.\u001c\t\u0003/rk\u0011\u0001\u0017\u0006\u00033j\u000bA!\u001e;jY*\t1,\u0001\u0003kCZ\f\u0017BA/Y\u0005\u0011!\u0015\r^3\t\u000b};\u0001\u0019\u0001,\u0002\u0005Q|\u0017\u0001D<ji\"$\u0016M]4fi&#GcA\u001dcG\")Q\b\u0003a\u0001}!)A\r\u0003a\u0001\r\u0006AA/\u0019:hKRLE-\u0001\u0005d_:$\u0018-\u001b8t)\rIt-\u001b\u0005\u0006Q&\u0001\rAR\u0001\u0006S:\u0004X\u000f\u001e\u0005\u0006U&\u0001\ra[\u0001\bM&dG/\u001a:t!\r9FNR\u0005\u0003[b\u0013A\u0001T5ti\u0006\u00012m\u001c8uC&t7/V:fe:\fW.\u001a\u000b\u0004sA\f\b\"\u00025\u000b\u0001\u00041\u0005\"\u00026\u000b\u0001\u0004Y\u0017A\u00034jYR,'\u000fT8hgR)A\u000f @\u0002\fA\u0019QO\u001f \u000f\u0005YDhBA%x\u0013\u0005y\u0012BA=\u001f\u0003\u001d\u0001\u0018mY6bO\u0016L!!\\>\u000b\u0005et\u0002\"B?\f\u0001\u0004!\u0018\u0001D1di&4\u0018\u000e^=M_\u001e\u001c\b\"\u00026\f\u0001\u0004y\b\u0003BA\u0001\u0003\u000fi!!a\u0001\u000b\u0007\u0005\u0015A#A\u0003wS\u0016<8/\u0003\u0003\u0002\n\u0005\r!a\u0003'pON4\u0015\u000e\u001c;feNDq!!\u0004\f\u0001\u0004\ty!\u0001\u0005qC\u001e,\u0017M\u00197f!\u0011\t\t\"!\t\u000e\u0005\u0005M!bA!\u0002\u0016)!\u0011qCA\r\u0003\u0011!\u0017\r^1\u000b\t\u0005m\u0011QD\u0001\u0010gB\u0014\u0018N\\4ge\u0006lWm^8sW*\u0011\u0011qD\u0001\u0004_J<\u0017\u0002BA\u0012\u0003'\u0011\u0001\u0002U1hK\u0006\u0014G.Z\u0001\u0010O\u0016$h)\u001b7uKJ,G\rT8hgRA\u0011\u0011FA\u0016\u0003_\t\t\u0004E\u0002XYzBa!!\f\r\u0001\u00041\u0015aC2p]R\f\u0017N\\3s\u0013\u0012DQA\u001b\u0007A\u0002}Dq!!\u0004\r\u0001\u0004\ty!\u0001\bxSRD7)\u0019;fO>\u0014\u0018.Z:\u0015\u000be\n9$!\u000f\t\u000buj\u0001\u0019\u0001 \t\u000b)l\u0001\u0019A@\u0002\u0013\u0019,Go\u00195M_\u001e\u001cHc\u0002;\u0002@\u0005\u0005\u0013Q\t\u0005\u0007\u0003[q\u0001\u0019\u0001$\t\r\u0005\rc\u00021\u0001\u0000\u0003-awnZ:GS2$XM]:\t\u000f\u00055a\u00021\u0001\u0002\u0010\u0005qq-\u001a;V]&\fX/Z+tKJ\u001cHcA6\u0002L!1\u0011QF\bA\u0002\u0019\u000bacZ3u+:L\u0017/^3BGRLg/\u001b;z)f\u0004Xm\u001d\u000b\u0004W\u0006E\u0003BBA\u0017!\u0001\u0007a\t")
public abstract class BaseActivityLogsService {
    private final UserInfoResolver userInfoResolver;
    private final ActivityLogRepository activityLogRepository;

    public UserInfoResolver userInfoResolver() {
        return this.userInfoResolver;
    }

    public ActivityLogRepository activityLogRepository() {
        return this.activityLogRepository;
    }

    public boolean matches(ActivityLogEntry logEntry, String filter) {
        return filter == null || BaseActivityLogsService.matches$1(logEntry.getMessage(), filter) || BaseActivityLogsService.matches$1(logEntry.getUsername(), filter) || BaseActivityLogsService.matches$1(logEntry.getTargetId(), filter) || BaseActivityLogsService.matches$1(this.userInfoResolver().getFullNameOf(logEntry.getUsername()), filter);
    }

    public boolean between(ActivityLogEntry logEntry, Date from, Date to) {
        boolean predicate = false;
        predicate = from == null && to == null ? true : (from == null ? logEntry.getEventTime().before(to) || logEntry.getEventTime().equals(to) : (to == null ? logEntry.getEventTime().after(from) || logEntry.getEventTime().equals(from) : !(!logEntry.getEventTime().after(from) && !logEntry.getEventTime().equals(from) || !logEntry.getEventTime().before(to) && !logEntry.getEventTime().equals(to))));
        return predicate;
    }

    public boolean withTargetId(ActivityLogEntry logEntry, String targetId) {
        boolean predicate = false;
        if (targetId == null) {
            predicate = true;
        } else {
            String string = logEntry.getTargetId();
            String string2 = targetId;
            predicate = !(string != null ? !string.equals(string2) : string2 != null);
        }
        return predicate;
    }

    private boolean contains(String input, java.util.List<String> filters) {
        boolean predicate;
        block0: {
            predicate = true;
            if (filters.size() <= 0) break block0;
            predicate = filters.contains(input);
        }
        return predicate;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean containsUsername(String input, java.util.List<String> filters) {
        boolean predicate = true;
        if (filters.size() <= 0) return predicate;
        if (!filters.contains("SYSTEM")) return filters.contains(input);
        if (input == null) return true;
        String string = input;
        String string2 = "SYSTEM";
        if (string == null) {
            if (string2 == null) return true;
        } else if (string.equals(string2)) return true;
        if (!filters.contains(input)) return false;
        return true;
    }

    public List<ActivityLogEntry> filterLogs(List<ActivityLogEntry> activityLogs, LogsFilters filters, Pageable pageable) {
        Ordering sortOrder = filters.isDateAsc() ? package$.MODULE$.Ordering().comparatorToOrdering(ActivityLogEntry.BY_EVENT_TIME) : package$.MODULE$.Ordering().comparatorToOrdering(ActivityLogEntry.BY_EVENT_TIME).reverse();
        return ((List)((StrictOptimizedIterableOps)activityLogs.filter((Function1 & Serializable)logEntry -> BoxesRunTime.boxToBoolean((boolean)this.matches(logEntry, filters.getFilter()))).filter((Function1 & Serializable)logEntry -> BoxesRunTime.boxToBoolean((boolean)this.between(logEntry, filters.getFrom(), filters.getTo()))).filter((Function1 & Serializable)logEntry -> BoxesRunTime.boxToBoolean((boolean)this.withCategories(logEntry, filters))).filter((Function1 & Serializable)logEntry -> BoxesRunTime.boxToBoolean((boolean)this.withTargetId(logEntry, filters.getTargetId()))).filter((Function1 & Serializable)logEntry -> BoxesRunTime.boxToBoolean((boolean)this.containsUsername(logEntry.getUsername(), filters.getUsernames()))).filter((Function1 & Serializable)logEntry -> BoxesRunTime.boxToBoolean((boolean)this.contains(logEntry.getActivityType(), filters.getActivityTypes()))).sorted(sortOrder)).zipWithIndex()).filter((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)BaseActivityLogsService.$anonfun$filterLogs$7(pageable, x0$1))).map((Function1 & Serializable)x$1 -> (ActivityLogEntry)x$1._1());
    }

    public java.util.List<ActivityLogEntry> getFilteredLogs(String containerId, LogsFilters filters, Pageable pageable) {
        return CollectionConverters$.MODULE$.SeqHasAsJava(this.fetchLogs(containerId, filters, pageable)).asJava();
    }

    public abstract boolean withCategories(ActivityLogEntry var1, LogsFilters var2);

    public abstract List<ActivityLogEntry> fetchLogs(String var1, LogsFilters var2, Pageable var3);

    public java.util.List<String> getUniqueUsers(String containerId) {
        return this.activityLogRepository().findUniqueUsers(containerId);
    }

    public java.util.List<String> getUniqueActivityTypes(String containerId) {
        return this.activityLogRepository().findUniqueActivityTypes(containerId);
    }

    private static final boolean matches$1(String text, String filter$1) {
        return text != null && text.toLowerCase().contains(filter$1.toLowerCase());
    }

    public static final /* synthetic */ boolean $anonfun$filterLogs$7(Pageable pageable$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            int index = tuple2._2$mcI$sp();
            return pageable$1.isUnpaged() || (long)index >= pageable$1.getOffset() && (long)index < pageable$1.getOffset() + (long)pageable$1.getPageSize();
        }
        throw new MatchError((Object)tuple2);
    }

    public BaseActivityLogsService(UserInfoResolver userInfoResolver, ActivityLogRepository activityLogRepository) {
        this.userInfoResolver = userInfoResolver;
        this.activityLogRepository = activityLogRepository;
    }
}

