/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.extension.quartz;

import com.typesafe.config.Config;
import com.typesafe.config.ConfigException;
import com.typesafe.config.ConfigObject;
import com.typesafe.config.ConfigValue;
import java.io.Serializable;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import org.quartz.CronExpression;
import org.quartz.impl.calendar.AnnualCalendar;
import org.quartz.impl.calendar.BaseCalendar;
import org.quartz.impl.calendar.CronCalendar;
import org.quartz.impl.calendar.DailyCalendar;
import org.quartz.impl.calendar.HolidayCalendar;
import org.quartz.impl.calendar.MonthlyCalendar;
import org.quartz.impl.calendar.WeeklyCalendar;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.JavaConverters$;
import scala.collection.StringOps$;
import scala.collection.immutable.Map$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.Buffer;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;
import scala.util.control.Exception;
import scala.util.control.Exception$;

public final class QuartzCalendars$ {
    public static final QuartzCalendars$ MODULE$ = new QuartzCalendars$();
    private static final Exception.Catch<Nothing$> catchMissing = Exception$.MODULE$.catching((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Class[]{ConfigException.Missing.class}));
    private static final Exception.Catch<Nothing$> catchWrongType = Exception$.MODULE$.catching((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Class[]{ConfigException.WrongType.class}));
    private static final Exception.Catch<Nothing$> catchParseErr = Exception$.MODULE$.catching((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Class[]{ParseException.class}));

    public Exception.Catch<Nothing$> catchMissing() {
        return catchMissing;
    }

    public Exception.Catch<Nothing$> catchWrongType() {
        return catchWrongType;
    }

    public Exception.Catch<Nothing$> catchParseErr() {
        return catchParseErr;
    }

    public scala.collection.immutable.Map<String, org.quartz.Calendar> apply(Config config, TimeZone defaultTimezone) {
        return (scala.collection.immutable.Map)this.catchMissing().opt((Function0 & Serializable)() -> (scala.collection.immutable.Map)((IterableOnceOps)JavaConverters$.MODULE$.mapAsScalaMapConverter((Map)config.getConfig("calendars").root()).asScala()).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()).flatMap((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                String key = (String)tuple2._1();
                ConfigValue value = (ConfigValue)tuple2._2();
                if (value instanceof ConfigObject) {
                    ConfigObject configObject = (ConfigObject)value;
                    return new Some((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)key), (Object)MODULE$.parseCalendar(key, configObject.toConfig(), defaultTimezone)));
                }
            }
            return None$.MODULE$;
        })).getOrElse((Function0 & Serializable)() -> Map$.MODULE$.empty());
    }

    public Calendar parseFmt(String raw, SimpleDateFormat fmt, TimeZone tz) {
        Calendar c = Calendar.getInstance(tz);
        c.setTime(fmt.parse(raw));
        return c;
    }

    public AnnualCalendar parseAnnualCalendar(String name, Config config, TimeZone tz) {
        SimpleDateFormat dateFmt = new SimpleDateFormat("MM-dd");
        dateFmt.setTimeZone(tz);
        Either either = this.catchMissing().or(this.catchWrongType()).either((Function0 & Serializable)() -> config.getStringList("excludeDates"));
        if (either instanceof Left) {
            Left left = (Left)either;
            Throwable t = (Throwable)left.value();
            throw new IllegalArgumentException(StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("Invalid or Missing Configuration entry 'excludeDates' for Annual calendar '%s'. You must provide a list of ISO-8601 compliant dates ('YYYY-MM-DD')."), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{name})), t);
        }
        if (!(either instanceof Right)) {
            throw new MatchError((Object)either);
        }
        Right right = (Right)either;
        List dates = (List)right.value();
        Buffer excludeDates = (Buffer)((IterableOps)JavaConverters$.MODULE$.asScalaBufferConverter(dates).asScala()).map((Function1 & Serializable)d -> {
            Either either = MODULE$.catchParseErr().either((Function0 & Serializable)() -> MODULE$.parseFmt((String)d, dateFmt, tz));
            if (either instanceof Left) {
                Left left = (Left)either;
                Throwable t = (Throwable)left.value();
                throw new IllegalArgumentException(StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("Invalid date '%s' in Annual Calendar '%s' - 'excludeDates'. You must provide an ISO-8601 compliant date ('YYYY-MM-DD')."), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{d, name})), t);
            }
            if (either instanceof Right) {
                Right right = (Right)either;
                Calendar dt = (Calendar)right.value();
                return dt;
            }
            throw new MatchError((Object)either);
        });
        AnnualCalendar cal = new AnnualCalendar();
        cal.setDaysExcluded(new ArrayList((Collection)JavaConverters$.MODULE$.bufferAsJavaListConverter(excludeDates).asJava()));
        return cal;
    }

    public HolidayCalendar parseHolidayCalendar(String name, Config config, TimeZone tz) {
        SimpleDateFormat dateFmt = new SimpleDateFormat("yyyy-MM-dd");
        dateFmt.setTimeZone(tz);
        Either either = this.catchMissing().or(this.catchWrongType()).either((Function0 & Serializable)() -> config.getStringList("excludeDates"));
        if (either instanceof Left) {
            Left left = (Left)either;
            Throwable t = (Throwable)left.value();
            throw new IllegalArgumentException(StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("Invalid or Missing Configuration entry 'excludeDates' for Holiday Calendar '%s'. You must provide a list of ISO-8601 compliant dates ('YYYY-MM-DD')."), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{name})), t);
        }
        if (!(either instanceof Right)) {
            throw new MatchError((Object)either);
        }
        Right right = (Right)either;
        List dates = (List)right.value();
        Buffer excludeDates = (Buffer)((IterableOps)JavaConverters$.MODULE$.asScalaBufferConverter(dates).asScala()).map((Function1 & Serializable)d -> {
            Either either = MODULE$.catchParseErr().either((Function0 & Serializable)() -> MODULE$.parseFmt((String)d, dateFmt, tz).getTime());
            if (either instanceof Left) {
                Left left = (Left)either;
                Throwable t = (Throwable)left.value();
                throw new IllegalArgumentException(StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("Invalid date '%s' in Holiday Calendar '%s' - 'excludeDates'. You must provide an ISO-8601 compliant date ('YYYY-MM-DD')."), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{d, name})), t);
            }
            if (either instanceof Right) {
                Right right = (Right)either;
                Date dt = (Date)right.value();
                return dt;
            }
            throw new MatchError((Object)either);
        });
        HolidayCalendar cal = new HolidayCalendar();
        excludeDates.foreach((Function1 & Serializable)x$1 -> {
            cal.addExcludedDate(x$1);
            return BoxedUnit.UNIT;
        });
        return cal;
    }

    public DailyCalendar parseDailyCalendar(String name, Config config) {
        String startTime = this.parseTimeEntry$1("exclude.startTime", config, name);
        String endTime = this.parseTimeEntry$1("exclude.endTime", config, name);
        return new DailyCalendar(startTime, endTime);
    }

    public WeeklyCalendar parseWeeklyCalendar(String name, Config config) {
        WeeklyCalendar cal;
        block3: {
            Either either = this.catchMissing().or(this.catchWrongType()).either((Function0 & Serializable)() -> config.getIntList("excludeDays"));
            if (either instanceof Left) {
                Left left = (Left)either;
                Throwable t = (Throwable)left.value();
                throw new IllegalArgumentException(StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("Invalid or Missing Configuration entry 'excludeDays' for Weekly Calendar '%s'. You must provide a list of Integers between 1 and 7."), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{name})), t);
            }
            if (!(either instanceof Right)) {
                throw new MatchError((Object)either);
            }
            Right right = (Right)either;
            List days = (List)right.value();
            Buffer excludeDays = (Buffer)JavaConverters$.MODULE$.asScalaBufferConverter(days).asScala();
            boolean excludeWeekends = BoxesRunTime.unboxToBoolean((Object)this.catchMissing().opt((Function0)(JFunction0.mcZ.sp & Serializable)() -> config.getBoolean("excludeWeekends")).getOrElse((Function0)(JFunction0.mcZ.sp & Serializable)() -> true));
            Predef$.MODULE$.require(excludeDays.forall((Function1 & Serializable)d -> BoxesRunTime.boxToBoolean((boolean)QuartzCalendars$.$anonfun$parseWeeklyCalendar$4(d))), (Function0 & Serializable)() -> StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("Weekly Calendar '%s' - 'excludeDays' must consist of a list of Integers between 1 and 7"), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{name})));
            cal = new WeeklyCalendar();
            excludeDays.foreach((Function1 & Serializable)x$1 -> {
                cal.setDayExcluded(Predef$.MODULE$.Integer2int(x$1), true);
                return BoxedUnit.UNIT;
            });
            if (excludeWeekends) break block3;
            if (excludeDays.contains((Object)BoxesRunTime.boxToInteger((int)7)) || excludeDays.contains((Object)BoxesRunTime.boxToInteger((int)1))) {
                throw new IllegalArgumentException(StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("Weekly Calendar '%s' - Cannot set 'excludeWeekends' to false when you have explicitly excluded Saturday (7) or Sunday (1)"), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{name})));
            }
            cal.setDayExcluded(1, false);
            cal.setDayExcluded(7, false);
        }
        return cal;
    }

    public MonthlyCalendar parseMonthlyCalendar(String name, Config config) {
        Either either = this.catchMissing().or(this.catchWrongType()).either((Function0 & Serializable)() -> config.getIntList("excludeDays"));
        if (either instanceof Left) {
            Left left = (Left)either;
            Throwable t = (Throwable)left.value();
            throw new IllegalArgumentException(StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("Invalid or Missing Configuration entry 'excludeDays' for Monthly Calendar '%s'. You must provide a list of Integers between 1 and 31."), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{name})), t);
        }
        if (!(either instanceof Right)) {
            throw new MatchError((Object)either);
        }
        Right right = (Right)either;
        List days = (List)right.value();
        Buffer excludeDays = (Buffer)JavaConverters$.MODULE$.asScalaBufferConverter(days).asScala();
        Predef$.MODULE$.require(excludeDays.forall((Function1 & Serializable)d -> BoxesRunTime.boxToBoolean((boolean)QuartzCalendars$.$anonfun$parseMonthlyCalendar$2(d))), (Function0 & Serializable)() -> StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("Monthly Calendar '%s' - 'excludeDays' must consist of a list of Integers between 1 and 31"), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{name})));
        MonthlyCalendar cal = new MonthlyCalendar();
        excludeDays.foreach((Function1 & Serializable)x$2 -> {
            cal.setDayExcluded(Predef$.MODULE$.Integer2int(x$2), true);
            return BoxedUnit.UNIT;
        });
        return cal;
    }

    public CronCalendar parseCronCalendar(String name, Config config) {
        String expr;
        Either either = this.catchMissing().or(this.catchWrongType()).either((Function0 & Serializable)() -> config.getString("excludeExpression"));
        if (either instanceof Left) {
            Left left = (Left)either;
            Throwable t = (Throwable)left.value();
            throw new IllegalArgumentException(StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("Invalid or Missing Configuration entry 'excludeExpression' for Cron Calendar '%s'. You must provide a valid Quartz CronExpression."), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{name})), t);
        }
        if (either instanceof Right) {
            Right right = (Right)either;
            expr = (String)right.value();
            Either either2 = this.catchParseErr().either((Function0)(JFunction0.mcV.sp & Serializable)() -> CronExpression.validateExpression((String)expr));
            if (either2 instanceof Left) {
                Left left = (Left)either2;
                Throwable t = (Throwable)left.value();
                throw new IllegalArgumentException(StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("Invalid 'excludeExpression' for Cron Calendar '%s'. Failed to validate CronExpression."), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{name})), t);
            }
            if (!(either2 instanceof Right)) {
                throw new MatchError((Object)either2);
            }
        } else {
            throw new MatchError((Object)either);
        }
        String exclude = expr;
        CronCalendar cal = new CronCalendar(exclude);
        return cal;
    }

    public org.quartz.Calendar parseCalendar(String name, Config config, TimeZone defaultTimezone) {
        Either either;
        block9: {
            WeeklyCalendar weeklyCalendar;
            Option description;
            TimeZone timezone;
            block10: {
                timezone = (TimeZone)this.catchMissing().opt((Function0 & Serializable)() -> TimeZone.getTimeZone(config.getString("timezone"))).getOrElse((Function0 & Serializable)() -> defaultTimezone);
                description = this.catchMissing().opt((Function0 & Serializable)() -> config.getString("description"));
                either = this.catchMissing().either((Function0 & Serializable)() -> config.getString("type"));
                if (either instanceof Left) {
                    throw new IllegalArgumentException(new StringBuilder(34).append("Calendar Type must be defined for ").append(name).toString());
                }
                if (!(either instanceof Right)) break block9;
                Right right = (Right)either;
                String typ = (String)right.value();
                String string = typ.toUpperCase();
                switch (string == null ? 0 : string.hashCode()) {
                    case -1738378111: {
                        if (!"WEEKLY".equals(string)) break;
                        weeklyCalendar = this.parseWeeklyCalendar(name, config);
                        break block10;
                    }
                    case 2077326: {
                        if (!"CRON".equals(string)) break;
                        weeklyCalendar = this.parseCronCalendar(name, config);
                        break block10;
                    }
                    case 64808441: {
                        if (!"DAILY".equals(string)) break;
                        weeklyCalendar = this.parseDailyCalendar(name, config);
                        break block10;
                    }
                    case 1809888312: {
                        if (!"HOLIDAY".equals(string)) break;
                        weeklyCalendar = this.parseHolidayCalendar(name, config, timezone);
                        break block10;
                    }
                    case 1935336927: {
                        if (!"ANNUAL".equals(string)) break;
                        weeklyCalendar = this.parseAnnualCalendar(name, config, timezone);
                        break block10;
                    }
                    case 1954618349: {
                        if (!"MONTHLY".equals(string)) break;
                        weeklyCalendar = this.parseMonthlyCalendar(name, config);
                        break block10;
                    }
                }
                throw new IllegalArgumentException(StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("Unknown Quartz Calendar type '%s' for calendar '%s'. Valid types are Annual, Holiday, Daily, Monthly, Weekly, and Cron."), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{string, name})));
            }
            WeeklyCalendar cal = weeklyCalendar;
            description.foreach(arg_0 -> QuartzCalendars$.$anonfun$parseCalendar$5$adapted((BaseCalendar)cal, arg_0));
            cal.setTimeZone(timezone);
            return cal;
        }
        throw new MatchError((Object)either);
    }

    private final String parseTimeEntry$1(String entry, Config config$4, String name$3) {
        Either either = this.catchMissing().or(this.catchWrongType()).either((Function0 & Serializable)() -> config$4.getString(entry));
        if (either instanceof Left) {
            Left left = (Left)either;
            Throwable t = (Throwable)left.value();
            throw new IllegalArgumentException(StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("Invalid or Missing Configuration entry '%s' for Daily Calendar '%s'. You must provide a time in the format 'HH:MM[:SS[:mmm]]'"), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{entry, name$3})), t);
        }
        if (either instanceof Right) {
            Right right = (Right)either;
            String rawTime = (String)right.value();
            return rawTime;
        }
        throw new MatchError((Object)either);
    }

    public static final /* synthetic */ boolean $anonfun$parseWeeklyCalendar$4(Integer d) {
        return Predef$.MODULE$.Integer2int(d) <= 7 && Predef$.MODULE$.Integer2int(d) >= 1;
    }

    public static final /* synthetic */ boolean $anonfun$parseMonthlyCalendar$2(Integer d) {
        return Predef$.MODULE$.Integer2int(d) <= 31 && Predef$.MODULE$.Integer2int(d) >= 1;
    }

    private QuartzCalendars$() {
    }

    public static final /* synthetic */ Object $anonfun$parseCalendar$5$adapted(BaseCalendar cal$4, String x$1) {
        cal$4.setDescription(x$1);
        return BoxedUnit.UNIT;
    }
}

