/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.cluster.typed.internal.receptionist;

import java.io.Serializable;
import org.apache.pekko.actor.typed.ActorRef;
import org.apache.pekko.actor.typed.Behavior;
import org.apache.pekko.actor.typed.internal.BehaviorImpl;
import org.apache.pekko.actor.typed.internal.TimerSchedulerImpl$;
import org.apache.pekko.actor.typed.internal.adapter.ActorRefAdapter$;
import org.apache.pekko.actor.typed.internal.receptionist.AbstractServiceKey;
import org.apache.pekko.actor.typed.internal.receptionist.ReceptionistBehaviorProvider;
import org.apache.pekko.actor.typed.internal.receptionist.ReceptionistMessages;
import org.apache.pekko.actor.typed.receptionist.Receptionist;
import org.apache.pekko.actor.typed.receptionist.ServiceKey;
import org.apache.pekko.actor.typed.scaladsl.ActorContext;
import org.apache.pekko.actor.typed.scaladsl.Behaviors;
import org.apache.pekko.actor.typed.scaladsl.Behaviors$;
import org.apache.pekko.actor.typed.scaladsl.package;
import org.apache.pekko.actor.typed.scaladsl.package$;
import org.apache.pekko.annotation.InternalApi;
import org.apache.pekko.cluster.ClusterEvent;
import org.apache.pekko.cluster.Member;
import org.apache.pekko.cluster.UniqueAddress;
import org.apache.pekko.cluster.ddata.Key;
import org.apache.pekko.cluster.ddata.ORMultiMap;
import org.apache.pekko.cluster.ddata.ORMultiMap$;
import org.apache.pekko.cluster.ddata.ORMultiMapKey;
import org.apache.pekko.cluster.ddata.Replicator;
import org.apache.pekko.cluster.typed.internal.receptionist.ClusterReceptionist;
import org.apache.pekko.cluster.typed.internal.receptionist.ClusterReceptionist$PruneTombstonesTick$;
import org.apache.pekko.cluster.typed.internal.receptionist.ClusterReceptionist$RemoveTick$;
import org.apache.pekko.cluster.typed.internal.receptionist.ServiceRegistry;
import org.apache.pekko.cluster.typed.internal.receptionist.ServiceRegistry$;
import org.apache.pekko.cluster.typed.internal.receptionist.ShardedServiceRegistry;
import org.apache.pekko.cluster.typed.internal.receptionist.ShardedServiceRegistry$;
import org.apache.pekko.util.TypedMultiMap;
import org.apache.pekko.util.TypedMultiMap$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.concurrent.duration.Deadline;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@InternalApi
public final class ClusterReceptionist$
implements ReceptionistBehaviorProvider {
    public static final ClusterReceptionist$ MODULE$ = new ClusterReceptionist$();
    private static final ORMultiMap<ServiceKey<?>, ClusterReceptionist.Entry> EmptyORMultiMap = ORMultiMap$.MODULE$._empty();
    private static final String name = "clusterReceptionist";

    public final ORMultiMap<ServiceKey<?>, ClusterReceptionist.Entry> EmptyORMultiMap() {
        return EmptyORMultiMap;
    }

    public String name() {
        return name;
    }

    public Behavior<Receptionist.Command> behavior() {
        Function1 & Serializable setup_factory = (Function1 & Serializable)ctx -> {
            ctx.setLoggerName(ClusterReceptionist.class);
            Function1 & Serializable withTimers_factory = (Function1 & Serializable)timers -> {
                ClusterReceptionist.Setup setup = new ClusterReceptionist.Setup((ActorContext<Receptionist.Command>)ctx);
                ShardedServiceRegistry initialRegistry = ShardedServiceRegistry$.MODULE$.apply(setup.settings().distributedKeyCount()).addNode(setup.selfUniqueAddress());
                ActorRef replicatorMessageAdapter = ctx.messageAdapter((Function1 & Serializable)x0$1 -> {
                    if (x0$1 instanceof Replicator.Changed) {
                        Replicator.Changed changed = (Replicator.Changed)x0$1;
                        return new ClusterReceptionist.ChangeFromReplicator((ORMultiMapKey)changed.key(), (ORMultiMap)changed.dataValue());
                    }
                    throw new IllegalArgumentException();
                }, ClassTag$.MODULE$.apply(Replicator.ReplicatorMessage.class));
                initialRegistry.allDdataKeys().foreach((Function1 & Serializable)key -> {
                    ClusterReceptionist$.$anonfun$behavior$4(replicatorMessageAdapter, setup, key);
                    return BoxedUnit.UNIT;
                });
                ActorRef clusterEventMessageAdapter = ctx.messageAdapter((Function1 & Serializable)x0$2 -> {
                    if (x0$2 instanceof ClusterEvent.MemberJoined) {
                        Member member = ((ClusterEvent.MemberJoined)x0$2).member();
                        return new ClusterReceptionist.NodeAdded(member.uniqueAddress());
                    }
                    if (x0$2 instanceof ClusterEvent.MemberWeaklyUp) {
                        Member member = ((ClusterEvent.MemberWeaklyUp)x0$2).member();
                        return new ClusterReceptionist.NodeAdded(member.uniqueAddress());
                    }
                    if (x0$2 instanceof ClusterEvent.MemberUp) {
                        Member member = ((ClusterEvent.MemberUp)x0$2).member();
                        return new ClusterReceptionist.NodeAdded(member.uniqueAddress());
                    }
                    if (x0$2 instanceof ClusterEvent.MemberRemoved) {
                        Member member = ((ClusterEvent.MemberRemoved)x0$2).member();
                        return new ClusterReceptionist.NodeRemoved(member.uniqueAddress());
                    }
                    if (x0$2 instanceof ClusterEvent.UnreachableMember) {
                        Member member = ((ClusterEvent.UnreachableMember)x0$2).member();
                        return new ClusterReceptionist.NodeUnreachable(member.uniqueAddress());
                    }
                    if (x0$2 instanceof ClusterEvent.ReachableMember) {
                        Member member = ((ClusterEvent.ReachableMember)x0$2).member();
                        return new ClusterReceptionist.NodeReachable(member.uniqueAddress());
                    }
                    if (ClusterEvent.ClusterShuttingDown$.MODULE$.equals(x0$2)) {
                        return new ClusterReceptionist.NodeRemoved(setup.cluster().selfUniqueAddress());
                    }
                    throw new IllegalStateException(new StringBuilder(50).append("Unexpected ClusterDomainEvent ").append(x0$2).append(". Please report bug.").toString());
                }, ClassTag$.MODULE$.apply(ClusterEvent.ClusterDomainEvent.class));
                setup.cluster().subscribe((org.apache.pekko.actor.ActorRef)ActorRefAdapter$.MODULE$.toClassic(clusterEventMessageAdapter), (ClusterEvent.SubscriptionInitialStateMode)ClusterEvent.InitialStateAsEvents$.MODULE$, (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Class[]{ClusterEvent.MemberJoined.class, ClusterEvent.MemberWeaklyUp.class, ClusterEvent.MemberUp.class, ClusterEvent.MemberRemoved.class, ClusterEvent.ReachabilityEvent.class, ClusterEvent.ClusterShuttingDown$.MODULE$.getClass()}));
                timers.startTimerWithFixedDelay((Object)ClusterReceptionist$RemoveTick$.MODULE$, setup.settings().pruningInterval());
                timers.startTimerWithFixedDelay((Object)ClusterReceptionist$PruneTombstonesTick$.MODULE$, setup.keepTombstonesFor().$div(24L));
                ClusterReceptionist.State initialState = new ClusterReceptionist.State(initialRegistry, Predef$.MODULE$.Map().empty(), Predef$.MODULE$.Map().empty(), (TypedMultiMap<AbstractServiceKey, ActorRef>)TypedMultiMap$.MODULE$.empty());
                return MODULE$.behavior(setup, initialState);
            };
            Function1 & Serializable withTimers_withTimers_setup_factory = arg_0 -> TimerSchedulerImpl$.$anonfun$withTimers$1((Function1)withTimers_factory, arg_0);
            return new /* Unavailable Anonymous Inner Class!! */;
        };
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    public Behavior<Receptionist.Command> behavior(ClusterReceptionist.Setup setup, ClusterReceptionist.State state) {
        Function1 & Serializable setup_factory = (Function1 & Serializable)ctx -> {
            Function2 & Serializable receive_onMessage = (Function2 & Serializable)(x$7, msg) -> {
                if (msg instanceof ClusterReceptionist.InternalCommand) {
                    return ClusterReceptionist$.onInternalCommand$1((ClusterReceptionist.InternalCommand)msg, setup, state, ctx);
                }
                if (msg != null) {
                    return ClusterReceptionist$.onCommand$1(msg, setup, ctx, state);
                }
                return BehaviorImpl.UnhandledBehavior$.MODULE$;
            };
            return new Behaviors.ReceiveImpl((Function2)receive_onMessage);
        };
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    public static final /* synthetic */ void $anonfun$behavior$4(ActorRef replicatorMessageAdapter$1, ClusterReceptionist.Setup setup$1, ORMultiMapKey key) {
        Replicator.Subscribe x$1 = new Replicator.Subscribe((Key)key, (org.apache.pekko.actor.ActorRef)ActorRefAdapter$.MODULE$.toClassic(replicatorMessageAdapter$1));
        org.apache.pekko.actor.ActorRef x$2 = setup$1.replicator().$bang$default$2((Object)x$1);
        setup$1.replicator().$bang((Object)x$1, x$2);
    }

    private static final boolean isLeader$1(ClusterReceptionist.Setup setup$2) {
        return setup$2.cluster().state().leader().contains((Object)setup$2.cluster().selfAddress());
    }

    private static final boolean isOnRemovedNode$1(ClusterReceptionist.Entry entry, Set addresses$1, ClusterReceptionist.Setup setup$2) {
        return addresses$1.apply((Object)entry.uniqueAddress(setup$2.selfUniqueAddress().address()));
    }

    private static final boolean isOld$1(ClusterReceptionist.Entry entry, long now$1, ClusterReceptionist.Setup setup$2) {
        return now$1 - entry.createdTimestamp() >= setup$2.settings().pruneRemovedOlderThan().toMillis();
    }

    public static final /* synthetic */ boolean $anonfun$behavior$8(boolean onlyRemoveOldEntries$1, Set addresses$1, ClusterReceptionist.Setup setup$2, long now$1, ClusterReceptionist.Entry entry) {
        return ClusterReceptionist$.isOnRemovedNode$1(entry, addresses$1, setup$2) && (!onlyRemoveOldEntries$1 || ClusterReceptionist$.isOld$1(entry, now$1, setup$2));
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ void $anonfun$behavior$10(ClusterReceptionist.Setup setup$2, Tuple2 x0$3) {
        if (x0$3 != null) {
            void apply_modify;
            void apply_request;
            void apply_writeConsistency;
            ORMultiMapKey ddataKey = (ORMultiMapKey)x0$3._1();
            Map removalForKey = (Map)x0$3._2();
            Function1 & Serializable intersect = (Function1 & Serializable)registry -> ServiceRegistry$.MODULE$.removeAll$extension((ORMultiMap<ServiceKey<?>, ClusterReceptionist.Entry>)registry, (Map<AbstractServiceKey, Set<ClusterReceptionist.Entry>>)removalForKey, setup$2.selfNodeAddress());
            None$ none$ = None$.MODULE$;
            Replicator.WriteConsistency writeConsistency = setup$2.settings().writeConsistency();
            ORMultiMap<ServiceKey<?>, ClusterReceptionist.Entry> apply_initial = MODULE$.EmptyORMultiMap();
            Object var6_7 = null;
            writeConsistency = null;
            none$ = null;
            intersect = null;
            Replicator.Update x$1 = new Replicator.Update((Key)ddataKey, (Replicator.WriteConsistency)apply_writeConsistency, (Option)apply_request, arg_0 -> Replicator.Update$.$anonfun$modifyWithInitial$1((Function1)apply_modify, apply_initial, arg_0));
            org.apache.pekko.actor.ActorRef x$2 = setup$2.replicator().$bang$default$2((Object)x$1);
            setup$2.replicator().$bang((Object)x$1, x$2);
            return;
        }
        throw new MatchError(null);
    }

    private static final void nodesRemoved$1(Set addresses, boolean onlyRemoveOldEntries, ClusterReceptionist.Setup setup$2, ClusterReceptionist.State state$1, ActorContext ctx$2) {
        long now = System.currentTimeMillis();
        Map removals = (Map)state$1.registry().allServices().foldLeft((Object)Predef$.MODULE$.Map().empty(), (Function2 & Serializable)(x0$1, x1$1) -> {
            Tuple2 tuple2 = new Tuple2(x0$1, x1$1);
            if (x1$1 != null) {
                ServiceKey key = (ServiceKey)x1$1._1();
                Set removedEntries = (Set)((Set)x1$1._2()).filter((Function1 & Serializable)entry -> BoxesRunTime.boxToBoolean((boolean)ClusterReceptionist$.$anonfun$behavior$8(onlyRemoveOldEntries, addresses, setup$2, now, entry)));
                if (removedEntries.isEmpty()) {
                    return x0$1;
                }
                return (Map)x0$1.$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)key), (Object)removedEntries));
            }
            throw new MatchError((Object)tuple2);
        });
        if (removals.nonEmpty()) {
            if (ctx$2.log().isDebugEnabled()) {
                package.LoggerOps$.MODULE$.debugN$extension(ctx$2.log(), "ClusterReceptionist [{}] - Node(s) removed [{}], updating registry removing entries: [{}]", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{setup$2.cluster().selfAddress(), addresses.mkString(","), removals.map((Function1 & Serializable)x0$2 -> {
                    if (x0$2 != null) {
                        AbstractServiceKey key = (AbstractServiceKey)x0$2._1();
                        Set entries = (Set)x0$2._2();
                        return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)key.asServiceKey().id()), (Object)entries.mkString("[", ", ", "]"));
                    }
                    throw new MatchError(null);
                }).mkString(",")}));
            }
            state$1.registry().entriesPerDdataKey((Map<AbstractServiceKey, Set<ClusterReceptionist.Entry>>)removals).foreach((Function1 & Serializable)x0$3 -> {
                ClusterReceptionist$.$anonfun$behavior$10(setup$2, x0$3);
                return BoxedUnit.UNIT;
            });
            return;
        }
    }

    private static final void reachabilityChanged$1(Set keysForNode, ClusterReceptionist.State newState, ClusterReceptionist.Setup setup$2) {
        ClusterReceptionist$.notifySubscribers$1(keysForNode, false, newState, setup$2);
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ void $anonfun$behavior$12(ClusterReceptionist.State newState$1, ClusterReceptionist.Setup setup$2, boolean servicesWereAddedOrRemoved$1, AbstractServiceKey changedKey) {
        ServiceKey serviceKey = changedKey.asServiceKey();
        Set subscribers = newState$1.subscriptions().get((Object)changedKey);
        if (subscribers.nonEmpty()) {
            void var8_8;
            void var7_7;
            Tuple2 tuple2 = newState$1.activeActorRefsFor(serviceKey, setup$2.selfUniqueAddress());
            if (tuple2 == null) {
                throw new MatchError(null);
            }
            Set reachable = (Set)tuple2._1();
            Set all = (Set)tuple2._2();
            ReceptionistMessages.Listing listing = new ReceptionistMessages.Listing(serviceKey, (Set)var7_7, (Set)var8_8, servicesWereAddedOrRemoved$1);
            subscribers.foreach((Function1 & Serializable)x$3 -> {
                x$3.tell((Object)listing);
                return BoxedUnit.UNIT;
            });
            return;
        }
    }

    private static final void notifySubscribers$1(Set changedKeys, boolean servicesWereAddedOrRemoved, ClusterReceptionist.State newState, ClusterReceptionist.Setup setup$2) {
        changedKeys.foreach((Function1 & Serializable)changedKey -> {
            ClusterReceptionist$.$anonfun$behavior$12(newState, setup$2, servicesWereAddedOrRemoved, changedKey);
            return BoxedUnit.UNIT;
        });
    }

    /*
     * WARNING - void declaration
     */
    private static final Behavior onCommand$1(Receptionist.Command cmd, ClusterReceptionist.Setup setup$2, ActorContext ctx$2, ClusterReceptionist.State state$1) {
        if (cmd instanceof ReceptionistMessages.Register) {
            ReceptionistMessages.Register register = (ReceptionistMessages.Register)cmd;
            ServiceKey key = register.key();
            ActorRef serviceInstance = register.serviceInstance();
            Option maybeReplyTo = register.replyTo();
            if (serviceInstance.path().address().hasLocalScope()) {
                void apply_modify;
                void apply_request;
                void apply_writeConsistency;
                ClusterReceptionist.Entry entry = new ClusterReceptionist.Entry(serviceInstance, setup$2.selfSystemUid(), System.currentTimeMillis());
                package.LoggerOps$.MODULE$.debugN$extension(ctx$2.log(), "ClusterReceptionist [{}] - Actor was registered: [{}] [{}]", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{setup$2.cluster().selfAddress(), key, entry}));
                if (!state$1.servicesPerActor().contains((Object)serviceInstance)) {
                    ctx$2.watchWith(serviceInstance, new ClusterReceptionist.LocalServiceActorTerminated(serviceInstance));
                }
                if (maybeReplyTo instanceof Some) {
                    ActorRef replyTo = (ActorRef)((Some)maybeReplyTo).value();
                    ReceptionistMessages.Registered $bang$extension_msg = new ReceptionistMessages.Registered(key, serviceInstance);
                    replyTo.tell((Object)$bang$extension_msg);
                    Object var52_10 = null;
                } else if (!None$.MODULE$.equals(maybeReplyTo)) {
                    throw new MatchError((Object)maybeReplyTo);
                }
                ORMultiMapKey<ServiceKey<?>, ClusterReceptionist.Entry> ddataKey = state$1.registry().ddataKeyFor(key);
                Function1 & Serializable intersect = (Function1 & Serializable)registry -> ServiceRegistry$.MODULE$.addBinding$extension((ORMultiMap<ServiceKey<?>, ClusterReceptionist.Entry>)registry, key, entry, setup$2.selfNodeAddress());
                None$ none$ = None$.MODULE$;
                Replicator.WriteConsistency writeConsistency = setup$2.settings().writeConsistency();
                ORMultiMap<ServiceKey<?>, ClusterReceptionist.Entry> apply_initial = MODULE$.EmptyORMultiMap();
                Object var40_15 = null;
                writeConsistency = null;
                none$ = null;
                intersect = null;
                Replicator.Update x$1 = new Replicator.Update(ddataKey, (Replicator.WriteConsistency)apply_writeConsistency, (Option)apply_request, arg_0 -> Replicator.Update$.$anonfun$modifyWithInitial$1((Function1)apply_modify, apply_initial, arg_0));
                org.apache.pekko.actor.ActorRef x$2 = setup$2.replicator().$bang$default$2((Object)x$1);
                setup$2.replicator().$bang((Object)x$1, x$2);
                return MODULE$.behavior(setup$2, state$1.addLocalService(serviceInstance, key));
            }
            ctx$2.log().error("ClusterReceptionist [{}] - Register of non-local [{}] is not supported", (Object)serviceInstance);
            return BehaviorImpl.SameBehavior$.MODULE$;
        }
        if (cmd instanceof ReceptionistMessages.Deregister) {
            ReceptionistMessages.Deregister deregister = (ReceptionistMessages.Deregister)cmd;
            ServiceKey key = deregister.key();
            ActorRef serviceInstance = deregister.serviceInstance();
            Option maybeReplyTo = deregister.replyTo();
            if (serviceInstance.path().address().hasLocalScope()) {
                void apply_modify;
                void apply_request;
                void apply_writeConsistency;
                ClusterReceptionist.Entry entry = new ClusterReceptionist.Entry(serviceInstance, setup$2.selfSystemUid(), 0L);
                package.LoggerOps$.MODULE$.debugN$extension(ctx$2.log(), "ClusterReceptionist [{}] - Unregister actor: [{}] [{}]", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{setup$2.cluster().selfAddress(), key.asServiceKey().id(), entry}));
                ClusterReceptionist.State newState = state$1.removeLocalService(serviceInstance, key, setup$2.newTombstoneDeadline());
                if (!newState.servicesPerActor().contains((Object)serviceInstance)) {
                    ctx$2.unwatch(serviceInstance);
                }
                if (maybeReplyTo instanceof Some) {
                    ActorRef replyTo = (ActorRef)((Some)maybeReplyTo).value();
                    ReceptionistMessages.Deregistered $bang$extension_msg = new ReceptionistMessages.Deregistered(key, serviceInstance);
                    replyTo.tell((Object)$bang$extension_msg);
                    Object var53_25 = null;
                } else if (!None$.MODULE$.equals(maybeReplyTo)) {
                    throw new MatchError((Object)maybeReplyTo);
                }
                ORMultiMapKey<ServiceKey<?>, ClusterReceptionist.Entry> ddataKey = state$1.registry().ddataKeyFor(key);
                Function1 & Serializable intersect = (Function1 & Serializable)registry -> ServiceRegistry$.MODULE$.removeBinding$extension((ORMultiMap<ServiceKey<?>, ClusterReceptionist.Entry>)registry, key, entry, setup$2.selfNodeAddress());
                None$ none$ = None$.MODULE$;
                Replicator.WriteConsistency writeConsistency = setup$2.settings().writeConsistency();
                ORMultiMap<ServiceKey<?>, ClusterReceptionist.Entry> apply_initial = MODULE$.EmptyORMultiMap();
                Object var44_30 = null;
                writeConsistency = null;
                none$ = null;
                intersect = null;
                Replicator.Update x$3 = new Replicator.Update(ddataKey, (Replicator.WriteConsistency)apply_writeConsistency, (Option)apply_request, arg_0 -> Replicator.Update$.$anonfun$modifyWithInitial$1((Function1)apply_modify, apply_initial, arg_0));
                org.apache.pekko.actor.ActorRef x$4 = setup$2.replicator().$bang$default$2((Object)x$3);
                setup$2.replicator().$bang((Object)x$3, x$4);
                return MODULE$.behavior(setup$2, newState);
            }
            ctx$2.log().error("ClusterReceptionist [{}] - Unregistering non-local [{}] is not supported", (Object)serviceInstance);
            return BehaviorImpl.SameBehavior$.MODULE$;
        }
        if (cmd instanceof ReceptionistMessages.Find) {
            void apply_servicesWereAddedOrRemoved;
            void var28_38;
            void var27_37;
            ReceptionistMessages.Find find = (ReceptionistMessages.Find)cmd;
            ServiceKey key = find.key();
            ActorRef replyTo = find.replyTo();
            Tuple2 tuple2 = state$1.activeActorRefsFor(key, setup$2.selfUniqueAddress());
            if (tuple2 == null) {
                throw new MatchError(null);
            }
            Set reachable = (Set)tuple2._1();
            Set all = (Set)tuple2._2();
            boolean bl = true;
            ServiceKey apply_key = key.asServiceKey();
            Object var48_40 = null;
            ReceptionistMessages.Listing $bang$extension_msg = new ReceptionistMessages.Listing(apply_key, (Set)var27_37, (Set)var28_38, (boolean)apply_servicesWereAddedOrRemoved);
            replyTo.tell((Object)$bang$extension_msg);
            return BehaviorImpl.SameBehavior$.MODULE$;
        }
        if (cmd instanceof ReceptionistMessages.Subscribe) {
            ReceptionistMessages.Subscribe subscribe = (ReceptionistMessages.Subscribe)cmd;
            ServiceKey key = subscribe.key();
            ActorRef subscriber = subscribe.subscriber();
            if (subscriber.path().address().hasLocalScope()) {
                void apply_servicesWereAddedOrRemoved;
                void var35_47;
                void var34_46;
                ctx$2.watchWith(subscriber, new ClusterReceptionist.SubscriberTerminated(subscriber));
                Tuple2 tuple2 = state$1.activeActorRefsFor(key, setup$2.selfUniqueAddress());
                if (tuple2 == null) {
                    throw new MatchError(null);
                }
                Set reachable = (Set)tuple2._1();
                Set all = (Set)tuple2._2();
                boolean bl = true;
                ServiceKey apply_key = key.asServiceKey();
                Object var50_49 = null;
                ReceptionistMessages.Listing listing = new ReceptionistMessages.Listing(apply_key, (Set)var34_46, (Set)var35_47, (boolean)apply_servicesWereAddedOrRemoved);
                subscriber.tell((Object)listing);
                TypedMultiMap x$5 = state$1.subscriptions().inserted((Object)key, (Object)subscriber);
                ShardedServiceRegistry x$6 = state$1.registry();
                Map<ActorRef<?>, Set<AbstractServiceKey>> x$7 = state$1.servicesPerActor();
                Map<ActorRef<?>, Set<Tuple2<AbstractServiceKey, Deadline>>> x$8 = state$1.tombstones();
                return MODULE$.behavior(setup$2, new ClusterReceptionist.State(x$6, x$7, x$8, (TypedMultiMap<AbstractServiceKey, ActorRef>)x$5));
            }
            ctx$2.log().error("ClusterReceptionist [{}] - Subscriptions from non-local [{}] is not supported", (Object)subscriber);
            return BehaviorImpl.SameBehavior$.MODULE$;
        }
        throw new IllegalArgumentException();
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ void $anonfun$behavior$18(ClusterReceptionist.State state$1, ClusterReceptionist.Setup setup$2, ClusterReceptionist.Entry entry$3, AbstractServiceKey key) {
        void apply_modify;
        void apply_request;
        void apply_writeConsistency;
        ORMultiMapKey<ServiceKey<?>, ClusterReceptionist.Entry> ddataKey = state$1.registry().ddataKeyFor(key.asServiceKey());
        Function1 & Serializable intersect = (Function1 & Serializable)registry -> ServiceRegistry$.MODULE$.removeBinding$extension((ORMultiMap<ServiceKey<?>, ClusterReceptionist.Entry>)registry, key.asServiceKey(), entry$3, setup$2.selfNodeAddress());
        None$ none$ = None$.MODULE$;
        Replicator.WriteConsistency writeConsistency = setup$2.settings().writeConsistency();
        ORMultiMap<ServiceKey<?>, ClusterReceptionist.Entry> apply_initial = MODULE$.EmptyORMultiMap();
        Object var7_8 = null;
        writeConsistency = null;
        none$ = null;
        intersect = null;
        Replicator.Update x$1 = new Replicator.Update(ddataKey, (Replicator.WriteConsistency)apply_writeConsistency, (Option)apply_request, arg_0 -> Replicator.Update$.$anonfun$modifyWithInitial$1((Function1)apply_modify, apply_initial, arg_0));
        org.apache.pekko.actor.ActorRef x$2 = setup$2.replicator().$bang$default$2((Object)x$1);
        setup$2.replicator().$bang((Object)x$1, x$2);
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ void $anonfun$behavior$21(ORMultiMap newRegistry$1, ClusterReceptionist.State state$1, ActorContext ctx$2, ClusterReceptionist.Setup setup$2, ORMultiMapKey ddataKey$1, AbstractServiceKey changedKey) {
        ServiceKey serviceKey = changedKey.asServiceKey();
        Set tombstonedButReAdded = (Set)ServiceRegistry$.MODULE$.actorRefsFor$extension(newRegistry$1, (AbstractServiceKey)serviceKey).filter((Function1 & Serializable)actorRef -> BoxesRunTime.boxToBoolean((boolean)state$1.hasTombstone(serviceKey, actorRef)));
        if (tombstonedButReAdded.nonEmpty()) {
            void apply_modify;
            void apply_request;
            void apply_writeConsistency;
            if (ctx$2.log().isDebugEnabled()) {
                ctx$2.log().debug("ClusterReceptionist [{}] - Saw ActorRefs that were tomstoned [{}], re-removing.", (Object)setup$2.cluster().selfAddress(), (Object)tombstonedButReAdded.mkString(", "));
            }
            Function1 & Serializable intersect = (Function1 & Serializable)registry -> ((ServiceRegistry)tombstonedButReAdded.foldLeft((Object)new ServiceRegistry((ORMultiMap<ServiceKey<?>, ClusterReceptionist.Entry>)registry), (Function2 & Serializable)(acc, ref) -> new ServiceRegistry(ServiceRegistry$.MODULE$.removeBinding$extension(((ServiceRegistry)acc).entries(), serviceKey, new ClusterReceptionist.Entry(ref, setup$2.selfSystemUid(), 0L), setup$2.selfNodeAddress())))).entries();
            None$ none$ = None$.MODULE$;
            Replicator.WriteConsistency writeConsistency = setup$2.settings().writeConsistency();
            ORMultiMap<ServiceKey<?>, ClusterReceptionist.Entry> apply_initial = MODULE$.EmptyORMultiMap();
            Object var10_11 = null;
            writeConsistency = null;
            none$ = null;
            intersect = null;
            Replicator.Update x$3 = new Replicator.Update((Key)ddataKey$1, (Replicator.WriteConsistency)apply_writeConsistency, (Option)apply_request, arg_0 -> Replicator.Update$.$anonfun$modifyWithInitial$1((Function1)apply_modify, apply_initial, arg_0));
            org.apache.pekko.actor.ActorRef x$4 = setup$2.replicator().$bang$default$2((Object)x$3);
            setup$2.replicator().$bang((Object)x$3, x$4);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    private static final Behavior onInternalCommand$1(ClusterReceptionist.InternalCommand cmd, ClusterReceptionist.Setup setup$2, ClusterReceptionist.State state$1, ActorContext ctx$2) {
        if (cmd instanceof ClusterReceptionist.SubscriberTerminated) {
            ActorRef subscriber = ((ClusterReceptionist.SubscriberTerminated)cmd).ref();
            return MODULE$.behavior(setup$2, state$1.removeSubscriber(subscriber));
        }
        if (cmd instanceof ClusterReceptionist.LocalServiceActorTerminated) {
            ActorRef serviceInstance = ((ClusterReceptionist.LocalServiceActorTerminated)cmd).ref();
            ClusterReceptionist.Entry entry = new ClusterReceptionist.Entry(serviceInstance, setup$2.selfSystemUid(), 0L);
            Set keys = (Set)state$1.servicesPerActor().getOrElse(serviceInstance, (Function0 & Serializable)() -> Predef$.MODULE$.Set().empty());
            package.LoggerOps$.MODULE$.debugN$extension(package$.MODULE$.LoggerOps(ctx$2.log()), "ClusterReceptionist [{}] - Registered actor terminated: [{}] [{}]", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{setup$2.cluster().selfAddress(), ((IterableOnceOps)keys.map((Function1 & Serializable)x$6 -> x$6.asServiceKey().id())).mkString(", "), entry}));
            keys.foreach((Function1 & Serializable)key -> {
                ClusterReceptionist$.$anonfun$behavior$18(state$1, setup$2, entry, key);
                return BoxedUnit.UNIT;
            });
            return MODULE$.behavior(setup$2, state$1.addTombstone(serviceInstance, setup$2.newTombstoneDeadline()));
        }
        if (cmd instanceof ClusterReceptionist.ChangeFromReplicator) {
            void copy_subscriptions;
            void copy_tombstones;
            void copy_servicesPerActor;
            ClusterReceptionist.ChangeFromReplicator changeFromReplicator = (ClusterReceptionist.ChangeFromReplicator)cmd;
            ORMultiMapKey<ServiceKey<?>, ClusterReceptionist.Entry> ddataKey = changeFromReplicator.key();
            ORMultiMap<ServiceKey<?>, ClusterReceptionist.Entry> value = changeFromReplicator.value();
            Set<AbstractServiceKey> changedKeys = state$1.registry().collectChangedKeys(ddataKey, value);
            TypedMultiMap<AbstractServiceKey, ActorRef> typedMultiMap = state$1.copy$default$4();
            Map<ActorRef<?>, Set<Tuple2<AbstractServiceKey, Deadline>>> map = state$1.copy$default$3();
            Map<ActorRef<?>, Set<AbstractServiceKey>> map2 = state$1.copy$default$2();
            ShardedServiceRegistry copy_registry = state$1.registry().withServiceRegistry(ddataKey, value);
            Object var28_15 = null;
            map2 = null;
            map = null;
            typedMultiMap = null;
            ClusterReceptionist.State newState = new ClusterReceptionist.State(copy_registry, (Map<ActorRef<?>, Set<AbstractServiceKey>>)copy_servicesPerActor, (Map<ActorRef<?>, Set<Tuple2<AbstractServiceKey, Deadline>>>)copy_tombstones, (TypedMultiMap<AbstractServiceKey, ActorRef>)copy_subscriptions);
            if (changedKeys.nonEmpty()) {
                if (ctx$2.log().isDebugEnabled()) {
                    package.LoggerOps$.MODULE$.debugN$extension(package$.MODULE$.LoggerOps(ctx$2.log()), "ClusterReceptionist [{}] - Change from replicator: [{}], changes: [{}], tombstones [{}]", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{setup$2.cluster().selfAddress(), value.entries(), ((IterableOnceOps)changedKeys.map((Function1 & Serializable)key -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)key.asServiceKey().id()), (Object)ServiceRegistry$.MODULE$.entriesFor$extension(value, (AbstractServiceKey)key).mkString("[", ", ", "]")))).mkString(", "), state$1.tombstones().mkString(", ")}));
                }
                ClusterReceptionist$.notifySubscribers$1(changedKeys, true, newState, setup$2);
                changedKeys.foreach((Function1 & Serializable)changedKey -> {
                    ClusterReceptionist$.$anonfun$behavior$21(value, state$1, ctx$2, setup$2, ddataKey, changedKey);
                    return BoxedUnit.UNIT;
                });
                return MODULE$.behavior(setup$2, newState);
            }
            return Behaviors$.MODULE$.same();
        }
        if (cmd instanceof ClusterReceptionist.NodeAdded) {
            void copy_subscriptions;
            void copy_tombstones;
            void copy_servicesPerActor;
            UniqueAddress uniqueAddress = ((ClusterReceptionist.NodeAdded)cmd).addresses();
            if (state$1.registry().nodes().contains((Object)uniqueAddress)) {
                return Behaviors$.MODULE$.same();
            }
            TypedMultiMap<AbstractServiceKey, ActorRef> typedMultiMap = state$1.copy$default$4();
            Map<ActorRef<?>, Set<Tuple2<AbstractServiceKey, Deadline>>> map = state$1.copy$default$3();
            Map<ActorRef<?>, Set<AbstractServiceKey>> map3 = state$1.copy$default$2();
            ShardedServiceRegistry copy_registry = state$1.registry().addNode(uniqueAddress);
            Object var32_21 = null;
            map3 = null;
            map = null;
            typedMultiMap = null;
            ClusterReceptionist.State newState = new ClusterReceptionist.State(copy_registry, (Map<ActorRef<?>, Set<AbstractServiceKey>>)copy_servicesPerActor, (Map<ActorRef<?>, Set<Tuple2<AbstractServiceKey, Deadline>>>)copy_tombstones, (TypedMultiMap<AbstractServiceKey, ActorRef>)copy_subscriptions);
            Set<AbstractServiceKey> keysForNode = newState.registry().keysFor(uniqueAddress, setup$2.selfNodeAddress());
            if (keysForNode.nonEmpty()) {
                package.LoggerOps$.MODULE$.debug2$extension(package$.MODULE$.LoggerOps(ctx$2.log()), "ClusterReceptionist [{}] - Node with registered services added [{}]", (Object)setup$2.cluster().selfAddress(), (Object)uniqueAddress);
                ClusterReceptionist$.notifySubscribers$1(keysForNode, true, newState, setup$2);
            } else {
                package.LoggerOps$.MODULE$.debug2$extension(package$.MODULE$.LoggerOps(ctx$2.log()), "ClusterReceptionist [{}] - Node added [{}]", (Object)setup$2.cluster().selfAddress(), (Object)uniqueAddress);
            }
            return MODULE$.behavior(setup$2, newState);
        }
        if (cmd instanceof ClusterReceptionist.NodeRemoved) {
            UniqueAddress uniqueAddress;
            UniqueAddress uniqueAddress2 = uniqueAddress = ((ClusterReceptionist.NodeRemoved)cmd).addresses();
            UniqueAddress uniqueAddress3 = setup$2.selfUniqueAddress();
            if (!(uniqueAddress2 != null ? !uniqueAddress2.equals(uniqueAddress3) : uniqueAddress3 != null)) {
                ctx$2.log().debug("ClusterReceptionist [{}] - terminated/removed", (Object)setup$2.cluster().selfAddress());
                return Behaviors$.MODULE$.stopped();
            }
            if (state$1.registry().nodes().contains((Object)uniqueAddress)) {
                void copy_subscriptions;
                void copy_tombstones;
                void copy_servicesPerActor;
                Set<AbstractServiceKey> keysForNode = state$1.registry().keysFor(uniqueAddress, setup$2.selfNodeAddress());
                TypedMultiMap<AbstractServiceKey, ActorRef> typedMultiMap = state$1.copy$default$4();
                Map<ActorRef<?>, Set<Tuple2<AbstractServiceKey, Deadline>>> map = state$1.copy$default$3();
                Map<ActorRef<?>, Set<AbstractServiceKey>> map4 = state$1.copy$default$2();
                ShardedServiceRegistry copy_registry = state$1.registry().removeNode(uniqueAddress);
                Object var36_30 = null;
                map4 = null;
                map = null;
                typedMultiMap = null;
                ClusterReceptionist.State newState = new ClusterReceptionist.State(copy_registry, (Map<ActorRef<?>, Set<AbstractServiceKey>>)copy_servicesPerActor, (Map<ActorRef<?>, Set<Tuple2<AbstractServiceKey, Deadline>>>)copy_tombstones, (TypedMultiMap<AbstractServiceKey, ActorRef>)copy_subscriptions);
                if (keysForNode.nonEmpty()) {
                    package.LoggerOps$.MODULE$.debug2$extension(package$.MODULE$.LoggerOps(ctx$2.log()), "ClusterReceptionist [{}] - Node with registered services removed [{}]", (Object)setup$2.cluster().selfAddress(), (Object)uniqueAddress);
                    ClusterReceptionist$.notifySubscribers$1(keysForNode, true, newState, setup$2);
                }
                if (ClusterReceptionist$.isLeader$1(setup$2)) {
                    package.LoggerOps$.MODULE$.debug2$extension(package$.MODULE$.LoggerOps(ctx$2.log()), "ClusterReceptionist [{}] - Leader node observed removed node [{}]", (Object)setup$2.cluster().selfAddress(), (Object)uniqueAddress);
                    ClusterReceptionist$.nodesRemoved$1((Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new UniqueAddress[]{uniqueAddress})), false, setup$2, state$1, ctx$2);
                }
                return MODULE$.behavior(setup$2, newState);
            }
            return Behaviors$.MODULE$.same();
        }
        if (cmd instanceof ClusterReceptionist.NodeUnreachable) {
            void copy_subscriptions;
            void copy_tombstones;
            void copy_servicesPerActor;
            UniqueAddress uniqueAddress = ((ClusterReceptionist.NodeUnreachable)cmd).addresses();
            Set<AbstractServiceKey> keysForNode = state$1.registry().keysFor(uniqueAddress, setup$2.selfNodeAddress());
            TypedMultiMap<AbstractServiceKey, ActorRef> typedMultiMap = state$1.copy$default$4();
            Map<ActorRef<?>, Set<Tuple2<AbstractServiceKey, Deadline>>> map = state$1.copy$default$3();
            Map<ActorRef<?>, Set<AbstractServiceKey>> map5 = state$1.copy$default$2();
            ShardedServiceRegistry copy_registry = state$1.registry().addUnreachable(uniqueAddress);
            Object var40_37 = null;
            map5 = null;
            map = null;
            typedMultiMap = null;
            ClusterReceptionist.State newState = new ClusterReceptionist.State(copy_registry, (Map<ActorRef<?>, Set<AbstractServiceKey>>)copy_servicesPerActor, (Map<ActorRef<?>, Set<Tuple2<AbstractServiceKey, Deadline>>>)copy_tombstones, (TypedMultiMap<AbstractServiceKey, ActorRef>)copy_subscriptions);
            if (keysForNode.nonEmpty()) {
                package.LoggerOps$.MODULE$.debug2$extension(package$.MODULE$.LoggerOps(ctx$2.log()), "ClusterReceptionist [{}] - Node with registered services unreachable [{}]", (Object)setup$2.cluster().selfAddress(), (Object)uniqueAddress);
                ClusterReceptionist$.reachabilityChanged$1(keysForNode, newState, setup$2);
            }
            return MODULE$.behavior(setup$2, newState);
        }
        if (cmd instanceof ClusterReceptionist.NodeReachable) {
            void copy_subscriptions;
            void copy_tombstones;
            void copy_servicesPerActor;
            UniqueAddress uniqueAddress = ((ClusterReceptionist.NodeReachable)cmd).addresses();
            Set<AbstractServiceKey> keysForNode = state$1.registry().keysFor(uniqueAddress, setup$2.selfNodeAddress());
            TypedMultiMap<AbstractServiceKey, ActorRef> typedMultiMap = state$1.copy$default$4();
            Map<ActorRef<?>, Set<Tuple2<AbstractServiceKey, Deadline>>> map = state$1.copy$default$3();
            Map<ActorRef<?>, Set<AbstractServiceKey>> map6 = state$1.copy$default$2();
            ShardedServiceRegistry copy_registry = state$1.registry().removeUnreachable(uniqueAddress);
            Object var44_44 = null;
            map6 = null;
            map = null;
            typedMultiMap = null;
            ClusterReceptionist.State newState = new ClusterReceptionist.State(copy_registry, (Map<ActorRef<?>, Set<AbstractServiceKey>>)copy_servicesPerActor, (Map<ActorRef<?>, Set<Tuple2<AbstractServiceKey, Deadline>>>)copy_tombstones, (TypedMultiMap<AbstractServiceKey, ActorRef>)copy_subscriptions);
            if (keysForNode.nonEmpty()) {
                package.LoggerOps$.MODULE$.debug2$extension(package$.MODULE$.LoggerOps(ctx$2.log()), "ClusterReceptionist [{}] - Node with registered services reachable again [{}]", (Object)setup$2.cluster().selfAddress(), (Object)uniqueAddress);
                ClusterReceptionist$.reachabilityChanged$1(keysForNode, newState, setup$2);
            }
            return MODULE$.behavior(setup$2, newState);
        }
        if (ClusterReceptionist$RemoveTick$.MODULE$.equals(cmd)) {
            Set notInCluster;
            if (ClusterReceptionist$.isLeader$1(setup$2) && (notInCluster = (Set)state$1.registry().allUniqueAddressesInState(setup$2.selfUniqueAddress()).diff(state$1.registry().nodes())).nonEmpty()) {
                if (ctx$2.log().isDebugEnabled()) {
                    package.LoggerOps$.MODULE$.debug2$extension(package$.MODULE$.LoggerOps(ctx$2.log()), "ClusterReceptionist [{}] - Leader node cleanup tick, removed nodes: [{}]", (Object)setup$2.cluster().selfAddress(), (Object)notInCluster.mkString(","));
                }
                ClusterReceptionist$.nodesRemoved$1(notInCluster, true, setup$2, state$1, ctx$2);
            }
            return Behaviors$.MODULE$.same();
        }
        if (ClusterReceptionist$PruneTombstonesTick$.MODULE$.equals(cmd)) {
            ClusterReceptionist.State prunedState = state$1.pruneTombstones();
            if (prunedState == state$1) {
                return Behaviors$.MODULE$.same();
            }
            ctx$2.log().debug("ClusterReceptionist [{}] - Pruning tombstones", (Object)setup$2.cluster().selfAddress());
            return MODULE$.behavior(setup$2, prunedState);
        }
        throw new MatchError((Object)cmd);
    }

    private ClusterReceptionist$() {
    }
}

