/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.dsl.service;

import com.xebialabs.deployit.exception.NotFoundException;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.xlrelease.domain.Dependency;
import com.xebialabs.xlrelease.domain.Phase;
import com.xebialabs.xlrelease.domain.PlanItem;
import com.xebialabs.xlrelease.domain.Release;
import com.xebialabs.xlrelease.domain.Task;
import com.xebialabs.xlrelease.dsl.DependencyTargetSpec;
import com.xebialabs.xlrelease.dsl.IdDependencyTargetSpec;
import com.xebialabs.xlrelease.dsl.TargetSpec;
import com.xebialabs.xlrelease.dsl.service.CiProcessor;
import com.xebialabs.xlrelease.dsl.service.DslError;
import com.xebialabs.xlrelease.dsl.service.DslProcessingContext;
import com.xebialabs.xlrelease.dsl.service.PathUtils;
import com.xebialabs.xlrelease.repository.Ids;
import com.xebialabs.xlrelease.repository.Page;
import com.xebialabs.xlrelease.repository.PlanItemRepository;
import com.xebialabs.xlrelease.security.PermissionChecker;
import com.xebialabs.xlrelease.security.XLReleasePermissions;
import com.xebialabs.xlrelease.service.FolderService;
import com.xebialabs.xlrelease.service.ReleaseService;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

@Component
public class DependencyCiProcessor
implements CiProcessor<Dependency> {
    private ReleaseService releaseService;
    private PlanItemRepository planItemRepository;
    private FolderService folderService;
    private PermissionChecker permissionChecker;

    @Autowired
    public DependencyCiProcessor(ReleaseService releaseService, PlanItemRepository planItemRepository, FolderService folderService, PermissionChecker permissionChecker) {
        this.releaseService = releaseService;
        this.planItemRepository = planItemRepository;
        this.folderService = folderService;
        this.permissionChecker = permissionChecker;
    }

    @Override
    public void process(DslProcessingContext processingContext, Dependency ci) {
        Map $metadata = ci.get$metadata();
        if (null != $metadata) {
            TargetSpec targetSpec = (TargetSpec)$metadata.get("targetSpec");
            if (null != ci.getTargetId() && null != targetSpec) {
                throw new DslError("Set either a variable or target for a dependency in gate task.");
            }
            if (null != targetSpec) {
                if (targetSpec instanceof DependencyTargetSpec) {
                    String containerId = processingContext.getContainer() != null ? processingContext.getContainer().getId() : Ids.ROOT_FOLDER_ID;
                    String defaultFolderId = Ids.findFolderId((String)containerId);
                    ci.setTarget(this.resolveTargetFromPath(defaultFolderId, (DependencyTargetSpec)targetSpec));
                } else if (targetSpec instanceof IdDependencyTargetSpec) {
                    ci.setTarget(this.resolveTargetFromId((IdDependencyTargetSpec)targetSpec));
                }
            }
        }
    }

    @Override
    public Type getType() {
        return Type.valueOf(Dependency.class);
    }

    private PlanItem resolveTargetFromId(IdDependencyTargetSpec targetSpec) {
        String targetPlanItemId = targetSpec.getTargetId();
        try {
            return this.planItemRepository.findById(targetPlanItemId);
        }
        catch (NotFoundException ignore) {
            throw new DslError("No target found with ID: '%s'", targetPlanItemId);
        }
    }

    private PlanItem resolveTargetFromPath(String defaultFolderId, DependencyTargetSpec targetSpec) {
        String releaseTitleOrId = targetSpec.getRelease();
        if (StringUtils.hasText((String)releaseTitleOrId)) {
            Release release = this.resolveRelease(defaultFolderId, releaseTitleOrId);
            String phaseTitleOrId = targetSpec.getPhase();
            if (StringUtils.hasText((String)phaseTitleOrId)) {
                Phase phase = this.getPhaseFromRelease(release, phaseTitleOrId);
                String taskTitleOrId = targetSpec.getTask();
                if (StringUtils.hasText((String)taskTitleOrId)) {
                    return this.getTaskFromPhase(phase, taskTitleOrId);
                }
                return phase;
            }
            return release;
        }
        throw new DslError("No target found with path '%s'.", this.getPathFromTarget(targetSpec));
    }

    private Release resolveRelease(String defaultFolderId, String releaseTitleOrId) {
        Release release;
        try {
            release = this.releaseService.findById(releaseTitleOrId);
        }
        catch (NotFoundException ignore) {
            release = this.getReleaseFromPath(defaultFolderId, releaseTitleOrId);
        }
        return release;
    }

    private Task getTaskFromPhase(Phase phase, String taskTitleOrId) {
        return phase.getTasks().stream().filter(task -> taskTitleOrId.equals(task.getTitle()) || taskTitleOrId.equals(task.getId())).findAny().orElseThrow(() -> new DslError("No task found with title/id '%s'.", taskTitleOrId));
    }

    private Phase getPhaseFromRelease(Release release, String phaseTitleOrId) {
        return release.getPhases().stream().filter(phase -> phaseTitleOrId.equals(phase.getTitle()) || phaseTitleOrId.equals(phase.getId())).findAny().orElseThrow(() -> new DslError("No phase found with title/id '%s'.", phaseTitleOrId));
    }

    private Release getReleaseFromPath(String defaultFolderId, String releasePath) {
        String releaseTitle;
        Optional<String> folderPath = PathUtils.folderPath(releasePath);
        String folderId = folderPath.map(path -> this.folderService.findByPath(path, Page.DEFAULT_DEPTH().intValue()).getId()).orElse(defaultFolderId);
        List releases = this.releaseService.findReleasesByTitle(folderId, releaseTitle = this.releaseTitle(releasePath), 0, 2, Integer.MAX_VALUE);
        if (releases.isEmpty()) {
            throw new DslError("No release found with title '%s'.", releaseTitle);
        }
        if (releases.size() > 1) {
            throw new DslError("More than one release found with title '%s'.", releaseTitle);
        }
        if ((releases = this.permissionChecker.filter(releases, XLReleasePermissions.VIEW_RELEASE)).isEmpty()) {
            throw new DslError("You don't have view permissions on the release with title '%s'.", releaseTitle);
        }
        return (Release)releases.get(0);
    }

    private String releaseTitle(String fullReleasePath) {
        return PathUtils.releasePath(fullReleasePath).orElseThrow(() -> new DslError("Unable to find template title in '%s'", fullReleasePath));
    }

    private String getPathFromTarget(DependencyTargetSpec targetSpec) {
        Object path = "";
        if (null != targetSpec.getRelease()) {
            path = (String)path + targetSpec.getRelease();
        }
        if (null != targetSpec.getPhase()) {
            path = (String)path + "/" + targetSpec.getPhase();
        }
        if (null != targetSpec.getTask()) {
            path = (String)path + "/" + targetSpec.getTask();
        }
        return path;
    }
}

