import React from 'react';
import { DotAnnotation } from '@digital-ai/dot-components';
import './folder-versioning-input-helper-line.component.less';

interface FolderVersioningInputHelperLineProps {
    appliedVersion: string | null;
    error: boolean;
    inputText: string | null;
    latestVersion: string | null;
    message: string | null;
}

export const FolderVersioningInputHelperLine = ({ appliedVersion, error, inputText, latestVersion, message }: FolderVersioningInputHelperLineProps) => {
    if (error) {
        return message !== null ? (
            <span className="folder-versioning-input-helper-line">
                <span className="helper-line-left">{message}</span>
            </span>
        ) : (
            <span className="folder-versioning-input-helper-line">
                <span className="helper-line-left">
                    Tag version <DotAnnotation content={inputText} /> is already in use. Specify a unique tag version.
                    <br />
                    Tag version: latest <DotAnnotation content={latestVersion} />, applied <DotAnnotation content={appliedVersion} />.
                </span>
            </span>
        );
    } else {
        return latestVersion !== null ? (
            <span className="folder-versioning-input-helper-line">
                <span className="helper-line-left">
                    Tag version: latest <DotAnnotation content={latestVersion} />, applied <DotAnnotation content={appliedVersion} />.
                </span>
            </span>
        ) : (
            <span></span>
        );
    }
};
