import { call } from 'redux-saga/effects';
import { ActivityLogsFilterSettings } from '../types';
import { FilterQueryParams } from '@xlr-ui/app/types';
import getAngularService from '@xlr-ui/app/features/common/services/angular-accessor';
import { ActivityLogsClientSettings } from '../features/activity-logs/types';

export function* updateClientSettingsAndUrl(containerId: string, filterSettings: ActivityLogsFilterSettings) {
    const FiltersQueryParams: FilterQueryParams = yield call(getAngularService, 'FiltersQueryParams');
    const clientSettings: ActivityLogsClientSettings = yield call(getAngularService, 'ClientSettings');
    clientSettings.setLogsFilters(containerId, filterSettings);
    FiltersQueryParams.update(filterSettings);
}
