import React from 'react';
import moment from 'moment';
import { DotTypography } from '@digital-ai/dot-components';

export interface ActivityLogsTimeProps {
    dateFormat: string;
    eventTime: number;
    timeFormat: string;
}

export const ActivityLogsTime = ({ dateFormat, eventTime, timeFormat }: ActivityLogsTimeProps) => {
    return (
        <div className="activity-logs-time">
            <DotTypography variant="body1">{moment(eventTime).format(dateFormat)}</DotTypography>
            <DotTypography variant="body2">{moment(eventTime).format(timeFormat)}</DotTypography>
        </div>
    );
};
