import { createSlice, PayloadAction } from '@reduxjs/toolkit';
import noop from 'lodash/noop';
import { RootState } from '@xlr-ui/app/js/store.types';
import { ActivityLog, ActivityLogsFilterSettings } from '../../../types';
import { DEFAULT_FILTER_SETTINGS } from '../../../constants';
import { DEFAULT_PAGINATION } from '@xlr-ui/app/constants/pagination';
import { DRAWER_HISTORY_ITEMS_PER_PAGE } from '../constants';

export interface LoadFilteredAndPagedHistoryLogsAction {
    logsFilter: HistoryLogsFilter;
    page: number;
}

export interface HistoryLogsFilter {
    containerId: string;
    filterSettings: ActivityLogsFilterSettings;
    taskId: string;
}

export interface DrawerHistoryState {
    isLastPage: boolean;
    isLoading: boolean;
    itemsPerPage: number;
    logs: ActivityLog[];
    logsFilter: HistoryLogsFilter;
    page: number;
}

export const initialState: DrawerHistoryState = {
    isLastPage: false,
    isLoading: false,
    itemsPerPage: DRAWER_HISTORY_ITEMS_PER_PAGE,
    logs: [],
    logsFilter: {
        containerId: '',
        filterSettings: { ...DEFAULT_FILTER_SETTINGS, targetId: '' },
        taskId: '',
    },
    page: DEFAULT_PAGINATION.page,
};

export const drawerHistory = createSlice({
    name: 'drawerHistory',
    initialState,
    reducers: {
        init: (_state, _action: PayloadAction<HistoryLogsFilter>) => noop(),
        loadFilteredAndPagedHistoryLogs: (_state, _action: PayloadAction<LoadFilteredAndPagedHistoryLogsAction>) => noop(),
        reset: () => initialState,
        setLogsFilter: (state, action: PayloadAction<HistoryLogsFilter>) => {
            state.logsFilter = action.payload;
        },
        setIsLoading: (state, action: PayloadAction<boolean>) => {
            state.isLoading = action.payload;
        },
        setLogs: (state, action: PayloadAction<ActivityLog[]>) => {
            state.logs = action.payload;
        },
        setPage: (state, action: PayloadAction<number>) => {
            state.page = action.payload;
        },
        setIsLastPage: (state, action: PayloadAction<boolean>) => {
            state.isLastPage = action.payload;
        },
    },
});

export const getDrawerHistoryState = (state: RootState): DrawerHistoryState => state.drawerHistory;
