import { all, call, put, takeLatest } from 'redux-saga/effects';
import { IHttpResponse } from 'angular';
import { httpGET } from '@xlr-ui/app/features/common/services/http';
import { applicationTile } from './application-tile.reducer';
import { ApplicationTileData } from '../active-application-tile.component';
import { Folder } from '@xlr-ui/app/types';
import { searchFolders } from '@xlr-ui/app/features/workflow/ducks/workflow.saga';

const { loadAllFolders, loadApplicationTileData, setApplicationTileData, setFolders } = applicationTile.actions;

export function* loadApplicationTileDataSaga() {
    const { data }: IHttpResponse<ApplicationTileData> = yield call(httpGET, 'home-tile/applications');
    yield put(setApplicationTileData(data));
}

export function* loadAllFoldersSaga() {
    const folders: Array<Folder> = yield* searchFolders();
    yield put(setFolders(folders));
}

export default function* applicationTileSaga() {
    yield all([takeLatest(loadApplicationTileData, loadApplicationTileDataSaga), takeLatest(loadAllFolders, loadAllFoldersSaga)]);
}
