import { SagaIterator } from 'redux-saga';
import { all, call, put, takeLatest } from 'redux-saga/effects';
import { httpGET } from '@xlr-ui/app/features/common/services/http';
import { releaseTile } from './release-tile.reducer';
import releaseTileSaga, { loadTopReleasesSaga } from './release-tile.saga';
import { HomeRelease } from '../active-release-tile.component';

const { loadTopReleases, setTopReleases } = releaseTile.actions;

describe('releaseTileSaga', () => {
    it('should yield all effects', () => {
        const gen: SagaIterator = releaseTileSaga();
        expect(gen.next().value).toStrictEqual(all([takeLatest(loadTopReleases, loadTopReleasesSaga)]));
        expect(gen.next().done).toBe(true);
    });

    describe('loadTopReleasesSaga', () => {
        const topReleases: Array<HomeRelease> = [
            {
                releaseId: 'releaseId',
                releaseTitle: 'Test Release',
                releaseStartDate: 1689771884388,
                releaseEndDate: 1690187050829,
                releaseStatus: 'IN_PROGRESS',
                folderName: 'test',
                folderId: 'folderId',
                folderPath: '/',
                lastEditedByUser: 1690187050870,
            },
        ];

        it('should load and set top releases', () => {
            const gen: SagaIterator = loadTopReleasesSaga();
            expect(gen.next().value).toStrictEqual(call(httpGET, 'home-tile/releases'));
            expect(gen.next({ data: topReleases }).value).toMatchObject(put(setTopReleases(topReleases)));
            expect(gen.next().done).toBeTruthy();
        });
    });
});
