import { all, call, put, takeLatest } from 'redux-saga/effects';
import { IHttpResponse } from 'angular';
import { httpGET } from '@xlr-ui/app/features/common/services/http';
import { templateTile } from './template-tile.reducer';
import { HomeTemplate } from '../active-template-tile.component';

const { loadTopTemplates, setTopTemplates } = templateTile.actions;

export function* loadTopTemplatesSaga() {
    const { data }: IHttpResponse<Array<HomeTemplate>> = yield call(httpGET, 'home-tile/templates');
    yield put(setTopTemplates(data));
}

export default function* templateTileSaga() {
    yield all([takeLatest(loadTopTemplates, loadTopTemplatesSaga)]);
}
