import React, { KeyboardEvent, MouseEvent, useEffect, useState } from 'react';
import { DotIconButton, DotMenu, MenuItemProps } from '@digital-ai/dot-components';
import { MenuItem } from '@xlr-ui/app/react/components/menu-item/menu-item.component';
import { HomeTemplate } from './active-template-tile.component';

export interface TemplateActionsButtonProps {
    onOptionsClick: (id: string) => void;
    selected: boolean;
    template: HomeTemplate;
    urlTemplateId: string;
}

export const menuItemRelease = 'menu-item-release';
export const menuItemEdit = 'menu-item-edit';

export const TemplateActionsButton = ({ onOptionsClick, selected, template, urlTemplateId }: TemplateActionsButtonProps) => {
    const [isMenuOpen, setMenuOpen] = useState(selected);
    const [dropdownAnchorEl, setDropdownAnchorEl] = useState<HTMLElement | null>(null);

    useEffect(() => {
        if (!selected) {
            setMenuOpen(false);
        }
    }, [selected]);

    const openTemplateOptionsMenu = (event: MouseEvent<HTMLElement>) => {
        setDropdownAnchorEl(event.currentTarget);
        setMenuOpen(!isMenuOpen);
        onOptionsClick(template.releaseId);
    };

    const menuItems: Array<MenuItemProps> = [
        { children: <MenuItem iconId="play" label="Start release" />, key: menuItemRelease },
        { children: <MenuItem iconId="edit" label="Edit template" />, key: menuItemEdit },
    ];

    const onSelect = (event: MouseEvent | KeyboardEvent, _menuId: string, itemKey: string) => {
        event.stopPropagation();
        if (itemKey === menuItemRelease) {
            window.location.href = `#/releases/create?fromHome=true&fromTemplateId=${urlTemplateId}`;
        }
        if (itemKey === menuItemEdit) {
            window.location.href = `#/templates/${urlTemplateId}`;
        }
    };

    return (
        <>
            <DotIconButton
                iconId="options"
                onClick={(e) => {
                    e.stopPropagation();
                    openTemplateOptionsMenu(e);
                }}
            />
            <DotMenu
                anchorEl={dropdownAnchorEl || undefined}
                dense
                disablePortal
                id={template.releaseId}
                menuItems={menuItems}
                menuPlacement="left"
                onLeave={() => setMenuOpen(false)}
                onSelect={onSelect}
                open={isMenuOpen}
            />
        </>
    );
};
