/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.plugins.dashboard.service;

import com.xebialabs.deployit.plugin.api.reflect.Descriptor;
import com.xebialabs.deployit.plugin.api.reflect.DescriptorRegistry;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.xlrelease.domain.Release;
import com.xebialabs.xlrelease.domain.VariableContainer;
import com.xebialabs.xlrelease.domain.folder.Folder;
import com.xebialabs.xlrelease.domain.variables.GlobalVariables;
import com.xebialabs.xlrelease.domain.variables.Variable;
import com.xebialabs.xlrelease.plugins.dashboard.domain.Dashboard;
import com.xebialabs.xlrelease.plugins.dashboard.domain.Tile;
import com.xebialabs.xlrelease.plugins.dashboard.domain.TileScope;
import com.xebialabs.xlrelease.plugins.dashboard.repository.DelegatingDashboardRepository;
import com.xebialabs.xlrelease.plugins.dashboard.service.TileHelper$;
import com.xebialabs.xlrelease.plugins.dashboard.service.TileScriptExecutor;
import com.xebialabs.xlrelease.repository.Ids;
import com.xebialabs.xlrelease.security.PermissionChecker$;
import com.xebialabs.xlrelease.service.ConfigurationVariableService;
import com.xebialabs.xlrelease.service.FolderService;
import com.xebialabs.xlrelease.service.FolderVariableService;
import com.xebialabs.xlrelease.service.ReleaseService;
import com.xebialabs.xlrelease.service.TeamService;
import com.xebialabs.xlrelease.service.VariableService;
import com.xebialabs.xlrelease.utils.PasswordVerificationUtils$;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import io.micrometer.core.annotation.Timed;
import java.io.Serializable;
import org.slf4j.Marker;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.jdk.CollectionConverters$;
import scala.math.Ordering;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@Service
@ScalaSignature(bytes="\u0006\u0005\u0005Eg\u0001B\n\u0015\u0001\u0005B\u0001\u0002\r\u0001\u0003\u0002\u0003\u0006I!\r\u0005\tm\u0001\u0011\t\u0011)A\u0005o!A!\b\u0001B\u0001B\u0003%1\b\u0003\u0005?\u0001\t\u0005\t\u0015!\u0003@\u0011!)\u0005A!A!\u0002\u00131\u0005\u0002\u0003&\u0001\u0005\u0003\u0005\u000b\u0011B&\t\u00119\u0003!\u0011!Q\u0001\n=C\u0001B\u0015\u0001\u0003\u0002\u0003\u0006Ia\u0015\u0005\u0006-\u0002!\ta\u0016\u0005\ba\u0002\u0011\r\u0011\"\u0001r\u0011\u0019Q\b\u0001)A\u0005e\"91\u0010\u0001b\u0001\n\u0003\t\bB\u0002?\u0001A\u0003%!\u000fC\u0003~\u0001\u0011\u0005a\u0010C\u0004\u0002\\\u0001!I!!\u0018\t\u000f\u0005u\u0004\u0001\"\u0001\u0002\u0000!9\u00111\u0016\u0001\u0005\u0002\u00055\u0006bBA]\u0001\u0011\u0005\u00111\u0018\u0002\f)&dWmU3sm&\u001cWM\u0003\u0002\u0016-\u000591/\u001a:wS\u000e,'BA\f\u0019\u0003%!\u0017m\u001d5c_\u0006\u0014HM\u0003\u0002\u001a5\u00059\u0001\u000f\\;hS:\u001c(BA\u000e\u001d\u0003%AHN]3mK\u0006\u001cXM\u0003\u0002\u001e=\u0005I\u00010\u001a2jC2\f'm\u001d\u0006\u0002?\u0005\u00191m\\7\u0004\u0001M\u0019\u0001A\t\u0015\u0011\u0005\r2S\"\u0001\u0013\u000b\u0003\u0015\nQa]2bY\u0006L!a\n\u0013\u0003\r\u0005s\u0017PU3g!\tIc&D\u0001+\u0015\tYC&A\u0003tY\u001a$$NC\u0001.\u0003!9'/\u001b>{Y\u0016$\u0017BA\u0018+\u0005\u001daunZ4j]\u001e\faB]3mK\u0006\u001cXmU3sm&\u001cW\r\u0005\u00023i5\t1G\u0003\u0002\u00165%\u0011Qg\r\u0002\u000f%\u0016dW-Y:f'\u0016\u0014h/[2f\u000351w\u000e\u001c3feN+'O^5dKB\u0011!\u0007O\u0005\u0003sM\u0012QBR8mI\u0016\u00148+\u001a:wS\u000e,\u0017a\u0004<be&\f'\r\\3TKJ4\u0018nY3\u0011\u0005Ib\u0014BA\u001f4\u0005=1\u0016M]5bE2,7+\u001a:wS\u000e,\u0017a\u00053bg\"\u0014w.\u0019:e%\u0016\u0004xn]5u_JL\bC\u0001!D\u001b\u0005\t%B\u0001\"\u0017\u0003)\u0011X\r]8tSR|'/_\u0005\u0003\t\u0006\u0013Q\u0004R3mK\u001e\fG/\u001b8h\t\u0006\u001c\bNY8be\u0012\u0014V\r]8tSR|'/_\u0001\u0013i&dWmU2sSB$X\t_3dkR|'\u000f\u0005\u0002H\u00116\tA#\u0003\u0002J)\t\u0011B+\u001b7f'\u000e\u0014\u0018\u000e\u001d;Fq\u0016\u001cW\u000f^8s\u0003-!X-Y7TKJ4\u0018nY3\u0011\u0005Ib\u0015BA'4\u0005-!V-Y7TKJ4\u0018nY3\u0002+\u0019|G\u000eZ3s-\u0006\u0014\u0018.\u00192mKN+'O^5dKB\u0011!\u0007U\u0005\u0003#N\u0012QCR8mI\u0016\u0014h+\u0019:jC\ndWmU3sm&\u001cW-\u0001\u000fd_:4\u0017nZ;sCRLwN\u001c,be&\f'\r\\3TKJ4\u0018nY3\u0011\u0005I\"\u0016BA+4\u0005q\u0019uN\u001c4jOV\u0014\u0018\r^5p]Z\u000b'/[1cY\u0016\u001cVM\u001d<jG\u0016\fa\u0001P5oSRtD#\u0003-Z5ncVLX0a!\t9\u0005\u0001C\u00031\u0013\u0001\u0007\u0011\u0007C\u00037\u0013\u0001\u0007q\u0007C\u0003;\u0013\u0001\u00071\bC\u0003?\u0013\u0001\u0007q\bC\u0003F\u0013\u0001\u0007a\tC\u0003K\u0013\u0001\u00071\nC\u0003O\u0013\u0001\u0007q\nC\u0003S\u0013\u0001\u00071\u000b\u000b\u0002\nEB\u00111M\\\u0007\u0002I*\u0011QMZ\u0001\u000bC:tw\u000e^1uS>t'BA4i\u0003\u001d1\u0017m\u0019;pefT!!\u001b6\u0002\u000b\t,\u0017M\\:\u000b\u0005-d\u0017aD:qe&twM\u001a:b[\u0016<xN]6\u000b\u00035\f1a\u001c:h\u0013\tyGMA\u0005BkR|w/\u001b:fI\u0006q1-Y2iK\n+8\u000f^3s\u0017\u0016LX#\u0001:\u0011\u0005MDX\"\u0001;\u000b\u0005U4\u0018\u0001\u00027b]\u001eT\u0011a^\u0001\u0005U\u00064\u0018-\u0003\u0002zi\n11\u000b\u001e:j]\u001e\fqbY1dQ\u0016\u0014Uo\u001d;fe.+\u0017\u0010I\u0001\u000be\u00164'/Z:i\u0017\u0016L\u0018a\u0003:fMJ,7\u000f[&fs\u0002\nQ#\u001a=fGV$X\rV5mK\u0012\u000bG/Y*de&\u0004H\u000fF\u0003\u0000\u0003\u000b\ti\u0002E\u0002$\u0003\u0003I1!a\u0001%\u0005\r\te.\u001f\u0005\b\u0003\u000fq\u0001\u0019AA\u0005\u0003\u0019!\u0018\u000e\\3JIB!\u00111BA\r\u001d\u0011\ti!!\u0006\u0011\u0007\u0005=A%\u0004\u0002\u0002\u0012)\u0019\u00111\u0003\u0011\u0002\rq\u0012xn\u001c;?\u0013\r\t9\u0002J\u0001\u0007!J,G-\u001a4\n\u0007e\fYBC\u0002\u0002\u0018\u0011Bq!a\b\u000f\u0001\u0004\t\t#A\nbI\u0012LG/[8oC24\u0016M]5bE2,7\u000fE\u0004\u0002\f\u0005\r\u0012\u0011B@\n\t\u0005\u0015\u00121\u0004\u0002\u0004\u001b\u0006\u0004\bf\u0001\b\u0002*A!\u00111FA\u001e\u001b\t\tiCC\u0002f\u0003_QA!!\r\u00024\u0005!1m\u001c:f\u0015\u0011\t)$a\u000e\u0002\u00155L7M]8nKR,'O\u0003\u0002\u0002:\u0005\u0011\u0011n\\\u0005\u0005\u0003{\tiCA\u0003US6,G\rK\u0003\u000f\u0003\u0003\nI\u0006E\u0003$\u0003\u0007\n9%C\u0002\u0002F\u0011\u0012a\u0001\u001e5s_^\u001c\b\u0003BA%\u0003'rA!a\u0013\u0002P9!\u0011qBA'\u0013\u0005)\u0013bAA)I\u00059\u0001/Y2lC\u001e,\u0017\u0002BA+\u0003/\u0012\u0011\"\u0012=dKB$\u0018n\u001c8\u000b\u0007\u0005ECe\t\u0002\u0002H\u0005Iq-\u001a;QCJ,g\u000e\u001e\u000b\u0005\u0003?\n\t\bE\u0003$\u0003C\n)'C\u0002\u0002d\u0011\u0012aa\u00149uS>t\u0007\u0003BA4\u0003[j!!!\u001b\u000b\u0007\u0005-$$\u0001\u0004e_6\f\u0017N\\\u0005\u0005\u0003_\nIGA\tWCJL\u0017M\u00197f\u0007>tG/Y5oKJDaaF\bA\u0002\u0005M\u0004\u0003BA;\u0003sj!!a\u001e\u000b\u0007\u0005-d#\u0003\u0003\u0002|\u0005]$!\u0003#bg\"\u0014w.\u0019:e\u000319W\r\u001e+jY\u0016$\u0016\u0010]3t)\u0011\t\t)a(\u0011\r\u0005%\u00131QAD\u0013\u0011\t))a\u0016\u0003\u0007M+\u0017\u000f\u0005\u0003\u0002\n\u0006mUBAAF\u0015\u0011\ti)a$\u0002\u000fI,g\r\\3di*!\u0011\u0011SAJ\u0003\r\t\u0007/\u001b\u0006\u0005\u0003+\u000b9*\u0001\u0004qYV<\u0017N\u001c\u0006\u0004\u00033c\u0012\u0001\u00033fa2|\u00170\u001b;\n\t\u0005u\u00151\u0012\u0002\u000b\t\u0016\u001c8M]5qi>\u0014\bbBAQ!\u0001\u0007\u00111U\u0001\u0006g\u000e|\u0007/\u001a\t\u0005\u0003k\n)+\u0003\u0003\u0002(\u0006]$!\u0003+jY\u0016\u001c6m\u001c9fQ\r\u0001\u0012\u0011F\u0001\rM&tG\rV5mK\nK\u0018\n\u001a\u000b\u0005\u0003_\u000b)\f\u0005\u0003\u0002v\u0005E\u0016\u0002BAZ\u0003o\u0012A\u0001V5mK\"9\u0011qA\tA\u0002\u0005%\u0001fA\t\u0002*\u0005QQ\u000f\u001d3bi\u0016$\u0016\u000e\\3\u0015\t\u0005=\u0016Q\u0018\u0005\b\u0003\u007f\u0013\u0002\u0019AAX\u0003\u0011!\u0018\u000e\\3)\u0007I\tI\u0003K\u0002\u0001\u0003\u000b\u0004B!a2\u0002N6\u0011\u0011\u0011\u001a\u0006\u0004\u0003\u0017T\u0017AC:uKJ,w\u000e^=qK&!\u0011qZAe\u0005\u001d\u0019VM\u001d<jG\u0016\u0004")
public class TileService
implements Logging {
    private final ReleaseService releaseService;
    private final FolderService folderService;
    private final VariableService variableService;
    private final DelegatingDashboardRepository dashboardRepository;
    private final TileScriptExecutor tileScriptExecutor;
    private final TeamService teamService;
    private final FolderVariableService folderVariableService;
    private final ConfigurationVariableService configurationVariableService;
    private final String cacheBusterKey;
    private final String refreshKey;
    private transient Logger grizzled$slf4j$Logging$$_logger;
    private volatile transient boolean bitmap$trans$0;

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        TileService tileService = this;
        synchronized (tileService) {
            if (!this.bitmap$trans$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        if (!this.bitmap$trans$0) {
            return this.grizzled$slf4j$Logging$$_logger$lzycompute();
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public String cacheBusterKey() {
        return this.cacheBusterKey;
    }

    public String refreshKey() {
        return this.refreshKey;
    }

    @Timed
    public Object executeTileDataScript(String tileId, Map<String, Object> additionalVariables) throws Exception {
        String dashboardId = Ids.getParentId((String)tileId);
        Dashboard dashboard = this.dashboardRepository.findDashboardById(dashboardId);
        Tile tile = dashboard.getTile(tileId);
        Option<VariableContainer> parent = this.getParent(dashboard);
        GlobalVariables globalVars = this.variableService.findGlobalVariablesOrEmpty();
        Seq globalVariables = CollectionConverters$.MODULE$.ListHasAsScala(globalVars.getVariables()).asScala().toSeq();
        Seq folderVariables = CollectionConverters$.MODULE$.ListHasAsScala(this.folderVariableService.getAllFromAncestry(Ids.findFolderId((String)dashboardId)).getVariables()).asScala().toSeq();
        Tile resolvedTile = TileHelper$.MODULE$.resolveVariables(tile, parent, (Seq<Variable>)((Seq)globalVariables.$plus$plus((IterableOnce)folderVariables)));
        Map variablesWithoutCacheBuster = (Map)additionalVariables.$minus((Object)this.cacheBusterKey()).$minus((Object)this.refreshKey());
        if (additionalVariables.contains((Object)this.refreshKey())) {
            this.tileScriptExecutor.evictFromCache(parent, resolvedTile, (Map<String, Object>)variablesWithoutCacheBuster);
        }
        this.configurationVariableService.resolveFromCi((ConfigurationItem)tile, globalVars, (Function1 & Serializable)x$1 -> CollectionConverters$.MODULE$.ListHasAsScala(x$1.getProperties()).asScala());
        return this.tileScriptExecutor.executeTileScript(parent, resolvedTile, (Map<String, Object>)variablesWithoutCacheBuster);
    }

    private Option<VariableContainer> getParent(Dashboard dashboard) {
        String string = (String)Option$.MODULE$.apply((Object)dashboard.getParentId()).getOrElse((Function0 & Serializable)() -> PermissionChecker$.MODULE$.GLOBAL_SECURITY_ALIAS());
        switch (string == null ? 0 : string.hashCode()) {
            default: 
        }
        if (Ids.isReleaseId((String)string)) {
            Release release = this.releaseService.findByIdIncludingArchived(string);
            this.teamService.decorateWithEffectiveTeams(release);
            return new Some((Object)release);
        }
        if (Ids.isFolderId((String)string)) {
            Folder folder = this.folderService.findById(string, Predef$.MODULE$.int2Integer(0));
            return new Some((Object)folder);
        }
        return None$.MODULE$;
    }

    @Timed
    public Seq<Descriptor> getTileTypes(TileScope scope) {
        return (Seq)((IterableOnceOps)((IterableOps)CollectionConverters$.MODULE$.CollectionHasAsScala(DescriptorRegistry.getSubtypes((Type)Type.valueOf(Tile.class))).asScala().map((Function1 & Serializable)x$2 -> x$2.getDescriptor())).filter((Function1 & Serializable)desc -> BoxesRunTime.boxToBoolean((boolean)TileService.$anonfun$getTileTypes$2(scope, desc)))).toList().sortBy((Function1 & Serializable)x$3 -> x$3.getLabel(), (Ordering)Ordering.String$.MODULE$);
    }

    @Timed
    public Tile findTileById(String tileId) {
        return this.dashboardRepository.findTileById(tileId);
    }

    @Timed
    public Tile updateTile(Tile tile) {
        Tile original = this.findTileById(tile.getId());
        PasswordVerificationUtils$.MODULE$.replacePasswordPropertiesInCiIfNeeded((Option)new Some((Object)original), (ConfigurationItem)tile);
        return this.dashboardRepository.updateTile(tile);
    }

    public static final /* synthetic */ boolean $anonfun$getTileTypes$2(TileScope scope$1, Descriptor desc) {
        return !desc.isVirtual() && ((Tile)desc.newInstance("dummy")).isSupportedOn(scope$1);
    }

    @Autowired
    public TileService(ReleaseService releaseService, FolderService folderService, VariableService variableService, DelegatingDashboardRepository dashboardRepository, TileScriptExecutor tileScriptExecutor, TeamService teamService, FolderVariableService folderVariableService, ConfigurationVariableService configurationVariableService) {
        this.releaseService = releaseService;
        this.folderService = folderService;
        this.variableService = variableService;
        this.dashboardRepository = dashboardRepository;
        this.tileScriptExecutor = tileScriptExecutor;
        this.teamService = teamService;
        this.folderVariableService = folderVariableService;
        this.configurationVariableService = configurationVariableService;
        Logging.$init$((Logging)this);
        this.cacheBusterKey = "cb";
        this.refreshKey = "refresh";
    }
}

