/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.cluster.typed.internal.receptionist;

import com.typesafe.config.Config;
import java.io.Serializable;
import java.util.Locale;
import java.util.concurrent.TimeUnit;
import org.apache.pekko.actor.typed.ActorSystem;
import org.apache.pekko.annotation.InternalApi;
import org.apache.pekko.cluster.ddata.Replicator;
import org.apache.pekko.cluster.ddata.Replicator$;
import org.apache.pekko.cluster.ddata.Replicator$WriteLocal$;
import org.apache.pekko.cluster.ddata.ReplicatorSettings;
import org.apache.pekko.cluster.ddata.ReplicatorSettings$;
import org.apache.pekko.cluster.typed.internal.receptionist.ClusterReceptionistSettings;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple5;
import scala.concurrent.duration.FiniteDuration;
import scala.concurrent.duration.package;
import scala.concurrent.duration.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;

@InternalApi
public final class ClusterReceptionistSettings$
implements Serializable {
    public static final ClusterReceptionistSettings$ MODULE$ = new ClusterReceptionistSettings$();

    public ClusterReceptionistSettings apply(ActorSystem<?> system) {
        return this.apply(system.settings().config().getConfig("pekko.cluster.typed.receptionist"));
    }

    /*
     * Enabled aggressive block sorting
     */
    public ClusterReceptionistSettings apply(Config config) {
        Replicator.WriteTo writeTo;
        block5: {
            FiniteDuration writeTimeout = new package.DurationInt(package$.MODULE$.DurationInt(5)).seconds();
            String key = "write-consistency";
            String string = config.getString(key).toLowerCase(Locale.ROOT);
            switch (string == null ? 0 : string.hashCode()) {
                case 96673: {
                    if (!"all".equals(string)) break;
                    writeTo = new Replicator.WriteAll(writeTimeout);
                    break block5;
                }
                case 22010965: {
                    if (!"majority".equals(string)) break;
                    writeTo = new Replicator.WriteMajority(writeTimeout, Replicator$.MODULE$.DefaultMajorityMinCap());
                    break block5;
                }
                case 103145323: {
                    if (!"local".equals(string)) break;
                    writeTo = Replicator$WriteLocal$.MODULE$;
                    break block5;
                }
            }
            writeTo = new Replicator.WriteTo(config.getInt(key), writeTimeout);
        }
        Replicator.WriteTo writeConsistency = writeTo;
        ReplicatorSettings replicatorSettingsWithoutDurableStore = ReplicatorSettings$.MODULE$.apply(config.getConfig("distributed-data")).withDurableKeys(Predef$.MODULE$.Set().empty());
        return new ClusterReceptionistSettings((Replicator.WriteConsistency)writeConsistency, new package.DurationLong(package$.MODULE$.DurationLong(config.getDuration("pruning-interval", TimeUnit.MILLISECONDS))).millis(), new package.DurationLong(package$.MODULE$.DurationLong(config.getDuration("prune-removed-older-than", TimeUnit.MILLISECONDS))).millis(), config.getInt("distributed-key-count"), replicatorSettingsWithoutDurableStore);
    }

    public ClusterReceptionistSettings apply(Replicator.WriteConsistency writeConsistency, FiniteDuration pruningInterval, FiniteDuration pruneRemovedOlderThan, int distributedKeyCount, ReplicatorSettings replicatorSettings) {
        return new ClusterReceptionistSettings(writeConsistency, pruningInterval, pruneRemovedOlderThan, distributedKeyCount, replicatorSettings);
    }

    public Option<Tuple5<Replicator.WriteConsistency, FiniteDuration, FiniteDuration, Object, ReplicatorSettings>> unapply(ClusterReceptionistSettings x$0) {
        if (x$0 == null) {
            return None$.MODULE$;
        }
        return new Some((Object)new Tuple5((Object)x$0.writeConsistency(), (Object)x$0.pruningInterval(), (Object)x$0.pruneRemovedOlderThan(), (Object)BoxesRunTime.boxToInteger((int)x$0.distributedKeyCount()), (Object)x$0.replicatorSettings()));
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(ClusterReceptionistSettings$.class);
    }

    private ClusterReceptionistSettings$() {
    }
}

