/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.github;

import java.io.IOException;
import java.time.Duration;
import javax.annotation.Nonnull;
import org.kohsuke.github.GitHubConnectorResponseErrorHandler;
import org.kohsuke.github.HttpException;
import org.kohsuke.github.connector.GitHubConnectorResponse;

public abstract class GitHubAbuseLimitHandler
extends GitHubConnectorResponseErrorHandler {
    private static final int MINIMUM_ABUSE_RETRY_MILLIS = 1000;
    public static final GitHubAbuseLimitHandler WAIT = new GitHubAbuseLimitHandler(){

        @Override
        public void onError(GitHubConnectorResponse connectorResponse) throws IOException {
            1.sleep(1.parseWaitTime(connectorResponse));
        }
    };
    public static final GitHubAbuseLimitHandler FAIL = new GitHubAbuseLimitHandler(){

        @Override
        public void onError(GitHubConnectorResponse connectorResponse) throws IOException {
            throw new HttpException("Abuse limit reached", connectorResponse.statusCode(), connectorResponse.header("Status"), connectorResponse.request().url().toString()).withResponseHeaderFields(connectorResponse.allHeaders());
        }
    };
    static long DEFAULT_WAIT_MILLIS = Duration.ofSeconds(61L).toMillis();

    @Override
    boolean isError(@Nonnull GitHubConnectorResponse connectorResponse) {
        return this.isTooManyRequests(connectorResponse) || this.isForbidden(connectorResponse) && this.hasRetryOrLimitHeader(connectorResponse);
    }

    private boolean isTooManyRequests(GitHubConnectorResponse connectorResponse) {
        return connectorResponse.statusCode() == 429;
    }

    private boolean isForbidden(GitHubConnectorResponse connectorResponse) {
        return connectorResponse.statusCode() == 403;
    }

    private boolean hasRetryOrLimitHeader(GitHubConnectorResponse connectorResponse) {
        return this.hasHeader(connectorResponse, "Retry-After") || this.hasHeader(connectorResponse, "gh-limited-by");
    }

    private boolean hasHeader(GitHubConnectorResponse connectorResponse, String headerName) {
        return connectorResponse.header(headerName) != null;
    }

    @Override
    public abstract void onError(@Nonnull GitHubConnectorResponse var1) throws IOException;

    static long parseWaitTime(GitHubConnectorResponse connectorResponse) {
        return GitHubAbuseLimitHandler.parseWaitTime(connectorResponse.header("Retry-After"), connectorResponse.header("Date"), DEFAULT_WAIT_MILLIS, 1000L);
    }
}

