/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.http.scaladsl.server.directives;

import java.io.File;
import java.io.Serializable;
import org.apache.pekko.http.impl.util.EnhancedString$;
import org.apache.pekko.http.scaladsl.marshalling.ContentTypeOverrider;
import org.apache.pekko.http.scaladsl.marshalling.Marshaller;
import org.apache.pekko.http.scaladsl.marshalling.Marshaller$;
import org.apache.pekko.http.scaladsl.marshalling.Marshalling;
import org.apache.pekko.http.scaladsl.model.ContentType;
import org.apache.pekko.http.scaladsl.model.DateTime$;
import org.apache.pekko.http.scaladsl.model.MediaType;
import org.apache.pekko.http.scaladsl.model.MediaTypes$;
import org.apache.pekko.http.scaladsl.model.RequestEntity;
import org.apache.pekko.http.scaladsl.server.directives.DirectoryListing;
import org.apache.pekko.http.scaladsl.util.FastFuture$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.SeqOps;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.math.Ordering;
import scala.math.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ScalaRunTime$;
import scala.util.control.NonFatal$;

public final class DirectoryListing$
implements Serializable {
    public static final DirectoryListing$ MODULE$ = new DirectoryListing$();
    private static final String[] html = StringOps$.MODULE$.split$extension(Predef$.MODULE$.augmentString(EnhancedString$.MODULE$.stripMarginWithNewline$extension(org.apache.pekko.http.impl.util.package$.MODULE$.enhanceString_("<html>\n      |<head><title>Index of $</title></head>\n      |<body>\n      |<h1>Index of $</h1>\n      |<hr>\n      |<pre>\n      |$</pre>\n      |<hr>$\n      |<div style=\"width:100%;text-align:right;color:gray\">\n      |<small>rendered by <a href=\"https://pekko.apache.org\">Pekko Http</a> on $</small>\n      |</div>$\n      |</body>\n      |</html>\n      |"), "\n")), '$');

    private String[] html() {
        return html;
    }

    /*
     * WARNING - void declaration
     */
    public Marshaller<DirectoryListing, RequestEntity> directoryMarshaller(boolean renderVanityFooter) {
        void wrap_mto;
        void wrap_newMediaType;
        void wrap_f;
        Marshaller<String, RequestEntity> marshaller = Marshaller$.MODULE$.StringMarshaller();
        ContentTypeOverrider contentTypeOverrider = new ContentTypeOverrider<T>(){

            public T apply(T value, ContentType newContentType) {
                return (T)value.withContentType(newContentType);
            }
        };
        Function1 & Serializable intersect = (Function1 & Serializable)listing -> {
            void var3_3;
            void var2_2;
            void var8_8;
            void var7_7;
            void var4_4;
            if (listing == null) {
                throw new MatchError(null);
            }
            String path = listing.path();
            boolean isRoot = listing.isRoot();
            Seq<File> files = listing.files();
            Seq filesAndNames = (Seq)((SeqOps)var4_4.map((Function1 & Serializable)file -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(file), (Object)file.getName()))).sortBy((Function1 & Serializable)x$6 -> (String)x$6._2(), (Ordering)Ordering.String$.MODULE$);
            Tuple2 tuple2 = ((Seq)((IterableOps)filesAndNames.zipWithIndex()).flatMap((Function1 & Serializable)x0$1 -> {
                block2: {
                    block4: {
                        Tuple2 fan;
                        block3: {
                            if (x0$1 == null) break block2;
                            fan = (Tuple2)x0$1._1();
                            int ix = x0$1._2$mcI$sp();
                            if (fan == null) break block2;
                            String name = (String)fan._2();
                            if (ix == 0) break block3;
                            Object object = ((Tuple2)filesAndNames.apply(ix - 1))._2();
                            if (!(object == null ? name != null : !object.equals(name))) break block4;
                        }
                        return new Some((Object)fan);
                    }
                    return None$.MODULE$;
                }
                throw new MatchError(x0$1);
            })).partition((Function1 & Serializable)x$7 -> BoxesRunTime.boxToBoolean((boolean)DirectoryListing$.$anonfun$directoryMarshaller$7(x$7)));
            if (tuple2 == null) {
                throw new MatchError(null);
            }
            Seq directoryFilesAndNames = (Seq)tuple2._1();
            Seq fileFilesAndNames = (Seq)tuple2._2();
            int maxNameLen = package$.MODULE$.max(DirectoryListing$.maxNameLength$1((Seq)var7_7) + 1, DirectoryListing$.maxNameLength$1((Seq)var8_8));
            StringBuilder sb = new StringBuilder();
            sb.append(MODULE$.html()[0]).append((String)var2_2).append(MODULE$.html()[1]).append((String)var2_2).append(MODULE$.html()[2]);
            if (var3_3 == false) {
                int secondToLastSlash = var2_2.lastIndexOf(47, var2_2.lastIndexOf(47, var2_2.length() - 1) - 1);
                sb.append(StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("<a href=\"%s/\">../</a>\n"), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{var2_2.substring(0, secondToLastSlash)})));
            }
            var7_7.withFilter((Function1 & Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)DirectoryListing$.$anonfun$directoryMarshaller$9(check$ifrefutable$1))).foreach(arg_0 -> DirectoryListing$.$anonfun$directoryMarshaller$10(sb, (String)var2_2, maxNameLen, arg_0));
            var8_8.withFilter((Function1 & Serializable)check$ifrefutable$2 -> BoxesRunTime.boxToBoolean((boolean)DirectoryListing$.$anonfun$directoryMarshaller$11(check$ifrefutable$2))).foreach(arg_0 -> DirectoryListing$.$anonfun$directoryMarshaller$12(sb, (String)var2_2, maxNameLen, arg_0));
            if (var3_3 != false && var4_4.isEmpty()) {
                sb.append("(no files)\n");
            }
            sb.append(MODULE$.html()[3]);
            if (renderVanityFooter) {
                sb.append(MODULE$.html()[4]).append(DateTime$.MODULE$.now().toIsoLikeDateTimeString()).append(MODULE$.html()[5]);
            }
            return sb.append(MODULE$.html()[6]).toString();
        };
        MediaType.WithOpenCharset withOpenCharset = MediaTypes$.MODULE$.text$divhtml();
        if (marshaller == null) {
            throw null;
        }
        Marshaller<String, RequestEntity> wrap_this = marshaller;
        Function1 & Serializable wrap_wrapWithEC_f = arg_0 -> Marshaller.$anonfun$wrap$1((Function1)wrap_f, arg_0);
        Function1 & Serializable wrap_wrapWithEC_apply_f = arg_0 -> Marshaller.$anonfun$wrapWithEC$1(wrap_this, wrap_wrapWithEC_f, (MediaType)wrap_newMediaType, (ContentTypeOverrider)wrap_mto, arg_0);
        return new Marshaller<A, B>(wrap_wrapWithEC_apply_f){
            private final Function1 f$6;

            public Future<List<Marshalling<B>>> apply(A value, ExecutionContext ec) {
                try {
                    return (Future)((Function1)this.f$6.apply((Object)ec)).apply(value);
                }
                catch (Throwable throwable) {
                    if (NonFatal$.MODULE$.apply(throwable)) {
                        return (Future)FastFuture$.MODULE$.failed().apply((Object)throwable);
                    }
                    throw throwable;
                }
            }
            {
                this.f$6 = f$6;
            }
        };
    }

    public DirectoryListing apply(String path, boolean isRoot, Seq<File> files) {
        return new DirectoryListing(path, isRoot, files);
    }

    public Option<Tuple3<String, Object, Seq<File>>> unapply(DirectoryListing x$0) {
        if (x$0 == null) {
            return None$.MODULE$;
        }
        return new Some((Object)new Tuple3((Object)x$0.path(), (Object)BoxesRunTime.boxToBoolean((boolean)x$0.isRoot()), x$0.files()));
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(DirectoryListing$.class);
    }

    public static final /* synthetic */ boolean $anonfun$directoryMarshaller$7(Tuple2 x$7) {
        return ((File)x$7._1()).isDirectory();
    }

    public static final /* synthetic */ int $anonfun$directoryMarshaller$8(Tuple2 x$9) {
        return ((String)x$9._2()).length();
    }

    private static final int maxNameLength$1(Seq seq) {
        if (seq.isEmpty()) {
            return 0;
        }
        return BoxesRunTime.unboxToInt((Object)((IterableOnceOps)seq.map((Function1 & Serializable)x$9 -> BoxesRunTime.boxToInteger((int)DirectoryListing$.$anonfun$directoryMarshaller$8(x$9)))).max((Ordering)Ordering.Int$.MODULE$));
    }

    private static final String lastModified$2(File file) {
        return DateTime$.MODULE$.apply(file.lastModified()).toIsoLikeDateTimeString();
    }

    private static final StringBuilder start$1(String name, StringBuilder sb$1, String path$3, int maxNameLen$1) {
        return sb$1.append("<a href=\"").append(new StringBuilder(0).append(path$3).append(name).toString()).append("\">").append(name).append("</a>").append(StringOps$.MODULE$.$times$extension(Predef$.MODULE$.augmentString(" "), maxNameLen$1 - name.length()));
    }

    private static final StringBuilder renderDirectory$1(File file, String name, StringBuilder sb$1, String path$3, int maxNameLen$1) {
        return DirectoryListing$.start$1(new StringBuilder(11).append(name).append('/').toString(), sb$1, path$3, maxNameLen$1).append("        ").append(DirectoryListing$.lastModified$2(file)).append('\n');
    }

    private static final StringBuilder renderFile$1(File file, String name, StringBuilder sb$1, String path$3, int maxNameLen$1) {
        String size = org.apache.pekko.http.impl.util.package$.MODULE$.humanReadableByteCount(file.length(), true);
        DirectoryListing$.start$1(name, sb$1, path$3, maxNameLen$1).append("        ").append(DirectoryListing$.lastModified$2(file));
        return sb$1.append("                ".substring(size.length())).append(size).append('\n');
    }

    public static final /* synthetic */ boolean $anonfun$directoryMarshaller$9(Tuple2 check$ifrefutable$1) {
        return check$ifrefutable$1 != null;
    }

    public static final /* synthetic */ StringBuilder $anonfun$directoryMarshaller$10(StringBuilder sb$1, String path$3, int maxNameLen$1, Tuple2 x$10) {
        if (x$10 != null) {
            File file = (File)x$10._1();
            String name = (String)x$10._2();
            return DirectoryListing$.renderDirectory$1(file, name, sb$1, path$3, maxNameLen$1);
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ boolean $anonfun$directoryMarshaller$11(Tuple2 check$ifrefutable$2) {
        return check$ifrefutable$2 != null;
    }

    public static final /* synthetic */ StringBuilder $anonfun$directoryMarshaller$12(StringBuilder sb$1, String path$3, int maxNameLen$1, Tuple2 x$11) {
        if (x$11 != null) {
            File file = (File)x$11._1();
            String name = (String)x$11._2();
            return DirectoryListing$.renderFile$1(file, name, sb$1, path$3, maxNameLen$1);
        }
        throw new MatchError(null);
    }

    private DirectoryListing$() {
    }
}

