import { call } from 'redux-saga/effects';
import { SagaIterator } from 'redux-saga';
import { DEFAULT_FILTER_SETTINGS, SYSTEM_USER } from '../constants';
import getAngularService from '@xlr-ui/app/features/common/services/angular-accessor';
import { updateClientSettingsAndUrl } from './saga';

describe('common logs saga', () => {
    const containerId = '123';
    const filterSettingsMock = { ...DEFAULT_FILTER_SETTINGS, usernames: [SYSTEM_USER, 'admin', 'i do not exist'] };

    describe('updateClientSettingsAndUrl', () => {
        const FiltersQueryParams = {
            update: jest.fn(),
        };
        const ClientSettings = {
            setLogsFilters: jest.fn(),
        };
        it('should call proper generators ', () => {
            const generator: SagaIterator = updateClientSettingsAndUrl('123', filterSettingsMock);
            expect(generator.next().value).toStrictEqual(call(getAngularService, 'FiltersQueryParams'));
            expect(generator.next(FiltersQueryParams).value).toStrictEqual(call(getAngularService, 'ClientSettings'));
            expect(generator.next(ClientSettings).done).toBe(true);
            expect(FiltersQueryParams.update).toHaveBeenCalledWith(filterSettingsMock);
            expect(ClientSettings.setLogsFilters).toHaveBeenCalledWith(containerId, filterSettingsMock);
        });
    });
});
